/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athenastreaming.endpoints.internal;

import java.net.URI;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.endpoints.AwsEndpointAttribute;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.endpoints.Endpoint;
import software.amazon.awssdk.services.athenastreaming.endpoints.AthenaStreamingEndpointParams;
import software.amazon.awssdk.services.athenastreaming.endpoints.AthenaStreamingEndpointProvider;
import software.amazon.awssdk.services.athenastreaming.endpoints.internal.Condition;
import software.amazon.awssdk.services.athenastreaming.endpoints.internal.DefaultEndpointAuthSchemeStrategyFactory;
import software.amazon.awssdk.services.athenastreaming.endpoints.internal.DefaultRuleEngine;
import software.amazon.awssdk.services.athenastreaming.endpoints.internal.EndpointAuthSchemeStrategy;
import software.amazon.awssdk.services.athenastreaming.endpoints.internal.EndpointResult;
import software.amazon.awssdk.services.athenastreaming.endpoints.internal.EndpointRuleset;
import software.amazon.awssdk.services.athenastreaming.endpoints.internal.Expr;
import software.amazon.awssdk.services.athenastreaming.endpoints.internal.FnNode;
import software.amazon.awssdk.services.athenastreaming.endpoints.internal.Identifier;
import software.amazon.awssdk.services.athenastreaming.endpoints.internal.Parameter;
import software.amazon.awssdk.services.athenastreaming.endpoints.internal.ParameterType;
import software.amazon.awssdk.services.athenastreaming.endpoints.internal.Parameters;
import software.amazon.awssdk.services.athenastreaming.endpoints.internal.Rule;
import software.amazon.awssdk.services.athenastreaming.endpoints.internal.Value;
import software.amazon.awssdk.utils.CompletableFutureUtils;
import software.amazon.awssdk.utils.Logger;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public final class DefaultAthenaStreamingEndpointProvider
implements AthenaStreamingEndpointProvider {
    private static final Logger LOG = Logger.loggerFor(DefaultAthenaStreamingEndpointProvider.class);
    private static final EndpointRuleset ENDPOINT_RULE_SET = DefaultAthenaStreamingEndpointProvider.ruleSet();
    private final EndpointAuthSchemeStrategy endpointAuthSchemeStrategy;

    public DefaultAthenaStreamingEndpointProvider() {
        DefaultEndpointAuthSchemeStrategyFactory endpointAuthSchemeStrategyFactory = new DefaultEndpointAuthSchemeStrategyFactory();
        this.endpointAuthSchemeStrategy = endpointAuthSchemeStrategyFactory.endpointAuthSchemeStrategy();
    }

    @Override
    public CompletableFuture<Endpoint> resolveEndpoint(AthenaStreamingEndpointParams endpointParams) {
        Validate.notNull(endpointParams.region(), "Parameter 'Region' must not be null", new Object[0]);
        Value res = new DefaultRuleEngine().evaluate(ENDPOINT_RULE_SET, DefaultAthenaStreamingEndpointProvider.toIdentifierValueMap(endpointParams));
        try {
            return CompletableFuture.completedFuture(this.valueAsEndpointOrThrow(res));
        }
        catch (Exception error) {
            return CompletableFutureUtils.failedFuture(error);
        }
    }

    private static Map<Identifier, Value> toIdentifierValueMap(AthenaStreamingEndpointParams params) {
        HashMap<Identifier, Value> paramsMap = new HashMap<Identifier, Value>();
        if (params.region() != null) {
            paramsMap.put(Identifier.of("Region"), Value.fromStr(params.region().id()));
        }
        if (params.endpoint() != null) {
            paramsMap.put(Identifier.of("Endpoint"), Value.fromStr(params.endpoint()));
        }
        return paramsMap;
    }

    Endpoint valueAsEndpointOrThrow(Value value) {
        if (value instanceof Value.Endpoint) {
            Value.Endpoint endpoint = value.expectEndpoint();
            Endpoint.Builder builder = Endpoint.builder();
            builder.url(URI.create(endpoint.getUrl()));
            Map<String, List<String>> headers = endpoint.getHeaders();
            if (headers != null) {
                headers.forEach((name, values) -> values.forEach(v -> builder.putHeader((String)name, (String)v)));
            }
            this.addKnownProperties(builder, endpoint.getProperties());
            return builder.build();
        }
        if (value instanceof Value.Str) {
            String errorMsg = value.expectString();
            if (errorMsg.contains("Invalid ARN") && errorMsg.contains(":s3:::")) {
                errorMsg = errorMsg + ". Use the bucket name instead of simple bucket ARNs in GetBucketLocationRequest.";
            }
            throw SdkClientException.create(errorMsg);
        }
        throw SdkClientException.create("Rule engine return neither an endpoint result or error value. Returned value was: " + value);
    }

    private static Rule endpointRule_0() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.ref(Identifier.of("Endpoint"))).build());
    }

    private static Rule endpointRule_1() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("aws.partition").argv(Arrays.asList(Expr.ref(Identifier.of("Region")))).build().validate()).result("PartitionResult").build()).endpoint(EndpointResult.builder().url(Expr.of("https://athenastreaming.{Region}.{PartitionResult#dnsSuffix}")).build());
    }

    private static EndpointRuleset ruleSet() {
        return EndpointRuleset.builder().version("1.0").serviceId(null).parameters(Parameters.builder().addParameter(Parameter.builder().name("Region").type(ParameterType.fromValue("String")).required(true).builtIn("AWS::Region").documentation("The AWS region used to dispatch the request, if the endpoint is not specified.").build()).addParameter(Parameter.builder().name("Endpoint").type(ParameterType.fromValue("String")).required(false).builtIn("SDK::Endpoint").documentation("Override the endpoint used to send this request").build()).build()).addRule(DefaultAthenaStreamingEndpointProvider.endpointRule_0()).addRule(DefaultAthenaStreamingEndpointProvider.endpointRule_1()).build();
    }

    public boolean equals(Object rhs) {
        return rhs != null && this.getClass().equals(rhs.getClass());
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    private void addKnownProperties(Endpoint.Builder builder, Map<String, Value> properties) {
        properties.forEach((n, v) -> {
            switch (n) {
                case "authSchemes": {
                    builder.putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, this.endpointAuthSchemeStrategy.createAuthSchemes((Value)v));
                    break;
                }
                default: {
                    LOG.debug(() -> "Ignoring unknown endpoint property: " + n);
                }
            }
        });
    }
}

