/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.datazone.model.ColumnFilterConfiguration;
import software.amazon.awssdk.services.datazone.model.RowFilterConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssetFilterConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AssetFilterConfiguration> {
    private static final SdkField<ColumnFilterConfiguration> COLUMN_CONFIGURATION_FIELD = SdkField.builder(MarshallingType.SDK_POJO).memberName("columnConfiguration").getter(AssetFilterConfiguration.getter(AssetFilterConfiguration::columnConfiguration)).setter(AssetFilterConfiguration.setter(Builder::columnConfiguration)).constructor(ColumnFilterConfiguration::builder).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("columnConfiguration").build()).build();
    private static final SdkField<RowFilterConfiguration> ROW_CONFIGURATION_FIELD = SdkField.builder(MarshallingType.SDK_POJO).memberName("rowConfiguration").getter(AssetFilterConfiguration.getter(AssetFilterConfiguration::rowConfiguration)).setter(AssetFilterConfiguration.setter(Builder::rowConfiguration)).constructor(RowFilterConfiguration::builder).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rowConfiguration").build()).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLUMN_CONFIGURATION_FIELD, ROW_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AssetFilterConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final ColumnFilterConfiguration columnConfiguration;
    private final RowFilterConfiguration rowConfiguration;
    private final Type type;

    private AssetFilterConfiguration(BuilderImpl builder) {
        this.columnConfiguration = builder.columnConfiguration;
        this.rowConfiguration = builder.rowConfiguration;
        this.type = builder.type;
    }

    public final ColumnFilterConfiguration columnConfiguration() {
        return this.columnConfiguration;
    }

    public final RowFilterConfiguration rowConfiguration() {
        return this.rowConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.columnConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.rowConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssetFilterConfiguration)) {
            return false;
        }
        AssetFilterConfiguration other = (AssetFilterConfiguration)obj;
        return Objects.equals(this.columnConfiguration(), other.columnConfiguration()) && Objects.equals(this.rowConfiguration(), other.rowConfiguration());
    }

    public final String toString() {
        return ToString.builder("AssetFilterConfiguration").add("ColumnConfiguration", this.columnConfiguration()).add("RowConfiguration", this.rowConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "columnConfiguration": {
                return Optional.ofNullable(clazz.cast(this.columnConfiguration()));
            }
            case "rowConfiguration": {
                return Optional.ofNullable(clazz.cast(this.rowConfiguration()));
            }
        }
        return Optional.empty();
    }

    public static AssetFilterConfiguration fromColumnConfiguration(ColumnFilterConfiguration columnConfiguration) {
        return (AssetFilterConfiguration)AssetFilterConfiguration.builder().columnConfiguration(columnConfiguration).build();
    }

    public static AssetFilterConfiguration fromColumnConfiguration(Consumer<ColumnFilterConfiguration.Builder> columnConfiguration) {
        ColumnFilterConfiguration.Builder builder = ColumnFilterConfiguration.builder();
        columnConfiguration.accept(builder);
        return AssetFilterConfiguration.fromColumnConfiguration((ColumnFilterConfiguration)builder.build());
    }

    public static AssetFilterConfiguration fromRowConfiguration(RowFilterConfiguration rowConfiguration) {
        return (AssetFilterConfiguration)AssetFilterConfiguration.builder().rowConfiguration(rowConfiguration).build();
    }

    public static AssetFilterConfiguration fromRowConfiguration(Consumer<RowFilterConfiguration.Builder> rowConfiguration) {
        RowFilterConfiguration.Builder builder = RowFilterConfiguration.builder();
        rowConfiguration.accept(builder);
        return AssetFilterConfiguration.fromRowConfiguration((RowFilterConfiguration)builder.build());
    }

    public Type type() {
        return this.type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<SdkPojo>> map = new HashMap<String, SdkField<SdkPojo>>();
        map.put("columnConfiguration", COLUMN_CONFIGURATION_FIELD);
        map.put("rowConfiguration", ROW_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AssetFilterConfiguration, T> g) {
        return obj -> g.apply((AssetFilterConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private ColumnFilterConfiguration columnConfiguration;
        private RowFilterConfiguration rowConfiguration;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(AssetFilterConfiguration model) {
            this.columnConfiguration(model.columnConfiguration);
            this.rowConfiguration(model.rowConfiguration);
        }

        public final ColumnFilterConfiguration.Builder getColumnConfiguration() {
            return this.columnConfiguration != null ? this.columnConfiguration.toBuilder() : null;
        }

        public final void setColumnConfiguration(ColumnFilterConfiguration.BuilderImpl columnConfiguration) {
            ColumnFilterConfiguration oldValue = this.columnConfiguration;
            this.columnConfiguration = columnConfiguration != null ? columnConfiguration.build() : null;
            this.handleUnionValueChange(Type.COLUMN_CONFIGURATION, oldValue, this.columnConfiguration);
        }

        @Override
        public final Builder columnConfiguration(ColumnFilterConfiguration columnConfiguration) {
            ColumnFilterConfiguration oldValue = this.columnConfiguration;
            this.columnConfiguration = columnConfiguration;
            this.handleUnionValueChange(Type.COLUMN_CONFIGURATION, oldValue, this.columnConfiguration);
            return this;
        }

        public final RowFilterConfiguration.Builder getRowConfiguration() {
            return this.rowConfiguration != null ? this.rowConfiguration.toBuilder() : null;
        }

        public final void setRowConfiguration(RowFilterConfiguration.BuilderImpl rowConfiguration) {
            RowFilterConfiguration oldValue = this.rowConfiguration;
            this.rowConfiguration = rowConfiguration != null ? rowConfiguration.build() : null;
            this.handleUnionValueChange(Type.ROW_CONFIGURATION, oldValue, this.rowConfiguration);
        }

        @Override
        public final Builder rowConfiguration(RowFilterConfiguration rowConfiguration) {
            RowFilterConfiguration oldValue = this.rowConfiguration;
            this.rowConfiguration = rowConfiguration;
            this.handleUnionValueChange(Type.ROW_CONFIGURATION, oldValue, this.rowConfiguration);
            return this;
        }

        @Override
        public AssetFilterConfiguration build() {
            return new AssetFilterConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static enum Type {
        COLUMN_CONFIGURATION,
        ROW_CONFIGURATION,
        UNKNOWN_TO_SDK_VERSION;

    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AssetFilterConfiguration> {
        public Builder columnConfiguration(ColumnFilterConfiguration var1);

        default public Builder columnConfiguration(Consumer<ColumnFilterConfiguration.Builder> columnConfiguration) {
            return this.columnConfiguration((ColumnFilterConfiguration)ColumnFilterConfiguration.builder().applyMutation(columnConfiguration).build());
        }

        public Builder rowConfiguration(RowFilterConfiguration var1);

        default public Builder rowConfiguration(Consumer<RowFilterConfiguration.Builder> rowConfiguration) {
            return this.rowConfiguration((RowFilterConfiguration)RowFilterConfiguration.builder().applyMutation(rowConfiguration).build());
        }
    }
}

