/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ConnectionCredentials
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ConnectionCredentials> {
    private static final SdkField<String> ACCESS_KEY_ID_FIELD = SdkField.builder(MarshallingType.STRING).memberName("accessKeyId").getter(ConnectionCredentials.getter(ConnectionCredentials::accessKeyId)).setter(ConnectionCredentials.setter(Builder::accessKeyId)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accessKeyId").build()).build();
    private static final SdkField<Instant> EXPIRATION_FIELD = SdkField.builder(MarshallingType.INSTANT).memberName("expiration").getter(ConnectionCredentials.getter(ConnectionCredentials::expiration)).setter(ConnectionCredentials.setter(Builder::expiration)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("expiration").build(), TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();
    private static final SdkField<String> SECRET_ACCESS_KEY_FIELD = SdkField.builder(MarshallingType.STRING).memberName("secretAccessKey").getter(ConnectionCredentials.getter(ConnectionCredentials::secretAccessKey)).setter(ConnectionCredentials.setter(Builder::secretAccessKey)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("secretAccessKey").build()).build();
    private static final SdkField<String> SESSION_TOKEN_FIELD = SdkField.builder(MarshallingType.STRING).memberName("sessionToken").getter(ConnectionCredentials.getter(ConnectionCredentials::sessionToken)).setter(ConnectionCredentials.setter(Builder::sessionToken)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionToken").build()).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESS_KEY_ID_FIELD, EXPIRATION_FIELD, SECRET_ACCESS_KEY_FIELD, SESSION_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ConnectionCredentials.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String accessKeyId;
    private final Instant expiration;
    private final String secretAccessKey;
    private final String sessionToken;

    private ConnectionCredentials(BuilderImpl builder) {
        this.accessKeyId = builder.accessKeyId;
        this.expiration = builder.expiration;
        this.secretAccessKey = builder.secretAccessKey;
        this.sessionToken = builder.sessionToken;
    }

    public final String accessKeyId() {
        return this.accessKeyId;
    }

    public final Instant expiration() {
        return this.expiration;
    }

    public final String secretAccessKey() {
        return this.secretAccessKey;
    }

    public final String sessionToken() {
        return this.sessionToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accessKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.expiration());
        hashCode = 31 * hashCode + Objects.hashCode(this.secretAccessKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConnectionCredentials)) {
            return false;
        }
        ConnectionCredentials other = (ConnectionCredentials)obj;
        return Objects.equals(this.accessKeyId(), other.accessKeyId()) && Objects.equals(this.expiration(), other.expiration()) && Objects.equals(this.secretAccessKey(), other.secretAccessKey()) && Objects.equals(this.sessionToken(), other.sessionToken());
    }

    public final String toString() {
        return ToString.builder("ConnectionCredentials").add("AccessKeyId", this.accessKeyId()).add("Expiration", this.expiration()).add("SecretAccessKey", this.secretAccessKey()).add("SessionToken", this.sessionToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "accessKeyId": {
                return Optional.ofNullable(clazz.cast(this.accessKeyId()));
            }
            case "expiration": {
                return Optional.ofNullable(clazz.cast(this.expiration()));
            }
            case "secretAccessKey": {
                return Optional.ofNullable(clazz.cast(this.secretAccessKey()));
            }
            case "sessionToken": {
                return Optional.ofNullable(clazz.cast(this.sessionToken()));
            }
        }
        return Optional.empty();
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<Object>> map = new HashMap<String, SdkField<Object>>();
        map.put("accessKeyId", ACCESS_KEY_ID_FIELD);
        map.put("expiration", EXPIRATION_FIELD);
        map.put("secretAccessKey", SECRET_ACCESS_KEY_FIELD);
        map.put("sessionToken", SESSION_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ConnectionCredentials, T> g) {
        return obj -> g.apply((ConnectionCredentials)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String accessKeyId;
        private Instant expiration;
        private String secretAccessKey;
        private String sessionToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ConnectionCredentials model) {
            this.accessKeyId(model.accessKeyId);
            this.expiration(model.expiration);
            this.secretAccessKey(model.secretAccessKey);
            this.sessionToken(model.sessionToken);
        }

        public final String getAccessKeyId() {
            return this.accessKeyId;
        }

        public final void setAccessKeyId(String accessKeyId) {
            this.accessKeyId = accessKeyId;
        }

        @Override
        public final Builder accessKeyId(String accessKeyId) {
            this.accessKeyId = accessKeyId;
            return this;
        }

        public final Instant getExpiration() {
            return this.expiration;
        }

        public final void setExpiration(Instant expiration) {
            this.expiration = expiration;
        }

        @Override
        public final Builder expiration(Instant expiration) {
            this.expiration = expiration;
            return this;
        }

        public final String getSecretAccessKey() {
            return this.secretAccessKey;
        }

        public final void setSecretAccessKey(String secretAccessKey) {
            this.secretAccessKey = secretAccessKey;
        }

        @Override
        public final Builder secretAccessKey(String secretAccessKey) {
            this.secretAccessKey = secretAccessKey;
            return this;
        }

        public final String getSessionToken() {
            return this.sessionToken;
        }

        public final void setSessionToken(String sessionToken) {
            this.sessionToken = sessionToken;
        }

        @Override
        public final Builder sessionToken(String sessionToken) {
            this.sessionToken = sessionToken;
            return this;
        }

        @Override
        public ConnectionCredentials build() {
            return new ConnectionCredentials(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ConnectionCredentials> {
        public Builder accessKeyId(String var1);

        public Builder expiration(Instant var1);

        public Builder secretAccessKey(String var1);

        public Builder sessionToken(String var1);
    }
}

