/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.services.datazone.model.AccountSource;
import software.amazon.awssdk.services.datazone.model.DataZoneRequest;
import software.amazon.awssdk.services.datazone.model.ResolutionStrategy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateAccountPoolRequest
extends DataZoneRequest
implements ToCopyableBuilder<Builder, CreateAccountPoolRequest> {
    private static final SdkField<AccountSource> ACCOUNT_SOURCE_FIELD = SdkField.builder(MarshallingType.SDK_POJO).memberName("accountSource").getter(CreateAccountPoolRequest.getter(CreateAccountPoolRequest::accountSource)).setter(CreateAccountPoolRequest.setter(Builder::accountSource)).constructor(AccountSource::builder).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountSource").build()).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder(MarshallingType.STRING).memberName("description").getter(CreateAccountPoolRequest.getter(CreateAccountPoolRequest::description)).setter(CreateAccountPoolRequest.setter(Builder::description)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();
    private static final SdkField<String> DOMAIN_IDENTIFIER_FIELD = SdkField.builder(MarshallingType.STRING).memberName("domainIdentifier").getter(CreateAccountPoolRequest.getter(CreateAccountPoolRequest::domainIdentifier)).setter(CreateAccountPoolRequest.setter(Builder::domainIdentifier)).traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("domainIdentifier").build()).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder(MarshallingType.STRING).memberName("name").getter(CreateAccountPoolRequest.getter(CreateAccountPoolRequest::name)).setter(CreateAccountPoolRequest.setter(Builder::name)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();
    private static final SdkField<String> RESOLUTION_STRATEGY_FIELD = SdkField.builder(MarshallingType.STRING).memberName("resolutionStrategy").getter(CreateAccountPoolRequest.getter(CreateAccountPoolRequest::resolutionStrategyAsString)).setter(CreateAccountPoolRequest.setter(Builder::resolutionStrategy)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resolutionStrategy").build()).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_SOURCE_FIELD, DESCRIPTION_FIELD, DOMAIN_IDENTIFIER_FIELD, NAME_FIELD, RESOLUTION_STRATEGY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateAccountPoolRequest.memberNameToFieldInitializer();
    private final AccountSource accountSource;
    private final String description;
    private final String domainIdentifier;
    private final String name;
    private final String resolutionStrategy;

    private CreateAccountPoolRequest(BuilderImpl builder) {
        super(builder);
        this.accountSource = builder.accountSource;
        this.description = builder.description;
        this.domainIdentifier = builder.domainIdentifier;
        this.name = builder.name;
        this.resolutionStrategy = builder.resolutionStrategy;
    }

    public final AccountSource accountSource() {
        return this.accountSource;
    }

    public final String description() {
        return this.description;
    }

    public final String domainIdentifier() {
        return this.domainIdentifier;
    }

    public final String name() {
        return this.name;
    }

    public final ResolutionStrategy resolutionStrategy() {
        return ResolutionStrategy.fromValue(this.resolutionStrategy);
    }

    public final String resolutionStrategyAsString() {
        return this.resolutionStrategy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.accountSource());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.resolutionStrategyAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAccountPoolRequest)) {
            return false;
        }
        CreateAccountPoolRequest other = (CreateAccountPoolRequest)obj;
        return Objects.equals(this.accountSource(), other.accountSource()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.domainIdentifier(), other.domainIdentifier()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.resolutionStrategyAsString(), other.resolutionStrategyAsString());
    }

    public final String toString() {
        return ToString.builder("CreateAccountPoolRequest").add("AccountSource", this.accountSource()).add("Description", this.description() == null ? null : "*** Sensitive Data Redacted ***").add("DomainIdentifier", this.domainIdentifier()).add("Name", this.name() == null ? null : "*** Sensitive Data Redacted ***").add("ResolutionStrategy", this.resolutionStrategyAsString()).build();
    }

    @Override
    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "accountSource": {
                return Optional.ofNullable(clazz.cast(this.accountSource()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "domainIdentifier": {
                return Optional.ofNullable(clazz.cast(this.domainIdentifier()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "resolutionStrategy": {
                return Optional.ofNullable(clazz.cast(this.resolutionStrategyAsString()));
            }
        }
        return Optional.empty();
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<Object>> map = new HashMap<String, SdkField<Object>>();
        map.put("accountSource", ACCOUNT_SOURCE_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("domainIdentifier", DOMAIN_IDENTIFIER_FIELD);
        map.put("name", NAME_FIELD);
        map.put("resolutionStrategy", RESOLUTION_STRATEGY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateAccountPoolRequest, T> g) {
        return obj -> g.apply((CreateAccountPoolRequest)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DataZoneRequest.BuilderImpl
    implements Builder {
        private AccountSource accountSource;
        private String description;
        private String domainIdentifier;
        private String name;
        private String resolutionStrategy;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAccountPoolRequest model) {
            super(model);
            this.accountSource(model.accountSource);
            this.description(model.description);
            this.domainIdentifier(model.domainIdentifier);
            this.name(model.name);
            this.resolutionStrategy(model.resolutionStrategy);
        }

        public final AccountSource.Builder getAccountSource() {
            return this.accountSource != null ? this.accountSource.toBuilder() : null;
        }

        public final void setAccountSource(AccountSource.BuilderImpl accountSource) {
            this.accountSource = accountSource != null ? accountSource.build() : null;
        }

        @Override
        public final Builder accountSource(AccountSource accountSource) {
            this.accountSource = accountSource;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDomainIdentifier() {
            return this.domainIdentifier;
        }

        public final void setDomainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
        }

        @Override
        public final Builder domainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getResolutionStrategy() {
            return this.resolutionStrategy;
        }

        public final void setResolutionStrategy(String resolutionStrategy) {
            this.resolutionStrategy = resolutionStrategy;
        }

        @Override
        public final Builder resolutionStrategy(String resolutionStrategy) {
            this.resolutionStrategy = resolutionStrategy;
            return this;
        }

        @Override
        public final Builder resolutionStrategy(ResolutionStrategy resolutionStrategy) {
            this.resolutionStrategy(resolutionStrategy == null ? null : resolutionStrategy.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateAccountPoolRequest build() {
            return new CreateAccountPoolRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends DataZoneRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateAccountPoolRequest> {
        public Builder accountSource(AccountSource var1);

        default public Builder accountSource(Consumer<AccountSource.Builder> accountSource) {
            return this.accountSource((AccountSource)AccountSource.builder().applyMutation(accountSource).build());
        }

        public Builder description(String var1);

        public Builder domainIdentifier(String var1);

        public Builder name(String var1);

        public Builder resolutionStrategy(String var1);

        public Builder resolutionStrategy(ResolutionStrategy var1);

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

