/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.datazone.model.DataZoneResponse;
import software.amazon.awssdk.services.datazone.model.DomainUnitIdsCopier;
import software.amazon.awssdk.services.datazone.model.DomainUnitOwnerProperties;
import software.amazon.awssdk.services.datazone.model.DomainUnitOwnersCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateDomainUnitResponse
extends DataZoneResponse
implements ToCopyableBuilder<Builder, CreateDomainUnitResponse> {
    private static final SdkField<List<String>> ANCESTOR_DOMAIN_UNIT_IDS_FIELD = SdkField.builder(MarshallingType.LIST).memberName("ancestorDomainUnitIds").getter(CreateDomainUnitResponse.getter(CreateDomainUnitResponse::ancestorDomainUnitIds)).setter(CreateDomainUnitResponse.setter(Builder::ancestorDomainUnitIds)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ancestorDomainUnitIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder(MarshallingType.STRING).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()).build()).build()).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder(MarshallingType.INSTANT).memberName("createdAt").getter(CreateDomainUnitResponse.getter(CreateDomainUnitResponse::createdAt)).setter(CreateDomainUnitResponse.setter(Builder::createdAt)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();
    private static final SdkField<String> CREATED_BY_FIELD = SdkField.builder(MarshallingType.STRING).memberName("createdBy").getter(CreateDomainUnitResponse.getter(CreateDomainUnitResponse::createdBy)).setter(CreateDomainUnitResponse.setter(Builder::createdBy)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdBy").build()).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder(MarshallingType.STRING).memberName("description").getter(CreateDomainUnitResponse.getter(CreateDomainUnitResponse::description)).setter(CreateDomainUnitResponse.setter(Builder::description)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();
    private static final SdkField<String> DOMAIN_ID_FIELD = SdkField.builder(MarshallingType.STRING).memberName("domainId").getter(CreateDomainUnitResponse.getter(CreateDomainUnitResponse::domainId)).setter(CreateDomainUnitResponse.setter(Builder::domainId)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainId").build()).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder(MarshallingType.STRING).memberName("id").getter(CreateDomainUnitResponse.getter(CreateDomainUnitResponse::id)).setter(CreateDomainUnitResponse.setter(Builder::id)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder(MarshallingType.STRING).memberName("name").getter(CreateDomainUnitResponse.getter(CreateDomainUnitResponse::name)).setter(CreateDomainUnitResponse.setter(Builder::name)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();
    private static final SdkField<List<DomainUnitOwnerProperties>> OWNERS_FIELD = SdkField.builder(MarshallingType.LIST).memberName("owners").getter(CreateDomainUnitResponse.getter(CreateDomainUnitResponse::owners)).setter(CreateDomainUnitResponse.setter(Builder::owners)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("owners").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder(MarshallingType.SDK_POJO).constructor(DomainUnitOwnerProperties::builder).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()).build()).build()).build();
    private static final SdkField<String> PARENT_DOMAIN_UNIT_ID_FIELD = SdkField.builder(MarshallingType.STRING).memberName("parentDomainUnitId").getter(CreateDomainUnitResponse.getter(CreateDomainUnitResponse::parentDomainUnitId)).setter(CreateDomainUnitResponse.setter(Builder::parentDomainUnitId)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parentDomainUnitId").build()).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ANCESTOR_DOMAIN_UNIT_IDS_FIELD, CREATED_AT_FIELD, CREATED_BY_FIELD, DESCRIPTION_FIELD, DOMAIN_ID_FIELD, ID_FIELD, NAME_FIELD, OWNERS_FIELD, PARENT_DOMAIN_UNIT_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateDomainUnitResponse.memberNameToFieldInitializer();
    private final List<String> ancestorDomainUnitIds;
    private final Instant createdAt;
    private final String createdBy;
    private final String description;
    private final String domainId;
    private final String id;
    private final String name;
    private final List<DomainUnitOwnerProperties> owners;
    private final String parentDomainUnitId;

    private CreateDomainUnitResponse(BuilderImpl builder) {
        super(builder);
        this.ancestorDomainUnitIds = builder.ancestorDomainUnitIds;
        this.createdAt = builder.createdAt;
        this.createdBy = builder.createdBy;
        this.description = builder.description;
        this.domainId = builder.domainId;
        this.id = builder.id;
        this.name = builder.name;
        this.owners = builder.owners;
        this.parentDomainUnitId = builder.parentDomainUnitId;
    }

    public final boolean hasAncestorDomainUnitIds() {
        return this.ancestorDomainUnitIds != null && !(this.ancestorDomainUnitIds instanceof SdkAutoConstructList);
    }

    public final List<String> ancestorDomainUnitIds() {
        return this.ancestorDomainUnitIds;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final String createdBy() {
        return this.createdBy;
    }

    public final String description() {
        return this.description;
    }

    public final String domainId() {
        return this.domainId;
    }

    public final String id() {
        return this.id;
    }

    public final String name() {
        return this.name;
    }

    public final boolean hasOwners() {
        return this.owners != null && !(this.owners instanceof SdkAutoConstructList);
    }

    public final List<DomainUnitOwnerProperties> owners() {
        return this.owners;
    }

    public final String parentDomainUnitId() {
        return this.parentDomainUnitId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAncestorDomainUnitIds() ? this.ancestorDomainUnitIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainId());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOwners() ? this.owners() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.parentDomainUnitId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDomainUnitResponse)) {
            return false;
        }
        CreateDomainUnitResponse other = (CreateDomainUnitResponse)obj;
        return this.hasAncestorDomainUnitIds() == other.hasAncestorDomainUnitIds() && Objects.equals(this.ancestorDomainUnitIds(), other.ancestorDomainUnitIds()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.createdBy(), other.createdBy()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.domainId(), other.domainId()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.name(), other.name()) && this.hasOwners() == other.hasOwners() && Objects.equals(this.owners(), other.owners()) && Objects.equals(this.parentDomainUnitId(), other.parentDomainUnitId());
    }

    public final String toString() {
        return ToString.builder("CreateDomainUnitResponse").add("AncestorDomainUnitIds", this.hasAncestorDomainUnitIds() ? this.ancestorDomainUnitIds() : null).add("CreatedAt", this.createdAt()).add("CreatedBy", this.createdBy()).add("Description", this.description() == null ? null : "*** Sensitive Data Redacted ***").add("DomainId", this.domainId()).add("Id", this.id()).add("Name", this.name() == null ? null : "*** Sensitive Data Redacted ***").add("Owners", this.hasOwners() ? this.owners() : null).add("ParentDomainUnitId", this.parentDomainUnitId()).build();
    }

    @Override
    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ancestorDomainUnitIds": {
                return Optional.ofNullable(clazz.cast(this.ancestorDomainUnitIds()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "createdBy": {
                return Optional.ofNullable(clazz.cast(this.createdBy()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "domainId": {
                return Optional.ofNullable(clazz.cast(this.domainId()));
            }
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "owners": {
                return Optional.ofNullable(clazz.cast(this.owners()));
            }
            case "parentDomainUnitId": {
                return Optional.ofNullable(clazz.cast(this.parentDomainUnitId()));
            }
        }
        return Optional.empty();
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<Object>> map = new HashMap<String, SdkField<Object>>();
        map.put("ancestorDomainUnitIds", ANCESTOR_DOMAIN_UNIT_IDS_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("createdBy", CREATED_BY_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("domainId", DOMAIN_ID_FIELD);
        map.put("id", ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("owners", OWNERS_FIELD);
        map.put("parentDomainUnitId", PARENT_DOMAIN_UNIT_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateDomainUnitResponse, T> g) {
        return obj -> g.apply((CreateDomainUnitResponse)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DataZoneResponse.BuilderImpl
    implements Builder {
        private List<String> ancestorDomainUnitIds = DefaultSdkAutoConstructList.getInstance();
        private Instant createdAt;
        private String createdBy;
        private String description;
        private String domainId;
        private String id;
        private String name;
        private List<DomainUnitOwnerProperties> owners = DefaultSdkAutoConstructList.getInstance();
        private String parentDomainUnitId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDomainUnitResponse model) {
            super(model);
            this.ancestorDomainUnitIds(model.ancestorDomainUnitIds);
            this.createdAt(model.createdAt);
            this.createdBy(model.createdBy);
            this.description(model.description);
            this.domainId(model.domainId);
            this.id(model.id);
            this.name(model.name);
            this.owners(model.owners);
            this.parentDomainUnitId(model.parentDomainUnitId);
        }

        public final Collection<String> getAncestorDomainUnitIds() {
            if (this.ancestorDomainUnitIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.ancestorDomainUnitIds;
        }

        public final void setAncestorDomainUnitIds(Collection<String> ancestorDomainUnitIds) {
            this.ancestorDomainUnitIds = DomainUnitIdsCopier.copy(ancestorDomainUnitIds);
        }

        @Override
        public final Builder ancestorDomainUnitIds(Collection<String> ancestorDomainUnitIds) {
            this.ancestorDomainUnitIds = DomainUnitIdsCopier.copy(ancestorDomainUnitIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ancestorDomainUnitIds(String ... ancestorDomainUnitIds) {
            this.ancestorDomainUnitIds(Arrays.asList(ancestorDomainUnitIds));
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getCreatedBy() {
            return this.createdBy;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDomainId() {
            return this.domainId;
        }

        public final void setDomainId(String domainId) {
            this.domainId = domainId;
        }

        @Override
        public final Builder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final List<DomainUnitOwnerProperties.Builder> getOwners() {
            List<DomainUnitOwnerProperties.Builder> result = DomainUnitOwnersCopier.copyToBuilder(this.owners);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOwners(Collection<DomainUnitOwnerProperties.BuilderImpl> owners) {
            this.owners = DomainUnitOwnersCopier.copyFromBuilder(owners);
        }

        @Override
        public final Builder owners(Collection<DomainUnitOwnerProperties> owners) {
            this.owners = DomainUnitOwnersCopier.copy(owners);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder owners(DomainUnitOwnerProperties ... owners) {
            this.owners(Arrays.asList(owners));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder owners(Consumer<DomainUnitOwnerProperties.Builder> ... owners) {
            this.owners(Stream.of(owners).map(c -> (DomainUnitOwnerProperties)((DomainUnitOwnerProperties.Builder)DomainUnitOwnerProperties.builder().applyMutation(c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getParentDomainUnitId() {
            return this.parentDomainUnitId;
        }

        public final void setParentDomainUnitId(String parentDomainUnitId) {
            this.parentDomainUnitId = parentDomainUnitId;
        }

        @Override
        public final Builder parentDomainUnitId(String parentDomainUnitId) {
            this.parentDomainUnitId = parentDomainUnitId;
            return this;
        }

        @Override
        public CreateDomainUnitResponse build() {
            return new CreateDomainUnitResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends DataZoneResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateDomainUnitResponse> {
        public Builder ancestorDomainUnitIds(Collection<String> var1);

        public Builder ancestorDomainUnitIds(String ... var1);

        public Builder createdAt(Instant var1);

        public Builder createdBy(String var1);

        public Builder description(String var1);

        public Builder domainId(String var1);

        public Builder id(String var1);

        public Builder name(String var1);

        public Builder owners(Collection<DomainUnitOwnerProperties> var1);

        public Builder owners(DomainUnitOwnerProperties ... var1);

        public Builder owners(Consumer<DomainUnitOwnerProperties.Builder> ... var1);

        public Builder parentDomainUnitId(String var1);
    }
}

