/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.services.datazone.model.DataSourceErrorType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DataSourceErrorMessage
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DataSourceErrorMessage> {
    private static final SdkField<String> ERROR_DETAIL_FIELD = SdkField.builder(MarshallingType.STRING).memberName("errorDetail").getter(DataSourceErrorMessage.getter(DataSourceErrorMessage::errorDetail)).setter(DataSourceErrorMessage.setter(Builder::errorDetail)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorDetail").build()).build();
    private static final SdkField<String> ERROR_TYPE_FIELD = SdkField.builder(MarshallingType.STRING).memberName("errorType").getter(DataSourceErrorMessage.getter(DataSourceErrorMessage::errorTypeAsString)).setter(DataSourceErrorMessage.setter(Builder::errorType)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorType").build()).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ERROR_DETAIL_FIELD, ERROR_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DataSourceErrorMessage.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String errorDetail;
    private final String errorType;

    private DataSourceErrorMessage(BuilderImpl builder) {
        this.errorDetail = builder.errorDetail;
        this.errorType = builder.errorType;
    }

    public final String errorDetail() {
        return this.errorDetail;
    }

    public final DataSourceErrorType errorType() {
        return DataSourceErrorType.fromValue(this.errorType);
    }

    public final String errorTypeAsString() {
        return this.errorType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.errorDetail());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataSourceErrorMessage)) {
            return false;
        }
        DataSourceErrorMessage other = (DataSourceErrorMessage)obj;
        return Objects.equals(this.errorDetail(), other.errorDetail()) && Objects.equals(this.errorTypeAsString(), other.errorTypeAsString());
    }

    public final String toString() {
        return ToString.builder("DataSourceErrorMessage").add("ErrorDetail", this.errorDetail()).add("ErrorType", this.errorTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "errorDetail": {
                return Optional.ofNullable(clazz.cast(this.errorDetail()));
            }
            case "errorType": {
                return Optional.ofNullable(clazz.cast(this.errorTypeAsString()));
            }
        }
        return Optional.empty();
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("errorDetail", ERROR_DETAIL_FIELD);
        map.put("errorType", ERROR_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataSourceErrorMessage, T> g) {
        return obj -> g.apply((DataSourceErrorMessage)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String errorDetail;
        private String errorType;

        private BuilderImpl() {
        }

        private BuilderImpl(DataSourceErrorMessage model) {
            this.errorDetail(model.errorDetail);
            this.errorType(model.errorType);
        }

        public final String getErrorDetail() {
            return this.errorDetail;
        }

        public final void setErrorDetail(String errorDetail) {
            this.errorDetail = errorDetail;
        }

        @Override
        public final Builder errorDetail(String errorDetail) {
            this.errorDetail = errorDetail;
            return this;
        }

        public final String getErrorType() {
            return this.errorType;
        }

        public final void setErrorType(String errorType) {
            this.errorType = errorType;
        }

        @Override
        public final Builder errorType(String errorType) {
            this.errorType = errorType;
            return this;
        }

        @Override
        public final Builder errorType(DataSourceErrorType errorType) {
            this.errorType(errorType == null ? null : errorType.toString());
            return this;
        }

        @Override
        public DataSourceErrorMessage build() {
            return new DataSourceErrorMessage(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DataSourceErrorMessage> {
        public Builder errorDetail(String var1);

        public Builder errorType(String var1);

        public Builder errorType(DataSourceErrorType var1);
    }
}

