/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.services.datazone.model.DataZoneRequest;
import software.amazon.awssdk.services.datazone.model.TimeSeriesEntityType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteTimeSeriesDataPointsRequest
extends DataZoneRequest
implements ToCopyableBuilder<Builder, DeleteTimeSeriesDataPointsRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder(MarshallingType.STRING).memberName("clientToken").getter(DeleteTimeSeriesDataPointsRequest.getter(DeleteTimeSeriesDataPointsRequest::clientToken)).setter(DeleteTimeSeriesDataPointsRequest.setter(Builder::clientToken)).traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()).build();
    private static final SdkField<String> DOMAIN_IDENTIFIER_FIELD = SdkField.builder(MarshallingType.STRING).memberName("domainIdentifier").getter(DeleteTimeSeriesDataPointsRequest.getter(DeleteTimeSeriesDataPointsRequest::domainIdentifier)).setter(DeleteTimeSeriesDataPointsRequest.setter(Builder::domainIdentifier)).traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("domainIdentifier").build()).build();
    private static final SdkField<String> ENTITY_IDENTIFIER_FIELD = SdkField.builder(MarshallingType.STRING).memberName("entityIdentifier").getter(DeleteTimeSeriesDataPointsRequest.getter(DeleteTimeSeriesDataPointsRequest::entityIdentifier)).setter(DeleteTimeSeriesDataPointsRequest.setter(Builder::entityIdentifier)).traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("entityIdentifier").build()).build();
    private static final SdkField<String> ENTITY_TYPE_FIELD = SdkField.builder(MarshallingType.STRING).memberName("entityType").getter(DeleteTimeSeriesDataPointsRequest.getter(DeleteTimeSeriesDataPointsRequest::entityTypeAsString)).setter(DeleteTimeSeriesDataPointsRequest.setter(Builder::entityType)).traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("entityType").build()).build();
    private static final SdkField<String> FORM_NAME_FIELD = SdkField.builder(MarshallingType.STRING).memberName("formName").getter(DeleteTimeSeriesDataPointsRequest.getter(DeleteTimeSeriesDataPointsRequest::formName)).setter(DeleteTimeSeriesDataPointsRequest.setter(Builder::formName)).traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("formName").build()).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD, DOMAIN_IDENTIFIER_FIELD, ENTITY_IDENTIFIER_FIELD, ENTITY_TYPE_FIELD, FORM_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DeleteTimeSeriesDataPointsRequest.memberNameToFieldInitializer();
    private final String clientToken;
    private final String domainIdentifier;
    private final String entityIdentifier;
    private final String entityType;
    private final String formName;

    private DeleteTimeSeriesDataPointsRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.domainIdentifier = builder.domainIdentifier;
        this.entityIdentifier = builder.entityIdentifier;
        this.entityType = builder.entityType;
        this.formName = builder.formName;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String domainIdentifier() {
        return this.domainIdentifier;
    }

    public final String entityIdentifier() {
        return this.entityIdentifier;
    }

    public final TimeSeriesEntityType entityType() {
        return TimeSeriesEntityType.fromValue(this.entityType);
    }

    public final String entityTypeAsString() {
        return this.entityType;
    }

    public final String formName() {
        return this.formName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.entityIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.entityTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.formName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteTimeSeriesDataPointsRequest)) {
            return false;
        }
        DeleteTimeSeriesDataPointsRequest other = (DeleteTimeSeriesDataPointsRequest)obj;
        return Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.domainIdentifier(), other.domainIdentifier()) && Objects.equals(this.entityIdentifier(), other.entityIdentifier()) && Objects.equals(this.entityTypeAsString(), other.entityTypeAsString()) && Objects.equals(this.formName(), other.formName());
    }

    public final String toString() {
        return ToString.builder("DeleteTimeSeriesDataPointsRequest").add("ClientToken", this.clientToken()).add("DomainIdentifier", this.domainIdentifier()).add("EntityIdentifier", this.entityIdentifier()).add("EntityType", this.entityTypeAsString()).add("FormName", this.formName()).build();
    }

    @Override
    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "domainIdentifier": {
                return Optional.ofNullable(clazz.cast(this.domainIdentifier()));
            }
            case "entityIdentifier": {
                return Optional.ofNullable(clazz.cast(this.entityIdentifier()));
            }
            case "entityType": {
                return Optional.ofNullable(clazz.cast(this.entityTypeAsString()));
            }
            case "formName": {
                return Optional.ofNullable(clazz.cast(this.formName()));
            }
        }
        return Optional.empty();
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("domainIdentifier", DOMAIN_IDENTIFIER_FIELD);
        map.put("entityIdentifier", ENTITY_IDENTIFIER_FIELD);
        map.put("entityType", ENTITY_TYPE_FIELD);
        map.put("formName", FORM_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteTimeSeriesDataPointsRequest, T> g) {
        return obj -> g.apply((DeleteTimeSeriesDataPointsRequest)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DataZoneRequest.BuilderImpl
    implements Builder {
        private String clientToken;
        private String domainIdentifier;
        private String entityIdentifier;
        private String entityType;
        private String formName;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteTimeSeriesDataPointsRequest model) {
            super(model);
            this.clientToken(model.clientToken);
            this.domainIdentifier(model.domainIdentifier);
            this.entityIdentifier(model.entityIdentifier);
            this.entityType(model.entityType);
            this.formName(model.formName);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getDomainIdentifier() {
            return this.domainIdentifier;
        }

        public final void setDomainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
        }

        @Override
        public final Builder domainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
            return this;
        }

        public final String getEntityIdentifier() {
            return this.entityIdentifier;
        }

        public final void setEntityIdentifier(String entityIdentifier) {
            this.entityIdentifier = entityIdentifier;
        }

        @Override
        public final Builder entityIdentifier(String entityIdentifier) {
            this.entityIdentifier = entityIdentifier;
            return this;
        }

        public final String getEntityType() {
            return this.entityType;
        }

        public final void setEntityType(String entityType) {
            this.entityType = entityType;
        }

        @Override
        public final Builder entityType(String entityType) {
            this.entityType = entityType;
            return this;
        }

        @Override
        public final Builder entityType(TimeSeriesEntityType entityType) {
            this.entityType(entityType == null ? null : entityType.toString());
            return this;
        }

        public final String getFormName() {
            return this.formName;
        }

        public final void setFormName(String formName) {
            this.formName = formName;
        }

        @Override
        public final Builder formName(String formName) {
            this.formName = formName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteTimeSeriesDataPointsRequest build() {
            return new DeleteTimeSeriesDataPointsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends DataZoneRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteTimeSeriesDataPointsRequest> {
        public Builder clientToken(String var1);

        public Builder domainIdentifier(String var1);

        public Builder entityIdentifier(String var1);

        public Builder entityType(String var1);

        public Builder entityType(TimeSeriesEntityType var1);

        public Builder formName(String var1);

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

