/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.datazone.model.DataSourceConfigurationOutput;
import software.amazon.awssdk.services.datazone.model.DataSourceErrorMessage;
import software.amazon.awssdk.services.datazone.model.DataSourceRunStatus;
import software.amazon.awssdk.services.datazone.model.DataSourceStatus;
import software.amazon.awssdk.services.datazone.model.DataZoneResponse;
import software.amazon.awssdk.services.datazone.model.EnableSetting;
import software.amazon.awssdk.services.datazone.model.FormOutput;
import software.amazon.awssdk.services.datazone.model.FormOutputListCopier;
import software.amazon.awssdk.services.datazone.model.RecommendationConfiguration;
import software.amazon.awssdk.services.datazone.model.ScheduleConfiguration;
import software.amazon.awssdk.services.datazone.model.SelfGrantStatusOutput;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetDataSourceResponse
extends DataZoneResponse
implements ToCopyableBuilder<Builder, GetDataSourceResponse> {
    private static final SdkField<List<FormOutput>> ASSET_FORMS_OUTPUT_FIELD = SdkField.builder(MarshallingType.LIST).memberName("assetFormsOutput").getter(GetDataSourceResponse.getter(GetDataSourceResponse::assetFormsOutput)).setter(GetDataSourceResponse.setter(Builder::assetFormsOutput)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetFormsOutput").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder(MarshallingType.SDK_POJO).constructor(FormOutput::builder).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()).build()).build()).build();
    private static final SdkField<DataSourceConfigurationOutput> CONFIGURATION_FIELD = SdkField.builder(MarshallingType.SDK_POJO).memberName("configuration").getter(GetDataSourceResponse.getter(GetDataSourceResponse::configuration)).setter(GetDataSourceResponse.setter(Builder::configuration)).constructor(DataSourceConfigurationOutput::builder).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuration").build()).build();
    private static final SdkField<String> CONNECTION_ID_FIELD = SdkField.builder(MarshallingType.STRING).memberName("connectionId").getter(GetDataSourceResponse.getter(GetDataSourceResponse::connectionId)).setter(GetDataSourceResponse.setter(Builder::connectionId)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectionId").build()).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder(MarshallingType.INSTANT).memberName("createdAt").getter(GetDataSourceResponse.getter(GetDataSourceResponse::createdAt)).setter(GetDataSourceResponse.setter(Builder::createdAt)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(), TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder(MarshallingType.STRING).memberName("description").getter(GetDataSourceResponse.getter(GetDataSourceResponse::description)).setter(GetDataSourceResponse.setter(Builder::description)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();
    private static final SdkField<String> DOMAIN_ID_FIELD = SdkField.builder(MarshallingType.STRING).memberName("domainId").getter(GetDataSourceResponse.getter(GetDataSourceResponse::domainId)).setter(GetDataSourceResponse.setter(Builder::domainId)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainId").build()).build();
    private static final SdkField<String> ENABLE_SETTING_FIELD = SdkField.builder(MarshallingType.STRING).memberName("enableSetting").getter(GetDataSourceResponse.getter(GetDataSourceResponse::enableSettingAsString)).setter(GetDataSourceResponse.setter(Builder::enableSetting)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enableSetting").build()).build();
    private static final SdkField<String> ENVIRONMENT_ID_FIELD = SdkField.builder(MarshallingType.STRING).memberName("environmentId").getter(GetDataSourceResponse.getter(GetDataSourceResponse::environmentId)).setter(GetDataSourceResponse.setter(Builder::environmentId)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentId").build()).build();
    private static final SdkField<DataSourceErrorMessage> ERROR_MESSAGE_FIELD = SdkField.builder(MarshallingType.SDK_POJO).memberName("errorMessage").getter(GetDataSourceResponse.getter(GetDataSourceResponse::errorMessage)).setter(GetDataSourceResponse.setter(Builder::errorMessage)).constructor(DataSourceErrorMessage::builder).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorMessage").build()).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder(MarshallingType.STRING).memberName("id").getter(GetDataSourceResponse.getter(GetDataSourceResponse::id)).setter(GetDataSourceResponse.setter(Builder::id)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();
    private static final SdkField<Integer> LAST_RUN_ASSET_COUNT_FIELD = SdkField.builder(MarshallingType.INTEGER).memberName("lastRunAssetCount").getter(GetDataSourceResponse.getter(GetDataSourceResponse::lastRunAssetCount)).setter(GetDataSourceResponse.setter(Builder::lastRunAssetCount)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastRunAssetCount").build()).build();
    private static final SdkField<Instant> LAST_RUN_AT_FIELD = SdkField.builder(MarshallingType.INSTANT).memberName("lastRunAt").getter(GetDataSourceResponse.getter(GetDataSourceResponse::lastRunAt)).setter(GetDataSourceResponse.setter(Builder::lastRunAt)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastRunAt").build(), TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();
    private static final SdkField<DataSourceErrorMessage> LAST_RUN_ERROR_MESSAGE_FIELD = SdkField.builder(MarshallingType.SDK_POJO).memberName("lastRunErrorMessage").getter(GetDataSourceResponse.getter(GetDataSourceResponse::lastRunErrorMessage)).setter(GetDataSourceResponse.setter(Builder::lastRunErrorMessage)).constructor(DataSourceErrorMessage::builder).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastRunErrorMessage").build()).build();
    private static final SdkField<String> LAST_RUN_STATUS_FIELD = SdkField.builder(MarshallingType.STRING).memberName("lastRunStatus").getter(GetDataSourceResponse.getter(GetDataSourceResponse::lastRunStatusAsString)).setter(GetDataSourceResponse.setter(Builder::lastRunStatus)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastRunStatus").build()).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder(MarshallingType.STRING).memberName("name").getter(GetDataSourceResponse.getter(GetDataSourceResponse::name)).setter(GetDataSourceResponse.setter(Builder::name)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();
    private static final SdkField<String> PROJECT_ID_FIELD = SdkField.builder(MarshallingType.STRING).memberName("projectId").getter(GetDataSourceResponse.getter(GetDataSourceResponse::projectId)).setter(GetDataSourceResponse.setter(Builder::projectId)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("projectId").build()).build();
    private static final SdkField<Boolean> PUBLISH_ON_IMPORT_FIELD = SdkField.builder(MarshallingType.BOOLEAN).memberName("publishOnImport").getter(GetDataSourceResponse.getter(GetDataSourceResponse::publishOnImport)).setter(GetDataSourceResponse.setter(Builder::publishOnImport)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("publishOnImport").build()).build();
    private static final SdkField<RecommendationConfiguration> RECOMMENDATION_FIELD = SdkField.builder(MarshallingType.SDK_POJO).memberName("recommendation").getter(GetDataSourceResponse.getter(GetDataSourceResponse::recommendation)).setter(GetDataSourceResponse.setter(Builder::recommendation)).constructor(RecommendationConfiguration::builder).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recommendation").build()).build();
    private static final SdkField<ScheduleConfiguration> SCHEDULE_FIELD = SdkField.builder(MarshallingType.SDK_POJO).memberName("schedule").getter(GetDataSourceResponse.getter(GetDataSourceResponse::schedule)).setter(GetDataSourceResponse.setter(Builder::schedule)).constructor(ScheduleConfiguration::builder).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("schedule").build()).build();
    private static final SdkField<SelfGrantStatusOutput> SELF_GRANT_STATUS_FIELD = SdkField.builder(MarshallingType.SDK_POJO).memberName("selfGrantStatus").getter(GetDataSourceResponse.getter(GetDataSourceResponse::selfGrantStatus)).setter(GetDataSourceResponse.setter(Builder::selfGrantStatus)).constructor(SelfGrantStatusOutput::builder).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("selfGrantStatus").build()).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder(MarshallingType.STRING).memberName("status").getter(GetDataSourceResponse.getter(GetDataSourceResponse::statusAsString)).setter(GetDataSourceResponse.setter(Builder::status)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder(MarshallingType.STRING).memberName("type").getter(GetDataSourceResponse.getter(GetDataSourceResponse::type)).setter(GetDataSourceResponse.setter(Builder::type)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder(MarshallingType.INSTANT).memberName("updatedAt").getter(GetDataSourceResponse.getter(GetDataSourceResponse::updatedAt)).setter(GetDataSourceResponse.setter(Builder::updatedAt)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build(), TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSET_FORMS_OUTPUT_FIELD, CONFIGURATION_FIELD, CONNECTION_ID_FIELD, CREATED_AT_FIELD, DESCRIPTION_FIELD, DOMAIN_ID_FIELD, ENABLE_SETTING_FIELD, ENVIRONMENT_ID_FIELD, ERROR_MESSAGE_FIELD, ID_FIELD, LAST_RUN_ASSET_COUNT_FIELD, LAST_RUN_AT_FIELD, LAST_RUN_ERROR_MESSAGE_FIELD, LAST_RUN_STATUS_FIELD, NAME_FIELD, PROJECT_ID_FIELD, PUBLISH_ON_IMPORT_FIELD, RECOMMENDATION_FIELD, SCHEDULE_FIELD, SELF_GRANT_STATUS_FIELD, STATUS_FIELD, TYPE_FIELD, UPDATED_AT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetDataSourceResponse.memberNameToFieldInitializer();
    private final List<FormOutput> assetFormsOutput;
    private final DataSourceConfigurationOutput configuration;
    private final String connectionId;
    private final Instant createdAt;
    private final String description;
    private final String domainId;
    private final String enableSetting;
    private final String environmentId;
    private final DataSourceErrorMessage errorMessage;
    private final String id;
    private final Integer lastRunAssetCount;
    private final Instant lastRunAt;
    private final DataSourceErrorMessage lastRunErrorMessage;
    private final String lastRunStatus;
    private final String name;
    private final String projectId;
    private final Boolean publishOnImport;
    private final RecommendationConfiguration recommendation;
    private final ScheduleConfiguration schedule;
    private final SelfGrantStatusOutput selfGrantStatus;
    private final String status;
    private final String type;
    private final Instant updatedAt;

    private GetDataSourceResponse(BuilderImpl builder) {
        super(builder);
        this.assetFormsOutput = builder.assetFormsOutput;
        this.configuration = builder.configuration;
        this.connectionId = builder.connectionId;
        this.createdAt = builder.createdAt;
        this.description = builder.description;
        this.domainId = builder.domainId;
        this.enableSetting = builder.enableSetting;
        this.environmentId = builder.environmentId;
        this.errorMessage = builder.errorMessage;
        this.id = builder.id;
        this.lastRunAssetCount = builder.lastRunAssetCount;
        this.lastRunAt = builder.lastRunAt;
        this.lastRunErrorMessage = builder.lastRunErrorMessage;
        this.lastRunStatus = builder.lastRunStatus;
        this.name = builder.name;
        this.projectId = builder.projectId;
        this.publishOnImport = builder.publishOnImport;
        this.recommendation = builder.recommendation;
        this.schedule = builder.schedule;
        this.selfGrantStatus = builder.selfGrantStatus;
        this.status = builder.status;
        this.type = builder.type;
        this.updatedAt = builder.updatedAt;
    }

    public final boolean hasAssetFormsOutput() {
        return this.assetFormsOutput != null && !(this.assetFormsOutput instanceof SdkAutoConstructList);
    }

    public final List<FormOutput> assetFormsOutput() {
        return this.assetFormsOutput;
    }

    public final DataSourceConfigurationOutput configuration() {
        return this.configuration;
    }

    public final String connectionId() {
        return this.connectionId;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final String description() {
        return this.description;
    }

    public final String domainId() {
        return this.domainId;
    }

    public final EnableSetting enableSetting() {
        return EnableSetting.fromValue(this.enableSetting);
    }

    public final String enableSettingAsString() {
        return this.enableSetting;
    }

    public final String environmentId() {
        return this.environmentId;
    }

    public final DataSourceErrorMessage errorMessage() {
        return this.errorMessage;
    }

    public final String id() {
        return this.id;
    }

    public final Integer lastRunAssetCount() {
        return this.lastRunAssetCount;
    }

    public final Instant lastRunAt() {
        return this.lastRunAt;
    }

    public final DataSourceErrorMessage lastRunErrorMessage() {
        return this.lastRunErrorMessage;
    }

    public final DataSourceRunStatus lastRunStatus() {
        return DataSourceRunStatus.fromValue(this.lastRunStatus);
    }

    public final String lastRunStatusAsString() {
        return this.lastRunStatus;
    }

    public final String name() {
        return this.name;
    }

    public final String projectId() {
        return this.projectId;
    }

    public final Boolean publishOnImport() {
        return this.publishOnImport;
    }

    public final RecommendationConfiguration recommendation() {
        return this.recommendation;
    }

    public final ScheduleConfiguration schedule() {
        return this.schedule;
    }

    public final SelfGrantStatusOutput selfGrantStatus() {
        return this.selfGrantStatus;
    }

    public final DataSourceStatus status() {
        return DataSourceStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String type() {
        return this.type;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAssetFormsOutput() ? this.assetFormsOutput() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.configuration());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainId());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableSettingAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastRunAssetCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastRunAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastRunErrorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastRunStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.projectId());
        hashCode = 31 * hashCode + Objects.hashCode(this.publishOnImport());
        hashCode = 31 * hashCode + Objects.hashCode(this.recommendation());
        hashCode = 31 * hashCode + Objects.hashCode(this.schedule());
        hashCode = 31 * hashCode + Objects.hashCode(this.selfGrantStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.type());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDataSourceResponse)) {
            return false;
        }
        GetDataSourceResponse other = (GetDataSourceResponse)obj;
        return this.hasAssetFormsOutput() == other.hasAssetFormsOutput() && Objects.equals(this.assetFormsOutput(), other.assetFormsOutput()) && Objects.equals(this.configuration(), other.configuration()) && Objects.equals(this.connectionId(), other.connectionId()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.domainId(), other.domainId()) && Objects.equals(this.enableSettingAsString(), other.enableSettingAsString()) && Objects.equals(this.environmentId(), other.environmentId()) && Objects.equals(this.errorMessage(), other.errorMessage()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.lastRunAssetCount(), other.lastRunAssetCount()) && Objects.equals(this.lastRunAt(), other.lastRunAt()) && Objects.equals(this.lastRunErrorMessage(), other.lastRunErrorMessage()) && Objects.equals(this.lastRunStatusAsString(), other.lastRunStatusAsString()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.projectId(), other.projectId()) && Objects.equals(this.publishOnImport(), other.publishOnImport()) && Objects.equals(this.recommendation(), other.recommendation()) && Objects.equals(this.schedule(), other.schedule()) && Objects.equals(this.selfGrantStatus(), other.selfGrantStatus()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.type(), other.type()) && Objects.equals(this.updatedAt(), other.updatedAt());
    }

    public final String toString() {
        return ToString.builder("GetDataSourceResponse").add("AssetFormsOutput", this.hasAssetFormsOutput() ? this.assetFormsOutput() : null).add("Configuration", this.configuration()).add("ConnectionId", this.connectionId()).add("CreatedAt", this.createdAt()).add("Description", this.description() == null ? null : "*** Sensitive Data Redacted ***").add("DomainId", this.domainId()).add("EnableSetting", this.enableSettingAsString()).add("EnvironmentId", this.environmentId()).add("ErrorMessage", this.errorMessage()).add("Id", this.id()).add("LastRunAssetCount", this.lastRunAssetCount()).add("LastRunAt", this.lastRunAt()).add("LastRunErrorMessage", this.lastRunErrorMessage()).add("LastRunStatus", this.lastRunStatusAsString()).add("Name", this.name() == null ? null : "*** Sensitive Data Redacted ***").add("ProjectId", this.projectId()).add("PublishOnImport", this.publishOnImport()).add("Recommendation", this.recommendation()).add("Schedule", this.schedule() == null ? null : "*** Sensitive Data Redacted ***").add("SelfGrantStatus", this.selfGrantStatus()).add("Status", this.statusAsString()).add("Type", this.type()).add("UpdatedAt", this.updatedAt()).build();
    }

    @Override
    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "assetFormsOutput": {
                return Optional.ofNullable(clazz.cast(this.assetFormsOutput()));
            }
            case "configuration": {
                return Optional.ofNullable(clazz.cast(this.configuration()));
            }
            case "connectionId": {
                return Optional.ofNullable(clazz.cast(this.connectionId()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "domainId": {
                return Optional.ofNullable(clazz.cast(this.domainId()));
            }
            case "enableSetting": {
                return Optional.ofNullable(clazz.cast(this.enableSettingAsString()));
            }
            case "environmentId": {
                return Optional.ofNullable(clazz.cast(this.environmentId()));
            }
            case "errorMessage": {
                return Optional.ofNullable(clazz.cast(this.errorMessage()));
            }
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "lastRunAssetCount": {
                return Optional.ofNullable(clazz.cast(this.lastRunAssetCount()));
            }
            case "lastRunAt": {
                return Optional.ofNullable(clazz.cast(this.lastRunAt()));
            }
            case "lastRunErrorMessage": {
                return Optional.ofNullable(clazz.cast(this.lastRunErrorMessage()));
            }
            case "lastRunStatus": {
                return Optional.ofNullable(clazz.cast(this.lastRunStatusAsString()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "projectId": {
                return Optional.ofNullable(clazz.cast(this.projectId()));
            }
            case "publishOnImport": {
                return Optional.ofNullable(clazz.cast(this.publishOnImport()));
            }
            case "recommendation": {
                return Optional.ofNullable(clazz.cast(this.recommendation()));
            }
            case "schedule": {
                return Optional.ofNullable(clazz.cast(this.schedule()));
            }
            case "selfGrantStatus": {
                return Optional.ofNullable(clazz.cast(this.selfGrantStatus()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.type()));
            }
            case "updatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
        }
        return Optional.empty();
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<Object>> map = new HashMap<String, SdkField<Object>>();
        map.put("assetFormsOutput", ASSET_FORMS_OUTPUT_FIELD);
        map.put("configuration", CONFIGURATION_FIELD);
        map.put("connectionId", CONNECTION_ID_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("domainId", DOMAIN_ID_FIELD);
        map.put("enableSetting", ENABLE_SETTING_FIELD);
        map.put("environmentId", ENVIRONMENT_ID_FIELD);
        map.put("errorMessage", ERROR_MESSAGE_FIELD);
        map.put("id", ID_FIELD);
        map.put("lastRunAssetCount", LAST_RUN_ASSET_COUNT_FIELD);
        map.put("lastRunAt", LAST_RUN_AT_FIELD);
        map.put("lastRunErrorMessage", LAST_RUN_ERROR_MESSAGE_FIELD);
        map.put("lastRunStatus", LAST_RUN_STATUS_FIELD);
        map.put("name", NAME_FIELD);
        map.put("projectId", PROJECT_ID_FIELD);
        map.put("publishOnImport", PUBLISH_ON_IMPORT_FIELD);
        map.put("recommendation", RECOMMENDATION_FIELD);
        map.put("schedule", SCHEDULE_FIELD);
        map.put("selfGrantStatus", SELF_GRANT_STATUS_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("type", TYPE_FIELD);
        map.put("updatedAt", UPDATED_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetDataSourceResponse, T> g) {
        return obj -> g.apply((GetDataSourceResponse)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DataZoneResponse.BuilderImpl
    implements Builder {
        private List<FormOutput> assetFormsOutput = DefaultSdkAutoConstructList.getInstance();
        private DataSourceConfigurationOutput configuration;
        private String connectionId;
        private Instant createdAt;
        private String description;
        private String domainId;
        private String enableSetting;
        private String environmentId;
        private DataSourceErrorMessage errorMessage;
        private String id;
        private Integer lastRunAssetCount;
        private Instant lastRunAt;
        private DataSourceErrorMessage lastRunErrorMessage;
        private String lastRunStatus;
        private String name;
        private String projectId;
        private Boolean publishOnImport;
        private RecommendationConfiguration recommendation;
        private ScheduleConfiguration schedule;
        private SelfGrantStatusOutput selfGrantStatus;
        private String status;
        private String type;
        private Instant updatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDataSourceResponse model) {
            super(model);
            this.assetFormsOutput(model.assetFormsOutput);
            this.configuration(model.configuration);
            this.connectionId(model.connectionId);
            this.createdAt(model.createdAt);
            this.description(model.description);
            this.domainId(model.domainId);
            this.enableSetting(model.enableSetting);
            this.environmentId(model.environmentId);
            this.errorMessage(model.errorMessage);
            this.id(model.id);
            this.lastRunAssetCount(model.lastRunAssetCount);
            this.lastRunAt(model.lastRunAt);
            this.lastRunErrorMessage(model.lastRunErrorMessage);
            this.lastRunStatus(model.lastRunStatus);
            this.name(model.name);
            this.projectId(model.projectId);
            this.publishOnImport(model.publishOnImport);
            this.recommendation(model.recommendation);
            this.schedule(model.schedule);
            this.selfGrantStatus(model.selfGrantStatus);
            this.status(model.status);
            this.type(model.type);
            this.updatedAt(model.updatedAt);
        }

        public final List<FormOutput.Builder> getAssetFormsOutput() {
            List<FormOutput.Builder> result = FormOutputListCopier.copyToBuilder(this.assetFormsOutput);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAssetFormsOutput(Collection<FormOutput.BuilderImpl> assetFormsOutput) {
            this.assetFormsOutput = FormOutputListCopier.copyFromBuilder(assetFormsOutput);
        }

        @Override
        public final Builder assetFormsOutput(Collection<FormOutput> assetFormsOutput) {
            this.assetFormsOutput = FormOutputListCopier.copy(assetFormsOutput);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assetFormsOutput(FormOutput ... assetFormsOutput) {
            this.assetFormsOutput(Arrays.asList(assetFormsOutput));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assetFormsOutput(Consumer<FormOutput.Builder> ... assetFormsOutput) {
            this.assetFormsOutput(Stream.of(assetFormsOutput).map(c -> (FormOutput)((FormOutput.Builder)FormOutput.builder().applyMutation(c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final DataSourceConfigurationOutput.Builder getConfiguration() {
            return this.configuration != null ? this.configuration.toBuilder() : null;
        }

        public final void setConfiguration(DataSourceConfigurationOutput.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        @Override
        public final Builder configuration(DataSourceConfigurationOutput configuration) {
            this.configuration = configuration;
            return this;
        }

        public final String getConnectionId() {
            return this.connectionId;
        }

        public final void setConnectionId(String connectionId) {
            this.connectionId = connectionId;
        }

        @Override
        public final Builder connectionId(String connectionId) {
            this.connectionId = connectionId;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDomainId() {
            return this.domainId;
        }

        public final void setDomainId(String domainId) {
            this.domainId = domainId;
        }

        @Override
        public final Builder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public final String getEnableSetting() {
            return this.enableSetting;
        }

        public final void setEnableSetting(String enableSetting) {
            this.enableSetting = enableSetting;
        }

        @Override
        public final Builder enableSetting(String enableSetting) {
            this.enableSetting = enableSetting;
            return this;
        }

        @Override
        public final Builder enableSetting(EnableSetting enableSetting) {
            this.enableSetting(enableSetting == null ? null : enableSetting.toString());
            return this;
        }

        public final String getEnvironmentId() {
            return this.environmentId;
        }

        public final void setEnvironmentId(String environmentId) {
            this.environmentId = environmentId;
        }

        @Override
        public final Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        public final DataSourceErrorMessage.Builder getErrorMessage() {
            return this.errorMessage != null ? this.errorMessage.toBuilder() : null;
        }

        public final void setErrorMessage(DataSourceErrorMessage.BuilderImpl errorMessage) {
            this.errorMessage = errorMessage != null ? errorMessage.build() : null;
        }

        @Override
        public final Builder errorMessage(DataSourceErrorMessage errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final Integer getLastRunAssetCount() {
            return this.lastRunAssetCount;
        }

        public final void setLastRunAssetCount(Integer lastRunAssetCount) {
            this.lastRunAssetCount = lastRunAssetCount;
        }

        @Override
        public final Builder lastRunAssetCount(Integer lastRunAssetCount) {
            this.lastRunAssetCount = lastRunAssetCount;
            return this;
        }

        public final Instant getLastRunAt() {
            return this.lastRunAt;
        }

        public final void setLastRunAt(Instant lastRunAt) {
            this.lastRunAt = lastRunAt;
        }

        @Override
        public final Builder lastRunAt(Instant lastRunAt) {
            this.lastRunAt = lastRunAt;
            return this;
        }

        public final DataSourceErrorMessage.Builder getLastRunErrorMessage() {
            return this.lastRunErrorMessage != null ? this.lastRunErrorMessage.toBuilder() : null;
        }

        public final void setLastRunErrorMessage(DataSourceErrorMessage.BuilderImpl lastRunErrorMessage) {
            this.lastRunErrorMessage = lastRunErrorMessage != null ? lastRunErrorMessage.build() : null;
        }

        @Override
        public final Builder lastRunErrorMessage(DataSourceErrorMessage lastRunErrorMessage) {
            this.lastRunErrorMessage = lastRunErrorMessage;
            return this;
        }

        public final String getLastRunStatus() {
            return this.lastRunStatus;
        }

        public final void setLastRunStatus(String lastRunStatus) {
            this.lastRunStatus = lastRunStatus;
        }

        @Override
        public final Builder lastRunStatus(String lastRunStatus) {
            this.lastRunStatus = lastRunStatus;
            return this;
        }

        @Override
        public final Builder lastRunStatus(DataSourceRunStatus lastRunStatus) {
            this.lastRunStatus(lastRunStatus == null ? null : lastRunStatus.toString());
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getProjectId() {
            return this.projectId;
        }

        public final void setProjectId(String projectId) {
            this.projectId = projectId;
        }

        @Override
        public final Builder projectId(String projectId) {
            this.projectId = projectId;
            return this;
        }

        public final Boolean getPublishOnImport() {
            return this.publishOnImport;
        }

        public final void setPublishOnImport(Boolean publishOnImport) {
            this.publishOnImport = publishOnImport;
        }

        @Override
        public final Builder publishOnImport(Boolean publishOnImport) {
            this.publishOnImport = publishOnImport;
            return this;
        }

        public final RecommendationConfiguration.Builder getRecommendation() {
            return this.recommendation != null ? this.recommendation.toBuilder() : null;
        }

        public final void setRecommendation(RecommendationConfiguration.BuilderImpl recommendation) {
            this.recommendation = recommendation != null ? recommendation.build() : null;
        }

        @Override
        public final Builder recommendation(RecommendationConfiguration recommendation) {
            this.recommendation = recommendation;
            return this;
        }

        public final ScheduleConfiguration.Builder getSchedule() {
            return this.schedule != null ? this.schedule.toBuilder() : null;
        }

        public final void setSchedule(ScheduleConfiguration.BuilderImpl schedule) {
            this.schedule = schedule != null ? schedule.build() : null;
        }

        @Override
        public final Builder schedule(ScheduleConfiguration schedule) {
            this.schedule = schedule;
            return this;
        }

        public final SelfGrantStatusOutput.Builder getSelfGrantStatus() {
            return this.selfGrantStatus != null ? this.selfGrantStatus.toBuilder() : null;
        }

        public final void setSelfGrantStatus(SelfGrantStatusOutput.BuilderImpl selfGrantStatus) {
            this.selfGrantStatus = selfGrantStatus != null ? selfGrantStatus.build() : null;
        }

        @Override
        public final Builder selfGrantStatus(SelfGrantStatusOutput selfGrantStatus) {
            this.selfGrantStatus = selfGrantStatus;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(DataSourceStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @Override
        public GetDataSourceResponse build() {
            return new GetDataSourceResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends DataZoneResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetDataSourceResponse> {
        public Builder assetFormsOutput(Collection<FormOutput> var1);

        public Builder assetFormsOutput(FormOutput ... var1);

        public Builder assetFormsOutput(Consumer<FormOutput.Builder> ... var1);

        public Builder configuration(DataSourceConfigurationOutput var1);

        default public Builder configuration(Consumer<DataSourceConfigurationOutput.Builder> configuration) {
            return this.configuration((DataSourceConfigurationOutput)DataSourceConfigurationOutput.builder().applyMutation(configuration).build());
        }

        public Builder connectionId(String var1);

        public Builder createdAt(Instant var1);

        public Builder description(String var1);

        public Builder domainId(String var1);

        public Builder enableSetting(String var1);

        public Builder enableSetting(EnableSetting var1);

        public Builder environmentId(String var1);

        public Builder errorMessage(DataSourceErrorMessage var1);

        default public Builder errorMessage(Consumer<DataSourceErrorMessage.Builder> errorMessage) {
            return this.errorMessage((DataSourceErrorMessage)DataSourceErrorMessage.builder().applyMutation(errorMessage).build());
        }

        public Builder id(String var1);

        public Builder lastRunAssetCount(Integer var1);

        public Builder lastRunAt(Instant var1);

        public Builder lastRunErrorMessage(DataSourceErrorMessage var1);

        default public Builder lastRunErrorMessage(Consumer<DataSourceErrorMessage.Builder> lastRunErrorMessage) {
            return this.lastRunErrorMessage((DataSourceErrorMessage)DataSourceErrorMessage.builder().applyMutation(lastRunErrorMessage).build());
        }

        public Builder lastRunStatus(String var1);

        public Builder lastRunStatus(DataSourceRunStatus var1);

        public Builder name(String var1);

        public Builder projectId(String var1);

        public Builder publishOnImport(Boolean var1);

        public Builder recommendation(RecommendationConfiguration var1);

        default public Builder recommendation(Consumer<RecommendationConfiguration.Builder> recommendation) {
            return this.recommendation((RecommendationConfiguration)RecommendationConfiguration.builder().applyMutation(recommendation).build());
        }

        public Builder schedule(ScheduleConfiguration var1);

        default public Builder schedule(Consumer<ScheduleConfiguration.Builder> schedule) {
            return this.schedule((ScheduleConfiguration)ScheduleConfiguration.builder().applyMutation(schedule).build());
        }

        public Builder selfGrantStatus(SelfGrantStatusOutput var1);

        default public Builder selfGrantStatus(Consumer<SelfGrantStatusOutput.Builder> selfGrantStatus) {
            return this.selfGrantStatus((SelfGrantStatusOutput)SelfGrantStatusOutput.builder().applyMutation(selfGrantStatus).build());
        }

        public Builder status(String var1);

        public Builder status(DataSourceStatus var1);

        public Builder type(String var1);

        public Builder updatedAt(Instant var1);
    }
}

