/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.datazone.model.DataZoneResponse;
import software.amazon.awssdk.services.datazone.model.EnabledRegionListCopier;
import software.amazon.awssdk.services.datazone.model.ProvisioningConfiguration;
import software.amazon.awssdk.services.datazone.model.ProvisioningConfigurationListCopier;
import software.amazon.awssdk.services.datazone.model.RegionalParameterMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetEnvironmentBlueprintConfigurationResponse
extends DataZoneResponse
implements ToCopyableBuilder<Builder, GetEnvironmentBlueprintConfigurationResponse> {
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder(MarshallingType.INSTANT).memberName("createdAt").getter(GetEnvironmentBlueprintConfigurationResponse.getter(GetEnvironmentBlueprintConfigurationResponse::createdAt)).setter(GetEnvironmentBlueprintConfigurationResponse.setter(Builder::createdAt)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(), TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();
    private static final SdkField<String> DOMAIN_ID_FIELD = SdkField.builder(MarshallingType.STRING).memberName("domainId").getter(GetEnvironmentBlueprintConfigurationResponse.getter(GetEnvironmentBlueprintConfigurationResponse::domainId)).setter(GetEnvironmentBlueprintConfigurationResponse.setter(Builder::domainId)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainId").build()).build();
    private static final SdkField<List<String>> ENABLED_REGIONS_FIELD = SdkField.builder(MarshallingType.LIST).memberName("enabledRegions").getter(GetEnvironmentBlueprintConfigurationResponse.getter(GetEnvironmentBlueprintConfigurationResponse::enabledRegions)).setter(GetEnvironmentBlueprintConfigurationResponse.setter(Builder::enabledRegions)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enabledRegions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder(MarshallingType.STRING).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()).build()).build()).build();
    private static final SdkField<String> ENVIRONMENT_BLUEPRINT_ID_FIELD = SdkField.builder(MarshallingType.STRING).memberName("environmentBlueprintId").getter(GetEnvironmentBlueprintConfigurationResponse.getter(GetEnvironmentBlueprintConfigurationResponse::environmentBlueprintId)).setter(GetEnvironmentBlueprintConfigurationResponse.setter(Builder::environmentBlueprintId)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentBlueprintId").build()).build();
    private static final SdkField<String> ENVIRONMENT_ROLE_PERMISSION_BOUNDARY_FIELD = SdkField.builder(MarshallingType.STRING).memberName("environmentRolePermissionBoundary").getter(GetEnvironmentBlueprintConfigurationResponse.getter(GetEnvironmentBlueprintConfigurationResponse::environmentRolePermissionBoundary)).setter(GetEnvironmentBlueprintConfigurationResponse.setter(Builder::environmentRolePermissionBoundary)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentRolePermissionBoundary").build()).build();
    private static final SdkField<String> MANAGE_ACCESS_ROLE_ARN_FIELD = SdkField.builder(MarshallingType.STRING).memberName("manageAccessRoleArn").getter(GetEnvironmentBlueprintConfigurationResponse.getter(GetEnvironmentBlueprintConfigurationResponse::manageAccessRoleArn)).setter(GetEnvironmentBlueprintConfigurationResponse.setter(Builder::manageAccessRoleArn)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("manageAccessRoleArn").build()).build();
    private static final SdkField<List<ProvisioningConfiguration>> PROVISIONING_CONFIGURATIONS_FIELD = SdkField.builder(MarshallingType.LIST).memberName("provisioningConfigurations").getter(GetEnvironmentBlueprintConfigurationResponse.getter(GetEnvironmentBlueprintConfigurationResponse::provisioningConfigurations)).setter(GetEnvironmentBlueprintConfigurationResponse.setter(Builder::provisioningConfigurations)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("provisioningConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder(MarshallingType.SDK_POJO).constructor(ProvisioningConfiguration::builder).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()).build()).build()).build();
    private static final SdkField<String> PROVISIONING_ROLE_ARN_FIELD = SdkField.builder(MarshallingType.STRING).memberName("provisioningRoleArn").getter(GetEnvironmentBlueprintConfigurationResponse.getter(GetEnvironmentBlueprintConfigurationResponse::provisioningRoleArn)).setter(GetEnvironmentBlueprintConfigurationResponse.setter(Builder::provisioningRoleArn)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("provisioningRoleArn").build()).build();
    private static final SdkField<Map<String, Map<String, String>>> REGIONAL_PARAMETERS_FIELD = SdkField.builder(MarshallingType.MAP).memberName("regionalParameters").getter(GetEnvironmentBlueprintConfigurationResponse.getter(GetEnvironmentBlueprintConfigurationResponse::regionalParameters)).setter(GetEnvironmentBlueprintConfigurationResponse.setter(Builder::regionalParameters)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("regionalParameters").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder(MarshallingType.MAP).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder(MarshallingType.STRING).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()).build()).build()).build()).build()).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder(MarshallingType.INSTANT).memberName("updatedAt").getter(GetEnvironmentBlueprintConfigurationResponse.getter(GetEnvironmentBlueprintConfigurationResponse::updatedAt)).setter(GetEnvironmentBlueprintConfigurationResponse.setter(Builder::updatedAt)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build(), TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATED_AT_FIELD, DOMAIN_ID_FIELD, ENABLED_REGIONS_FIELD, ENVIRONMENT_BLUEPRINT_ID_FIELD, ENVIRONMENT_ROLE_PERMISSION_BOUNDARY_FIELD, MANAGE_ACCESS_ROLE_ARN_FIELD, PROVISIONING_CONFIGURATIONS_FIELD, PROVISIONING_ROLE_ARN_FIELD, REGIONAL_PARAMETERS_FIELD, UPDATED_AT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetEnvironmentBlueprintConfigurationResponse.memberNameToFieldInitializer();
    private final Instant createdAt;
    private final String domainId;
    private final List<String> enabledRegions;
    private final String environmentBlueprintId;
    private final String environmentRolePermissionBoundary;
    private final String manageAccessRoleArn;
    private final List<ProvisioningConfiguration> provisioningConfigurations;
    private final String provisioningRoleArn;
    private final Map<String, Map<String, String>> regionalParameters;
    private final Instant updatedAt;

    private GetEnvironmentBlueprintConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.createdAt = builder.createdAt;
        this.domainId = builder.domainId;
        this.enabledRegions = builder.enabledRegions;
        this.environmentBlueprintId = builder.environmentBlueprintId;
        this.environmentRolePermissionBoundary = builder.environmentRolePermissionBoundary;
        this.manageAccessRoleArn = builder.manageAccessRoleArn;
        this.provisioningConfigurations = builder.provisioningConfigurations;
        this.provisioningRoleArn = builder.provisioningRoleArn;
        this.regionalParameters = builder.regionalParameters;
        this.updatedAt = builder.updatedAt;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final String domainId() {
        return this.domainId;
    }

    public final boolean hasEnabledRegions() {
        return this.enabledRegions != null && !(this.enabledRegions instanceof SdkAutoConstructList);
    }

    public final List<String> enabledRegions() {
        return this.enabledRegions;
    }

    public final String environmentBlueprintId() {
        return this.environmentBlueprintId;
    }

    public final String environmentRolePermissionBoundary() {
        return this.environmentRolePermissionBoundary;
    }

    public final String manageAccessRoleArn() {
        return this.manageAccessRoleArn;
    }

    public final boolean hasProvisioningConfigurations() {
        return this.provisioningConfigurations != null && !(this.provisioningConfigurations instanceof SdkAutoConstructList);
    }

    public final List<ProvisioningConfiguration> provisioningConfigurations() {
        return this.provisioningConfigurations;
    }

    public final String provisioningRoleArn() {
        return this.provisioningRoleArn;
    }

    public final boolean hasRegionalParameters() {
        return this.regionalParameters != null && !(this.regionalParameters instanceof SdkAutoConstructMap);
    }

    public final Map<String, Map<String, String>> regionalParameters() {
        return this.regionalParameters;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEnabledRegions() ? this.enabledRegions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentBlueprintId());
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentRolePermissionBoundary());
        hashCode = 31 * hashCode + Objects.hashCode(this.manageAccessRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProvisioningConfigurations() ? this.provisioningConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.provisioningRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRegionalParameters() ? this.regionalParameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetEnvironmentBlueprintConfigurationResponse)) {
            return false;
        }
        GetEnvironmentBlueprintConfigurationResponse other = (GetEnvironmentBlueprintConfigurationResponse)obj;
        return Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.domainId(), other.domainId()) && this.hasEnabledRegions() == other.hasEnabledRegions() && Objects.equals(this.enabledRegions(), other.enabledRegions()) && Objects.equals(this.environmentBlueprintId(), other.environmentBlueprintId()) && Objects.equals(this.environmentRolePermissionBoundary(), other.environmentRolePermissionBoundary()) && Objects.equals(this.manageAccessRoleArn(), other.manageAccessRoleArn()) && this.hasProvisioningConfigurations() == other.hasProvisioningConfigurations() && Objects.equals(this.provisioningConfigurations(), other.provisioningConfigurations()) && Objects.equals(this.provisioningRoleArn(), other.provisioningRoleArn()) && this.hasRegionalParameters() == other.hasRegionalParameters() && Objects.equals(this.regionalParameters(), other.regionalParameters()) && Objects.equals(this.updatedAt(), other.updatedAt());
    }

    public final String toString() {
        return ToString.builder("GetEnvironmentBlueprintConfigurationResponse").add("CreatedAt", this.createdAt()).add("DomainId", this.domainId()).add("EnabledRegions", this.hasEnabledRegions() ? this.enabledRegions() : null).add("EnvironmentBlueprintId", this.environmentBlueprintId()).add("EnvironmentRolePermissionBoundary", this.environmentRolePermissionBoundary()).add("ManageAccessRoleArn", this.manageAccessRoleArn()).add("ProvisioningConfigurations", this.hasProvisioningConfigurations() ? this.provisioningConfigurations() : null).add("ProvisioningRoleArn", this.provisioningRoleArn()).add("RegionalParameters", this.hasRegionalParameters() ? this.regionalParameters() : null).add("UpdatedAt", this.updatedAt()).build();
    }

    @Override
    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "domainId": {
                return Optional.ofNullable(clazz.cast(this.domainId()));
            }
            case "enabledRegions": {
                return Optional.ofNullable(clazz.cast(this.enabledRegions()));
            }
            case "environmentBlueprintId": {
                return Optional.ofNullable(clazz.cast(this.environmentBlueprintId()));
            }
            case "environmentRolePermissionBoundary": {
                return Optional.ofNullable(clazz.cast(this.environmentRolePermissionBoundary()));
            }
            case "manageAccessRoleArn": {
                return Optional.ofNullable(clazz.cast(this.manageAccessRoleArn()));
            }
            case "provisioningConfigurations": {
                return Optional.ofNullable(clazz.cast(this.provisioningConfigurations()));
            }
            case "provisioningRoleArn": {
                return Optional.ofNullable(clazz.cast(this.provisioningRoleArn()));
            }
            case "regionalParameters": {
                return Optional.ofNullable(clazz.cast(this.regionalParameters()));
            }
            case "updatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
        }
        return Optional.empty();
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<Object>> map = new HashMap<String, SdkField<Object>>();
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("domainId", DOMAIN_ID_FIELD);
        map.put("enabledRegions", ENABLED_REGIONS_FIELD);
        map.put("environmentBlueprintId", ENVIRONMENT_BLUEPRINT_ID_FIELD);
        map.put("environmentRolePermissionBoundary", ENVIRONMENT_ROLE_PERMISSION_BOUNDARY_FIELD);
        map.put("manageAccessRoleArn", MANAGE_ACCESS_ROLE_ARN_FIELD);
        map.put("provisioningConfigurations", PROVISIONING_CONFIGURATIONS_FIELD);
        map.put("provisioningRoleArn", PROVISIONING_ROLE_ARN_FIELD);
        map.put("regionalParameters", REGIONAL_PARAMETERS_FIELD);
        map.put("updatedAt", UPDATED_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetEnvironmentBlueprintConfigurationResponse, T> g) {
        return obj -> g.apply((GetEnvironmentBlueprintConfigurationResponse)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DataZoneResponse.BuilderImpl
    implements Builder {
        private Instant createdAt;
        private String domainId;
        private List<String> enabledRegions = DefaultSdkAutoConstructList.getInstance();
        private String environmentBlueprintId;
        private String environmentRolePermissionBoundary;
        private String manageAccessRoleArn;
        private List<ProvisioningConfiguration> provisioningConfigurations = DefaultSdkAutoConstructList.getInstance();
        private String provisioningRoleArn;
        private Map<String, Map<String, String>> regionalParameters = DefaultSdkAutoConstructMap.getInstance();
        private Instant updatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(GetEnvironmentBlueprintConfigurationResponse model) {
            super(model);
            this.createdAt(model.createdAt);
            this.domainId(model.domainId);
            this.enabledRegions(model.enabledRegions);
            this.environmentBlueprintId(model.environmentBlueprintId);
            this.environmentRolePermissionBoundary(model.environmentRolePermissionBoundary);
            this.manageAccessRoleArn(model.manageAccessRoleArn);
            this.provisioningConfigurations(model.provisioningConfigurations);
            this.provisioningRoleArn(model.provisioningRoleArn);
            this.regionalParameters(model.regionalParameters);
            this.updatedAt(model.updatedAt);
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getDomainId() {
            return this.domainId;
        }

        public final void setDomainId(String domainId) {
            this.domainId = domainId;
        }

        @Override
        public final Builder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public final Collection<String> getEnabledRegions() {
            if (this.enabledRegions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.enabledRegions;
        }

        public final void setEnabledRegions(Collection<String> enabledRegions) {
            this.enabledRegions = EnabledRegionListCopier.copy(enabledRegions);
        }

        @Override
        public final Builder enabledRegions(Collection<String> enabledRegions) {
            this.enabledRegions = EnabledRegionListCopier.copy(enabledRegions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder enabledRegions(String ... enabledRegions) {
            this.enabledRegions(Arrays.asList(enabledRegions));
            return this;
        }

        public final String getEnvironmentBlueprintId() {
            return this.environmentBlueprintId;
        }

        public final void setEnvironmentBlueprintId(String environmentBlueprintId) {
            this.environmentBlueprintId = environmentBlueprintId;
        }

        @Override
        public final Builder environmentBlueprintId(String environmentBlueprintId) {
            this.environmentBlueprintId = environmentBlueprintId;
            return this;
        }

        public final String getEnvironmentRolePermissionBoundary() {
            return this.environmentRolePermissionBoundary;
        }

        public final void setEnvironmentRolePermissionBoundary(String environmentRolePermissionBoundary) {
            this.environmentRolePermissionBoundary = environmentRolePermissionBoundary;
        }

        @Override
        public final Builder environmentRolePermissionBoundary(String environmentRolePermissionBoundary) {
            this.environmentRolePermissionBoundary = environmentRolePermissionBoundary;
            return this;
        }

        public final String getManageAccessRoleArn() {
            return this.manageAccessRoleArn;
        }

        public final void setManageAccessRoleArn(String manageAccessRoleArn) {
            this.manageAccessRoleArn = manageAccessRoleArn;
        }

        @Override
        public final Builder manageAccessRoleArn(String manageAccessRoleArn) {
            this.manageAccessRoleArn = manageAccessRoleArn;
            return this;
        }

        public final List<ProvisioningConfiguration.Builder> getProvisioningConfigurations() {
            List<ProvisioningConfiguration.Builder> result = ProvisioningConfigurationListCopier.copyToBuilder(this.provisioningConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProvisioningConfigurations(Collection<ProvisioningConfiguration.BuilderImpl> provisioningConfigurations) {
            this.provisioningConfigurations = ProvisioningConfigurationListCopier.copyFromBuilder(provisioningConfigurations);
        }

        @Override
        public final Builder provisioningConfigurations(Collection<ProvisioningConfiguration> provisioningConfigurations) {
            this.provisioningConfigurations = ProvisioningConfigurationListCopier.copy(provisioningConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder provisioningConfigurations(ProvisioningConfiguration ... provisioningConfigurations) {
            this.provisioningConfigurations(Arrays.asList(provisioningConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder provisioningConfigurations(Consumer<ProvisioningConfiguration.Builder> ... provisioningConfigurations) {
            this.provisioningConfigurations(Stream.of(provisioningConfigurations).map(c -> (ProvisioningConfiguration)((ProvisioningConfiguration.Builder)ProvisioningConfiguration.builder().applyMutation(c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getProvisioningRoleArn() {
            return this.provisioningRoleArn;
        }

        public final void setProvisioningRoleArn(String provisioningRoleArn) {
            this.provisioningRoleArn = provisioningRoleArn;
        }

        @Override
        public final Builder provisioningRoleArn(String provisioningRoleArn) {
            this.provisioningRoleArn = provisioningRoleArn;
            return this;
        }

        public final Map<String, ? extends Map<String, String>> getRegionalParameters() {
            if (this.regionalParameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.regionalParameters;
        }

        public final void setRegionalParameters(Map<String, ? extends Map<String, String>> regionalParameters) {
            this.regionalParameters = RegionalParameterMapCopier.copy(regionalParameters);
        }

        @Override
        public final Builder regionalParameters(Map<String, ? extends Map<String, String>> regionalParameters) {
            this.regionalParameters = RegionalParameterMapCopier.copy(regionalParameters);
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @Override
        public GetEnvironmentBlueprintConfigurationResponse build() {
            return new GetEnvironmentBlueprintConfigurationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends DataZoneResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetEnvironmentBlueprintConfigurationResponse> {
        public Builder createdAt(Instant var1);

        public Builder domainId(String var1);

        public Builder enabledRegions(Collection<String> var1);

        public Builder enabledRegions(String ... var1);

        public Builder environmentBlueprintId(String var1);

        public Builder environmentRolePermissionBoundary(String var1);

        public Builder manageAccessRoleArn(String var1);

        public Builder provisioningConfigurations(Collection<ProvisioningConfiguration> var1);

        public Builder provisioningConfigurations(ProvisioningConfiguration ... var1);

        public Builder provisioningConfigurations(Consumer<ProvisioningConfiguration.Builder> ... var1);

        public Builder provisioningRoleArn(String var1);

        public Builder regionalParameters(Map<String, ? extends Map<String, String>> var1);

        public Builder updatedAt(Instant var1);
    }
}

