/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.datazone.model.ConfigurableEnvironmentAction;
import software.amazon.awssdk.services.datazone.model.CustomParameter;
import software.amazon.awssdk.services.datazone.model.CustomParameterListCopier;
import software.amazon.awssdk.services.datazone.model.DataZoneResponse;
import software.amazon.awssdk.services.datazone.model.Deployment;
import software.amazon.awssdk.services.datazone.model.DeploymentProperties;
import software.amazon.awssdk.services.datazone.model.EnvironmentActionListCopier;
import software.amazon.awssdk.services.datazone.model.EnvironmentStatus;
import software.amazon.awssdk.services.datazone.model.GlossaryTermsCopier;
import software.amazon.awssdk.services.datazone.model.ProvisioningProperties;
import software.amazon.awssdk.services.datazone.model.Resource;
import software.amazon.awssdk.services.datazone.model.ResourceListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetEnvironmentResponse
extends DataZoneResponse
implements ToCopyableBuilder<Builder, GetEnvironmentResponse> {
    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.builder(MarshallingType.STRING).memberName("awsAccountId").getter(GetEnvironmentResponse.getter(GetEnvironmentResponse::awsAccountId)).setter(GetEnvironmentResponse.setter(Builder::awsAccountId)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsAccountId").build()).build();
    private static final SdkField<String> AWS_ACCOUNT_REGION_FIELD = SdkField.builder(MarshallingType.STRING).memberName("awsAccountRegion").getter(GetEnvironmentResponse.getter(GetEnvironmentResponse::awsAccountRegion)).setter(GetEnvironmentResponse.setter(Builder::awsAccountRegion)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsAccountRegion").build()).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder(MarshallingType.INSTANT).memberName("createdAt").getter(GetEnvironmentResponse.getter(GetEnvironmentResponse::createdAt)).setter(GetEnvironmentResponse.setter(Builder::createdAt)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(), TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();
    private static final SdkField<String> CREATED_BY_FIELD = SdkField.builder(MarshallingType.STRING).memberName("createdBy").getter(GetEnvironmentResponse.getter(GetEnvironmentResponse::createdBy)).setter(GetEnvironmentResponse.setter(Builder::createdBy)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdBy").build()).build();
    private static final SdkField<DeploymentProperties> DEPLOYMENT_PROPERTIES_FIELD = SdkField.builder(MarshallingType.SDK_POJO).memberName("deploymentProperties").getter(GetEnvironmentResponse.getter(GetEnvironmentResponse::deploymentProperties)).setter(GetEnvironmentResponse.setter(Builder::deploymentProperties)).constructor(DeploymentProperties::builder).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentProperties").build()).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder(MarshallingType.STRING).memberName("description").getter(GetEnvironmentResponse.getter(GetEnvironmentResponse::description)).setter(GetEnvironmentResponse.setter(Builder::description)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();
    private static final SdkField<String> DOMAIN_ID_FIELD = SdkField.builder(MarshallingType.STRING).memberName("domainId").getter(GetEnvironmentResponse.getter(GetEnvironmentResponse::domainId)).setter(GetEnvironmentResponse.setter(Builder::domainId)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainId").build()).build();
    private static final SdkField<List<ConfigurableEnvironmentAction>> ENVIRONMENT_ACTIONS_FIELD = SdkField.builder(MarshallingType.LIST).memberName("environmentActions").getter(GetEnvironmentResponse.getter(GetEnvironmentResponse::environmentActions)).setter(GetEnvironmentResponse.setter(Builder::environmentActions)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentActions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder(MarshallingType.SDK_POJO).constructor(ConfigurableEnvironmentAction::builder).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()).build()).build()).build();
    private static final SdkField<String> ENVIRONMENT_BLUEPRINT_ID_FIELD = SdkField.builder(MarshallingType.STRING).memberName("environmentBlueprintId").getter(GetEnvironmentResponse.getter(GetEnvironmentResponse::environmentBlueprintId)).setter(GetEnvironmentResponse.setter(Builder::environmentBlueprintId)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentBlueprintId").build()).build();
    private static final SdkField<String> ENVIRONMENT_CONFIGURATION_ID_FIELD = SdkField.builder(MarshallingType.STRING).memberName("environmentConfigurationId").getter(GetEnvironmentResponse.getter(GetEnvironmentResponse::environmentConfigurationId)).setter(GetEnvironmentResponse.setter(Builder::environmentConfigurationId)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentConfigurationId").build()).build();
    private static final SdkField<String> ENVIRONMENT_PROFILE_ID_FIELD = SdkField.builder(MarshallingType.STRING).memberName("environmentProfileId").getter(GetEnvironmentResponse.getter(GetEnvironmentResponse::environmentProfileId)).setter(GetEnvironmentResponse.setter(Builder::environmentProfileId)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentProfileId").build()).build();
    private static final SdkField<List<String>> GLOSSARY_TERMS_FIELD = SdkField.builder(MarshallingType.LIST).memberName("glossaryTerms").getter(GetEnvironmentResponse.getter(GetEnvironmentResponse::glossaryTerms)).setter(GetEnvironmentResponse.setter(Builder::glossaryTerms)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("glossaryTerms").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder(MarshallingType.STRING).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()).build()).build()).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder(MarshallingType.STRING).memberName("id").getter(GetEnvironmentResponse.getter(GetEnvironmentResponse::id)).setter(GetEnvironmentResponse.setter(Builder::id)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();
    private static final SdkField<Deployment> LAST_DEPLOYMENT_FIELD = SdkField.builder(MarshallingType.SDK_POJO).memberName("lastDeployment").getter(GetEnvironmentResponse.getter(GetEnvironmentResponse::lastDeployment)).setter(GetEnvironmentResponse.setter(Builder::lastDeployment)).constructor(Deployment::builder).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastDeployment").build()).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder(MarshallingType.STRING).memberName("name").getter(GetEnvironmentResponse.getter(GetEnvironmentResponse::name)).setter(GetEnvironmentResponse.setter(Builder::name)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();
    private static final SdkField<String> PROJECT_ID_FIELD = SdkField.builder(MarshallingType.STRING).memberName("projectId").getter(GetEnvironmentResponse.getter(GetEnvironmentResponse::projectId)).setter(GetEnvironmentResponse.setter(Builder::projectId)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("projectId").build()).build();
    private static final SdkField<String> PROVIDER_FIELD = SdkField.builder(MarshallingType.STRING).memberName("provider").getter(GetEnvironmentResponse.getter(GetEnvironmentResponse::provider)).setter(GetEnvironmentResponse.setter(Builder::provider)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("provider").build()).build();
    private static final SdkField<List<Resource>> PROVISIONED_RESOURCES_FIELD = SdkField.builder(MarshallingType.LIST).memberName("provisionedResources").getter(GetEnvironmentResponse.getter(GetEnvironmentResponse::provisionedResources)).setter(GetEnvironmentResponse.setter(Builder::provisionedResources)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("provisionedResources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder(MarshallingType.SDK_POJO).constructor(Resource::builder).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()).build()).build()).build();
    private static final SdkField<ProvisioningProperties> PROVISIONING_PROPERTIES_FIELD = SdkField.builder(MarshallingType.SDK_POJO).memberName("provisioningProperties").getter(GetEnvironmentResponse.getter(GetEnvironmentResponse::provisioningProperties)).setter(GetEnvironmentResponse.setter(Builder::provisioningProperties)).constructor(ProvisioningProperties::builder).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("provisioningProperties").build()).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder(MarshallingType.STRING).memberName("status").getter(GetEnvironmentResponse.getter(GetEnvironmentResponse::statusAsString)).setter(GetEnvironmentResponse.setter(Builder::status)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder(MarshallingType.INSTANT).memberName("updatedAt").getter(GetEnvironmentResponse.getter(GetEnvironmentResponse::updatedAt)).setter(GetEnvironmentResponse.setter(Builder::updatedAt)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build(), TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();
    private static final SdkField<List<CustomParameter>> USER_PARAMETERS_FIELD = SdkField.builder(MarshallingType.LIST).memberName("userParameters").getter(GetEnvironmentResponse.getter(GetEnvironmentResponse::userParameters)).setter(GetEnvironmentResponse.setter(Builder::userParameters)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userParameters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder(MarshallingType.SDK_POJO).constructor(CustomParameter::builder).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()).build()).build()).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_ACCOUNT_ID_FIELD, AWS_ACCOUNT_REGION_FIELD, CREATED_AT_FIELD, CREATED_BY_FIELD, DEPLOYMENT_PROPERTIES_FIELD, DESCRIPTION_FIELD, DOMAIN_ID_FIELD, ENVIRONMENT_ACTIONS_FIELD, ENVIRONMENT_BLUEPRINT_ID_FIELD, ENVIRONMENT_CONFIGURATION_ID_FIELD, ENVIRONMENT_PROFILE_ID_FIELD, GLOSSARY_TERMS_FIELD, ID_FIELD, LAST_DEPLOYMENT_FIELD, NAME_FIELD, PROJECT_ID_FIELD, PROVIDER_FIELD, PROVISIONED_RESOURCES_FIELD, PROVISIONING_PROPERTIES_FIELD, STATUS_FIELD, UPDATED_AT_FIELD, USER_PARAMETERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetEnvironmentResponse.memberNameToFieldInitializer();
    private final String awsAccountId;
    private final String awsAccountRegion;
    private final Instant createdAt;
    private final String createdBy;
    private final DeploymentProperties deploymentProperties;
    private final String description;
    private final String domainId;
    private final List<ConfigurableEnvironmentAction> environmentActions;
    private final String environmentBlueprintId;
    private final String environmentConfigurationId;
    private final String environmentProfileId;
    private final List<String> glossaryTerms;
    private final String id;
    private final Deployment lastDeployment;
    private final String name;
    private final String projectId;
    private final String provider;
    private final List<Resource> provisionedResources;
    private final ProvisioningProperties provisioningProperties;
    private final String status;
    private final Instant updatedAt;
    private final List<CustomParameter> userParameters;

    private GetEnvironmentResponse(BuilderImpl builder) {
        super(builder);
        this.awsAccountId = builder.awsAccountId;
        this.awsAccountRegion = builder.awsAccountRegion;
        this.createdAt = builder.createdAt;
        this.createdBy = builder.createdBy;
        this.deploymentProperties = builder.deploymentProperties;
        this.description = builder.description;
        this.domainId = builder.domainId;
        this.environmentActions = builder.environmentActions;
        this.environmentBlueprintId = builder.environmentBlueprintId;
        this.environmentConfigurationId = builder.environmentConfigurationId;
        this.environmentProfileId = builder.environmentProfileId;
        this.glossaryTerms = builder.glossaryTerms;
        this.id = builder.id;
        this.lastDeployment = builder.lastDeployment;
        this.name = builder.name;
        this.projectId = builder.projectId;
        this.provider = builder.provider;
        this.provisionedResources = builder.provisionedResources;
        this.provisioningProperties = builder.provisioningProperties;
        this.status = builder.status;
        this.updatedAt = builder.updatedAt;
        this.userParameters = builder.userParameters;
    }

    public final String awsAccountId() {
        return this.awsAccountId;
    }

    public final String awsAccountRegion() {
        return this.awsAccountRegion;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final String createdBy() {
        return this.createdBy;
    }

    public final DeploymentProperties deploymentProperties() {
        return this.deploymentProperties;
    }

    public final String description() {
        return this.description;
    }

    public final String domainId() {
        return this.domainId;
    }

    public final boolean hasEnvironmentActions() {
        return this.environmentActions != null && !(this.environmentActions instanceof SdkAutoConstructList);
    }

    public final List<ConfigurableEnvironmentAction> environmentActions() {
        return this.environmentActions;
    }

    public final String environmentBlueprintId() {
        return this.environmentBlueprintId;
    }

    public final String environmentConfigurationId() {
        return this.environmentConfigurationId;
    }

    public final String environmentProfileId() {
        return this.environmentProfileId;
    }

    public final boolean hasGlossaryTerms() {
        return this.glossaryTerms != null && !(this.glossaryTerms instanceof SdkAutoConstructList);
    }

    public final List<String> glossaryTerms() {
        return this.glossaryTerms;
    }

    public final String id() {
        return this.id;
    }

    public final Deployment lastDeployment() {
        return this.lastDeployment;
    }

    public final String name() {
        return this.name;
    }

    public final String projectId() {
        return this.projectId;
    }

    public final String provider() {
        return this.provider;
    }

    public final boolean hasProvisionedResources() {
        return this.provisionedResources != null && !(this.provisionedResources instanceof SdkAutoConstructList);
    }

    public final List<Resource> provisionedResources() {
        return this.provisionedResources;
    }

    public final ProvisioningProperties provisioningProperties() {
        return this.provisioningProperties;
    }

    public final EnvironmentStatus status() {
        return EnvironmentStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public final boolean hasUserParameters() {
        return this.userParameters != null && !(this.userParameters instanceof SdkAutoConstructList);
    }

    public final List<CustomParameter> userParameters() {
        return this.userParameters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.awsAccountRegion());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentProperties());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEnvironmentActions() ? this.environmentActions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentBlueprintId());
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentConfigurationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentProfileId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGlossaryTerms() ? this.glossaryTerms() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastDeployment());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.projectId());
        hashCode = 31 * hashCode + Objects.hashCode(this.provider());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProvisionedResources() ? this.provisionedResources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.provisioningProperties());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUserParameters() ? this.userParameters() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetEnvironmentResponse)) {
            return false;
        }
        GetEnvironmentResponse other = (GetEnvironmentResponse)obj;
        return Objects.equals(this.awsAccountId(), other.awsAccountId()) && Objects.equals(this.awsAccountRegion(), other.awsAccountRegion()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.createdBy(), other.createdBy()) && Objects.equals(this.deploymentProperties(), other.deploymentProperties()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.domainId(), other.domainId()) && this.hasEnvironmentActions() == other.hasEnvironmentActions() && Objects.equals(this.environmentActions(), other.environmentActions()) && Objects.equals(this.environmentBlueprintId(), other.environmentBlueprintId()) && Objects.equals(this.environmentConfigurationId(), other.environmentConfigurationId()) && Objects.equals(this.environmentProfileId(), other.environmentProfileId()) && this.hasGlossaryTerms() == other.hasGlossaryTerms() && Objects.equals(this.glossaryTerms(), other.glossaryTerms()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.lastDeployment(), other.lastDeployment()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.projectId(), other.projectId()) && Objects.equals(this.provider(), other.provider()) && this.hasProvisionedResources() == other.hasProvisionedResources() && Objects.equals(this.provisionedResources(), other.provisionedResources()) && Objects.equals(this.provisioningProperties(), other.provisioningProperties()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.updatedAt(), other.updatedAt()) && this.hasUserParameters() == other.hasUserParameters() && Objects.equals(this.userParameters(), other.userParameters());
    }

    public final String toString() {
        return ToString.builder("GetEnvironmentResponse").add("AwsAccountId", this.awsAccountId()).add("AwsAccountRegion", this.awsAccountRegion()).add("CreatedAt", this.createdAt()).add("CreatedBy", this.createdBy()).add("DeploymentProperties", this.deploymentProperties()).add("Description", this.description() == null ? null : "*** Sensitive Data Redacted ***").add("DomainId", this.domainId()).add("EnvironmentActions", this.hasEnvironmentActions() ? this.environmentActions() : null).add("EnvironmentBlueprintId", this.environmentBlueprintId()).add("EnvironmentConfigurationId", this.environmentConfigurationId() == null ? null : "*** Sensitive Data Redacted ***").add("EnvironmentProfileId", this.environmentProfileId()).add("GlossaryTerms", this.hasGlossaryTerms() ? this.glossaryTerms() : null).add("Id", this.id()).add("LastDeployment", this.lastDeployment()).add("Name", this.name() == null ? null : "*** Sensitive Data Redacted ***").add("ProjectId", this.projectId()).add("Provider", this.provider()).add("ProvisionedResources", this.hasProvisionedResources() ? this.provisionedResources() : null).add("ProvisioningProperties", this.provisioningProperties()).add("Status", this.statusAsString()).add("UpdatedAt", this.updatedAt()).add("UserParameters", this.hasUserParameters() ? this.userParameters() : null).build();
    }

    @Override
    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "awsAccountId": {
                return Optional.ofNullable(clazz.cast(this.awsAccountId()));
            }
            case "awsAccountRegion": {
                return Optional.ofNullable(clazz.cast(this.awsAccountRegion()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "createdBy": {
                return Optional.ofNullable(clazz.cast(this.createdBy()));
            }
            case "deploymentProperties": {
                return Optional.ofNullable(clazz.cast(this.deploymentProperties()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "domainId": {
                return Optional.ofNullable(clazz.cast(this.domainId()));
            }
            case "environmentActions": {
                return Optional.ofNullable(clazz.cast(this.environmentActions()));
            }
            case "environmentBlueprintId": {
                return Optional.ofNullable(clazz.cast(this.environmentBlueprintId()));
            }
            case "environmentConfigurationId": {
                return Optional.ofNullable(clazz.cast(this.environmentConfigurationId()));
            }
            case "environmentProfileId": {
                return Optional.ofNullable(clazz.cast(this.environmentProfileId()));
            }
            case "glossaryTerms": {
                return Optional.ofNullable(clazz.cast(this.glossaryTerms()));
            }
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "lastDeployment": {
                return Optional.ofNullable(clazz.cast(this.lastDeployment()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "projectId": {
                return Optional.ofNullable(clazz.cast(this.projectId()));
            }
            case "provider": {
                return Optional.ofNullable(clazz.cast(this.provider()));
            }
            case "provisionedResources": {
                return Optional.ofNullable(clazz.cast(this.provisionedResources()));
            }
            case "provisioningProperties": {
                return Optional.ofNullable(clazz.cast(this.provisioningProperties()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "updatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
            case "userParameters": {
                return Optional.ofNullable(clazz.cast(this.userParameters()));
            }
        }
        return Optional.empty();
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<Object>> map = new HashMap<String, SdkField<Object>>();
        map.put("awsAccountId", AWS_ACCOUNT_ID_FIELD);
        map.put("awsAccountRegion", AWS_ACCOUNT_REGION_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("createdBy", CREATED_BY_FIELD);
        map.put("deploymentProperties", DEPLOYMENT_PROPERTIES_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("domainId", DOMAIN_ID_FIELD);
        map.put("environmentActions", ENVIRONMENT_ACTIONS_FIELD);
        map.put("environmentBlueprintId", ENVIRONMENT_BLUEPRINT_ID_FIELD);
        map.put("environmentConfigurationId", ENVIRONMENT_CONFIGURATION_ID_FIELD);
        map.put("environmentProfileId", ENVIRONMENT_PROFILE_ID_FIELD);
        map.put("glossaryTerms", GLOSSARY_TERMS_FIELD);
        map.put("id", ID_FIELD);
        map.put("lastDeployment", LAST_DEPLOYMENT_FIELD);
        map.put("name", NAME_FIELD);
        map.put("projectId", PROJECT_ID_FIELD);
        map.put("provider", PROVIDER_FIELD);
        map.put("provisionedResources", PROVISIONED_RESOURCES_FIELD);
        map.put("provisioningProperties", PROVISIONING_PROPERTIES_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("updatedAt", UPDATED_AT_FIELD);
        map.put("userParameters", USER_PARAMETERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetEnvironmentResponse, T> g) {
        return obj -> g.apply((GetEnvironmentResponse)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DataZoneResponse.BuilderImpl
    implements Builder {
        private String awsAccountId;
        private String awsAccountRegion;
        private Instant createdAt;
        private String createdBy;
        private DeploymentProperties deploymentProperties;
        private String description;
        private String domainId;
        private List<ConfigurableEnvironmentAction> environmentActions = DefaultSdkAutoConstructList.getInstance();
        private String environmentBlueprintId;
        private String environmentConfigurationId;
        private String environmentProfileId;
        private List<String> glossaryTerms = DefaultSdkAutoConstructList.getInstance();
        private String id;
        private Deployment lastDeployment;
        private String name;
        private String projectId;
        private String provider;
        private List<Resource> provisionedResources = DefaultSdkAutoConstructList.getInstance();
        private ProvisioningProperties provisioningProperties;
        private String status;
        private Instant updatedAt;
        private List<CustomParameter> userParameters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetEnvironmentResponse model) {
            super(model);
            this.awsAccountId(model.awsAccountId);
            this.awsAccountRegion(model.awsAccountRegion);
            this.createdAt(model.createdAt);
            this.createdBy(model.createdBy);
            this.deploymentProperties(model.deploymentProperties);
            this.description(model.description);
            this.domainId(model.domainId);
            this.environmentActions(model.environmentActions);
            this.environmentBlueprintId(model.environmentBlueprintId);
            this.environmentConfigurationId(model.environmentConfigurationId);
            this.environmentProfileId(model.environmentProfileId);
            this.glossaryTerms(model.glossaryTerms);
            this.id(model.id);
            this.lastDeployment(model.lastDeployment);
            this.name(model.name);
            this.projectId(model.projectId);
            this.provider(model.provider);
            this.provisionedResources(model.provisionedResources);
            this.provisioningProperties(model.provisioningProperties);
            this.status(model.status);
            this.updatedAt(model.updatedAt);
            this.userParameters(model.userParameters);
        }

        public final String getAwsAccountId() {
            return this.awsAccountId;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final String getAwsAccountRegion() {
            return this.awsAccountRegion;
        }

        public final void setAwsAccountRegion(String awsAccountRegion) {
            this.awsAccountRegion = awsAccountRegion;
        }

        @Override
        public final Builder awsAccountRegion(String awsAccountRegion) {
            this.awsAccountRegion = awsAccountRegion;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getCreatedBy() {
            return this.createdBy;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final DeploymentProperties.Builder getDeploymentProperties() {
            return this.deploymentProperties != null ? this.deploymentProperties.toBuilder() : null;
        }

        public final void setDeploymentProperties(DeploymentProperties.BuilderImpl deploymentProperties) {
            this.deploymentProperties = deploymentProperties != null ? deploymentProperties.build() : null;
        }

        @Override
        public final Builder deploymentProperties(DeploymentProperties deploymentProperties) {
            this.deploymentProperties = deploymentProperties;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDomainId() {
            return this.domainId;
        }

        public final void setDomainId(String domainId) {
            this.domainId = domainId;
        }

        @Override
        public final Builder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public final List<ConfigurableEnvironmentAction.Builder> getEnvironmentActions() {
            List<ConfigurableEnvironmentAction.Builder> result = EnvironmentActionListCopier.copyToBuilder(this.environmentActions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEnvironmentActions(Collection<ConfigurableEnvironmentAction.BuilderImpl> environmentActions) {
            this.environmentActions = EnvironmentActionListCopier.copyFromBuilder(environmentActions);
        }

        @Override
        public final Builder environmentActions(Collection<ConfigurableEnvironmentAction> environmentActions) {
            this.environmentActions = EnvironmentActionListCopier.copy(environmentActions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder environmentActions(ConfigurableEnvironmentAction ... environmentActions) {
            this.environmentActions(Arrays.asList(environmentActions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder environmentActions(Consumer<ConfigurableEnvironmentAction.Builder> ... environmentActions) {
            this.environmentActions(Stream.of(environmentActions).map(c -> (ConfigurableEnvironmentAction)((ConfigurableEnvironmentAction.Builder)ConfigurableEnvironmentAction.builder().applyMutation(c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getEnvironmentBlueprintId() {
            return this.environmentBlueprintId;
        }

        public final void setEnvironmentBlueprintId(String environmentBlueprintId) {
            this.environmentBlueprintId = environmentBlueprintId;
        }

        @Override
        public final Builder environmentBlueprintId(String environmentBlueprintId) {
            this.environmentBlueprintId = environmentBlueprintId;
            return this;
        }

        public final String getEnvironmentConfigurationId() {
            return this.environmentConfigurationId;
        }

        public final void setEnvironmentConfigurationId(String environmentConfigurationId) {
            this.environmentConfigurationId = environmentConfigurationId;
        }

        @Override
        public final Builder environmentConfigurationId(String environmentConfigurationId) {
            this.environmentConfigurationId = environmentConfigurationId;
            return this;
        }

        public final String getEnvironmentProfileId() {
            return this.environmentProfileId;
        }

        public final void setEnvironmentProfileId(String environmentProfileId) {
            this.environmentProfileId = environmentProfileId;
        }

        @Override
        public final Builder environmentProfileId(String environmentProfileId) {
            this.environmentProfileId = environmentProfileId;
            return this;
        }

        public final Collection<String> getGlossaryTerms() {
            if (this.glossaryTerms instanceof SdkAutoConstructList) {
                return null;
            }
            return this.glossaryTerms;
        }

        public final void setGlossaryTerms(Collection<String> glossaryTerms) {
            this.glossaryTerms = GlossaryTermsCopier.copy(glossaryTerms);
        }

        @Override
        public final Builder glossaryTerms(Collection<String> glossaryTerms) {
            this.glossaryTerms = GlossaryTermsCopier.copy(glossaryTerms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder glossaryTerms(String ... glossaryTerms) {
            this.glossaryTerms(Arrays.asList(glossaryTerms));
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final Deployment.Builder getLastDeployment() {
            return this.lastDeployment != null ? this.lastDeployment.toBuilder() : null;
        }

        public final void setLastDeployment(Deployment.BuilderImpl lastDeployment) {
            this.lastDeployment = lastDeployment != null ? lastDeployment.build() : null;
        }

        @Override
        public final Builder lastDeployment(Deployment lastDeployment) {
            this.lastDeployment = lastDeployment;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getProjectId() {
            return this.projectId;
        }

        public final void setProjectId(String projectId) {
            this.projectId = projectId;
        }

        @Override
        public final Builder projectId(String projectId) {
            this.projectId = projectId;
            return this;
        }

        public final String getProvider() {
            return this.provider;
        }

        public final void setProvider(String provider) {
            this.provider = provider;
        }

        @Override
        public final Builder provider(String provider) {
            this.provider = provider;
            return this;
        }

        public final List<Resource.Builder> getProvisionedResources() {
            List<Resource.Builder> result = ResourceListCopier.copyToBuilder(this.provisionedResources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProvisionedResources(Collection<Resource.BuilderImpl> provisionedResources) {
            this.provisionedResources = ResourceListCopier.copyFromBuilder(provisionedResources);
        }

        @Override
        public final Builder provisionedResources(Collection<Resource> provisionedResources) {
            this.provisionedResources = ResourceListCopier.copy(provisionedResources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder provisionedResources(Resource ... provisionedResources) {
            this.provisionedResources(Arrays.asList(provisionedResources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder provisionedResources(Consumer<Resource.Builder> ... provisionedResources) {
            this.provisionedResources(Stream.of(provisionedResources).map(c -> (Resource)((Resource.Builder)Resource.builder().applyMutation(c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final ProvisioningProperties.Builder getProvisioningProperties() {
            return this.provisioningProperties != null ? this.provisioningProperties.toBuilder() : null;
        }

        public final void setProvisioningProperties(ProvisioningProperties.BuilderImpl provisioningProperties) {
            this.provisioningProperties = provisioningProperties != null ? provisioningProperties.build() : null;
        }

        @Override
        public final Builder provisioningProperties(ProvisioningProperties provisioningProperties) {
            this.provisioningProperties = provisioningProperties;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(EnvironmentStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final List<CustomParameter.Builder> getUserParameters() {
            List<CustomParameter.Builder> result = CustomParameterListCopier.copyToBuilder(this.userParameters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUserParameters(Collection<CustomParameter.BuilderImpl> userParameters) {
            this.userParameters = CustomParameterListCopier.copyFromBuilder(userParameters);
        }

        @Override
        public final Builder userParameters(Collection<CustomParameter> userParameters) {
            this.userParameters = CustomParameterListCopier.copy(userParameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userParameters(CustomParameter ... userParameters) {
            this.userParameters(Arrays.asList(userParameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userParameters(Consumer<CustomParameter.Builder> ... userParameters) {
            this.userParameters(Stream.of(userParameters).map(c -> (CustomParameter)((CustomParameter.Builder)CustomParameter.builder().applyMutation(c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetEnvironmentResponse build() {
            return new GetEnvironmentResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends DataZoneResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetEnvironmentResponse> {
        public Builder awsAccountId(String var1);

        public Builder awsAccountRegion(String var1);

        public Builder createdAt(Instant var1);

        public Builder createdBy(String var1);

        public Builder deploymentProperties(DeploymentProperties var1);

        default public Builder deploymentProperties(Consumer<DeploymentProperties.Builder> deploymentProperties) {
            return this.deploymentProperties((DeploymentProperties)DeploymentProperties.builder().applyMutation(deploymentProperties).build());
        }

        public Builder description(String var1);

        public Builder domainId(String var1);

        public Builder environmentActions(Collection<ConfigurableEnvironmentAction> var1);

        public Builder environmentActions(ConfigurableEnvironmentAction ... var1);

        public Builder environmentActions(Consumer<ConfigurableEnvironmentAction.Builder> ... var1);

        public Builder environmentBlueprintId(String var1);

        public Builder environmentConfigurationId(String var1);

        public Builder environmentProfileId(String var1);

        public Builder glossaryTerms(Collection<String> var1);

        public Builder glossaryTerms(String ... var1);

        public Builder id(String var1);

        public Builder lastDeployment(Deployment var1);

        default public Builder lastDeployment(Consumer<Deployment.Builder> lastDeployment) {
            return this.lastDeployment((Deployment)Deployment.builder().applyMutation(lastDeployment).build());
        }

        public Builder name(String var1);

        public Builder projectId(String var1);

        public Builder provider(String var1);

        public Builder provisionedResources(Collection<Resource> var1);

        public Builder provisionedResources(Resource ... var1);

        public Builder provisionedResources(Consumer<Resource.Builder> ... var1);

        public Builder provisioningProperties(ProvisioningProperties var1);

        default public Builder provisioningProperties(Consumer<ProvisioningProperties.Builder> provisioningProperties) {
            return this.provisioningProperties((ProvisioningProperties)ProvisioningProperties.builder().applyMutation(provisioningProperties).build());
        }

        public Builder status(String var1);

        public Builder status(EnvironmentStatus var1);

        public Builder updatedAt(Instant var1);

        public Builder userParameters(Collection<CustomParameter> var1);

        public Builder userParameters(CustomParameter ... var1);

        public Builder userParameters(Consumer<CustomParameter.Builder> ... var1);
    }
}

