/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.datazone.model.FailedQueryProcessingErrorMessagesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LineageSqlQueryRunDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LineageSqlQueryRunDetails> {
    private static final SdkField<List<String>> ERROR_MESSAGES_FIELD = SdkField.builder(MarshallingType.LIST).memberName("errorMessages").getter(LineageSqlQueryRunDetails.getter(LineageSqlQueryRunDetails::errorMessages)).setter(LineageSqlQueryRunDetails.setter(Builder::errorMessages)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorMessages").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder(MarshallingType.STRING).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()).build()).build()).build();
    private static final SdkField<Integer> NUM_QUERIES_FAILED_FIELD = SdkField.builder(MarshallingType.INTEGER).memberName("numQueriesFailed").getter(LineageSqlQueryRunDetails.getter(LineageSqlQueryRunDetails::numQueriesFailed)).setter(LineageSqlQueryRunDetails.setter(Builder::numQueriesFailed)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numQueriesFailed").build()).build();
    private static final SdkField<Instant> QUERY_END_TIME_FIELD = SdkField.builder(MarshallingType.INSTANT).memberName("queryEndTime").getter(LineageSqlQueryRunDetails.getter(LineageSqlQueryRunDetails::queryEndTime)).setter(LineageSqlQueryRunDetails.setter(Builder::queryEndTime)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queryEndTime").build()).build();
    private static final SdkField<Instant> QUERY_START_TIME_FIELD = SdkField.builder(MarshallingType.INSTANT).memberName("queryStartTime").getter(LineageSqlQueryRunDetails.getter(LineageSqlQueryRunDetails::queryStartTime)).setter(LineageSqlQueryRunDetails.setter(Builder::queryStartTime)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queryStartTime").build()).build();
    private static final SdkField<Integer> TOTAL_QUERIES_PROCESSED_FIELD = SdkField.builder(MarshallingType.INTEGER).memberName("totalQueriesProcessed").getter(LineageSqlQueryRunDetails.getter(LineageSqlQueryRunDetails::totalQueriesProcessed)).setter(LineageSqlQueryRunDetails.setter(Builder::totalQueriesProcessed)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalQueriesProcessed").build()).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ERROR_MESSAGES_FIELD, NUM_QUERIES_FAILED_FIELD, QUERY_END_TIME_FIELD, QUERY_START_TIME_FIELD, TOTAL_QUERIES_PROCESSED_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = LineageSqlQueryRunDetails.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> errorMessages;
    private final Integer numQueriesFailed;
    private final Instant queryEndTime;
    private final Instant queryStartTime;
    private final Integer totalQueriesProcessed;

    private LineageSqlQueryRunDetails(BuilderImpl builder) {
        this.errorMessages = builder.errorMessages;
        this.numQueriesFailed = builder.numQueriesFailed;
        this.queryEndTime = builder.queryEndTime;
        this.queryStartTime = builder.queryStartTime;
        this.totalQueriesProcessed = builder.totalQueriesProcessed;
    }

    public final boolean hasErrorMessages() {
        return this.errorMessages != null && !(this.errorMessages instanceof SdkAutoConstructList);
    }

    public final List<String> errorMessages() {
        return this.errorMessages;
    }

    public final Integer numQueriesFailed() {
        return this.numQueriesFailed;
    }

    public final Instant queryEndTime() {
        return this.queryEndTime;
    }

    public final Instant queryStartTime() {
        return this.queryStartTime;
    }

    public final Integer totalQueriesProcessed() {
        return this.totalQueriesProcessed;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasErrorMessages() ? this.errorMessages() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.numQueriesFailed());
        hashCode = 31 * hashCode + Objects.hashCode(this.queryEndTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.queryStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalQueriesProcessed());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LineageSqlQueryRunDetails)) {
            return false;
        }
        LineageSqlQueryRunDetails other = (LineageSqlQueryRunDetails)obj;
        return this.hasErrorMessages() == other.hasErrorMessages() && Objects.equals(this.errorMessages(), other.errorMessages()) && Objects.equals(this.numQueriesFailed(), other.numQueriesFailed()) && Objects.equals(this.queryEndTime(), other.queryEndTime()) && Objects.equals(this.queryStartTime(), other.queryStartTime()) && Objects.equals(this.totalQueriesProcessed(), other.totalQueriesProcessed());
    }

    public final String toString() {
        return ToString.builder("LineageSqlQueryRunDetails").add("ErrorMessages", this.hasErrorMessages() ? this.errorMessages() : null).add("NumQueriesFailed", this.numQueriesFailed()).add("QueryEndTime", this.queryEndTime()).add("QueryStartTime", this.queryStartTime()).add("TotalQueriesProcessed", this.totalQueriesProcessed()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "errorMessages": {
                return Optional.ofNullable(clazz.cast(this.errorMessages()));
            }
            case "numQueriesFailed": {
                return Optional.ofNullable(clazz.cast(this.numQueriesFailed()));
            }
            case "queryEndTime": {
                return Optional.ofNullable(clazz.cast(this.queryEndTime()));
            }
            case "queryStartTime": {
                return Optional.ofNullable(clazz.cast(this.queryStartTime()));
            }
            case "totalQueriesProcessed": {
                return Optional.ofNullable(clazz.cast(this.totalQueriesProcessed()));
            }
        }
        return Optional.empty();
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<Object>> map = new HashMap<String, SdkField<Object>>();
        map.put("errorMessages", ERROR_MESSAGES_FIELD);
        map.put("numQueriesFailed", NUM_QUERIES_FAILED_FIELD);
        map.put("queryEndTime", QUERY_END_TIME_FIELD);
        map.put("queryStartTime", QUERY_START_TIME_FIELD);
        map.put("totalQueriesProcessed", TOTAL_QUERIES_PROCESSED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LineageSqlQueryRunDetails, T> g) {
        return obj -> g.apply((LineageSqlQueryRunDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> errorMessages = DefaultSdkAutoConstructList.getInstance();
        private Integer numQueriesFailed;
        private Instant queryEndTime;
        private Instant queryStartTime;
        private Integer totalQueriesProcessed;

        private BuilderImpl() {
        }

        private BuilderImpl(LineageSqlQueryRunDetails model) {
            this.errorMessages(model.errorMessages);
            this.numQueriesFailed(model.numQueriesFailed);
            this.queryEndTime(model.queryEndTime);
            this.queryStartTime(model.queryStartTime);
            this.totalQueriesProcessed(model.totalQueriesProcessed);
        }

        public final Collection<String> getErrorMessages() {
            if (this.errorMessages instanceof SdkAutoConstructList) {
                return null;
            }
            return this.errorMessages;
        }

        public final void setErrorMessages(Collection<String> errorMessages) {
            this.errorMessages = FailedQueryProcessingErrorMessagesCopier.copy(errorMessages);
        }

        @Override
        public final Builder errorMessages(Collection<String> errorMessages) {
            this.errorMessages = FailedQueryProcessingErrorMessagesCopier.copy(errorMessages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errorMessages(String ... errorMessages) {
            this.errorMessages(Arrays.asList(errorMessages));
            return this;
        }

        public final Integer getNumQueriesFailed() {
            return this.numQueriesFailed;
        }

        public final void setNumQueriesFailed(Integer numQueriesFailed) {
            this.numQueriesFailed = numQueriesFailed;
        }

        @Override
        public final Builder numQueriesFailed(Integer numQueriesFailed) {
            this.numQueriesFailed = numQueriesFailed;
            return this;
        }

        public final Instant getQueryEndTime() {
            return this.queryEndTime;
        }

        public final void setQueryEndTime(Instant queryEndTime) {
            this.queryEndTime = queryEndTime;
        }

        @Override
        public final Builder queryEndTime(Instant queryEndTime) {
            this.queryEndTime = queryEndTime;
            return this;
        }

        public final Instant getQueryStartTime() {
            return this.queryStartTime;
        }

        public final void setQueryStartTime(Instant queryStartTime) {
            this.queryStartTime = queryStartTime;
        }

        @Override
        public final Builder queryStartTime(Instant queryStartTime) {
            this.queryStartTime = queryStartTime;
            return this;
        }

        public final Integer getTotalQueriesProcessed() {
            return this.totalQueriesProcessed;
        }

        public final void setTotalQueriesProcessed(Integer totalQueriesProcessed) {
            this.totalQueriesProcessed = totalQueriesProcessed;
        }

        @Override
        public final Builder totalQueriesProcessed(Integer totalQueriesProcessed) {
            this.totalQueriesProcessed = totalQueriesProcessed;
            return this;
        }

        @Override
        public LineageSqlQueryRunDetails build() {
            return new LineageSqlQueryRunDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LineageSqlQueryRunDetails> {
        public Builder errorMessages(Collection<String> var1);

        public Builder errorMessages(String ... var1);

        public Builder numQueriesFailed(Integer var1);

        public Builder queryEndTime(Instant var1);

        public Builder queryStartTime(Instant var1);

        public Builder totalQueriesProcessed(Integer var1);
    }
}

