/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.services.datazone.model.DataZoneRequest;
import software.amazon.awssdk.services.datazone.model.EdgeDirection;
import software.amazon.awssdk.services.datazone.model.SortOrder;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListLineageNodeHistoryRequest
extends DataZoneRequest
implements ToCopyableBuilder<Builder, ListLineageNodeHistoryRequest> {
    private static final SdkField<String> DIRECTION_FIELD = SdkField.builder(MarshallingType.STRING).memberName("direction").getter(ListLineageNodeHistoryRequest.getter(ListLineageNodeHistoryRequest::directionAsString)).setter(ListLineageNodeHistoryRequest.setter(Builder::direction)).traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("direction").build()).build();
    private static final SdkField<String> DOMAIN_IDENTIFIER_FIELD = SdkField.builder(MarshallingType.STRING).memberName("domainIdentifier").getter(ListLineageNodeHistoryRequest.getter(ListLineageNodeHistoryRequest::domainIdentifier)).setter(ListLineageNodeHistoryRequest.setter(Builder::domainIdentifier)).traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("domainIdentifier").build()).build();
    private static final SdkField<Instant> EVENT_TIMESTAMP_GTE_FIELD = SdkField.builder(MarshallingType.INSTANT).memberName("eventTimestampGTE").getter(ListLineageNodeHistoryRequest.getter(ListLineageNodeHistoryRequest::eventTimestampGTE)).setter(ListLineageNodeHistoryRequest.setter(Builder::eventTimestampGTE)).traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("timestampGTE").build()).build();
    private static final SdkField<Instant> EVENT_TIMESTAMP_LTE_FIELD = SdkField.builder(MarshallingType.INSTANT).memberName("eventTimestampLTE").getter(ListLineageNodeHistoryRequest.getter(ListLineageNodeHistoryRequest::eventTimestampLTE)).setter(ListLineageNodeHistoryRequest.setter(Builder::eventTimestampLTE)).traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("timestampLTE").build()).build();
    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.builder(MarshallingType.STRING).memberName("identifier").getter(ListLineageNodeHistoryRequest.getter(ListLineageNodeHistoryRequest::identifier)).setter(ListLineageNodeHistoryRequest.setter(Builder::identifier)).traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("identifier").build()).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder(MarshallingType.INTEGER).memberName("maxResults").getter(ListLineageNodeHistoryRequest.getter(ListLineageNodeHistoryRequest::maxResults)).setter(ListLineageNodeHistoryRequest.setter(Builder::maxResults)).traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder(MarshallingType.STRING).memberName("nextToken").getter(ListLineageNodeHistoryRequest.getter(ListLineageNodeHistoryRequest::nextToken)).setter(ListLineageNodeHistoryRequest.setter(Builder::nextToken)).traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()).build();
    private static final SdkField<String> SORT_ORDER_FIELD = SdkField.builder(MarshallingType.STRING).memberName("sortOrder").getter(ListLineageNodeHistoryRequest.getter(ListLineageNodeHistoryRequest::sortOrderAsString)).setter(ListLineageNodeHistoryRequest.setter(Builder::sortOrder)).traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("sortOrder").build()).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIRECTION_FIELD, DOMAIN_IDENTIFIER_FIELD, EVENT_TIMESTAMP_GTE_FIELD, EVENT_TIMESTAMP_LTE_FIELD, IDENTIFIER_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, SORT_ORDER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListLineageNodeHistoryRequest.memberNameToFieldInitializer();
    private final String direction;
    private final String domainIdentifier;
    private final Instant eventTimestampGTE;
    private final Instant eventTimestampLTE;
    private final String identifier;
    private final Integer maxResults;
    private final String nextToken;
    private final String sortOrder;

    private ListLineageNodeHistoryRequest(BuilderImpl builder) {
        super(builder);
        this.direction = builder.direction;
        this.domainIdentifier = builder.domainIdentifier;
        this.eventTimestampGTE = builder.eventTimestampGTE;
        this.eventTimestampLTE = builder.eventTimestampLTE;
        this.identifier = builder.identifier;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.sortOrder = builder.sortOrder;
    }

    public final EdgeDirection direction() {
        return EdgeDirection.fromValue(this.direction);
    }

    public final String directionAsString() {
        return this.direction;
    }

    public final String domainIdentifier() {
        return this.domainIdentifier;
    }

    public final Instant eventTimestampGTE() {
        return this.eventTimestampGTE;
    }

    public final Instant eventTimestampLTE() {
        return this.eventTimestampLTE;
    }

    public final String identifier() {
        return this.identifier;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final SortOrder sortOrder() {
        return SortOrder.fromValue(this.sortOrder);
    }

    public final String sortOrderAsString() {
        return this.sortOrder;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.directionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventTimestampGTE());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventTimestampLTE());
        hashCode = 31 * hashCode + Objects.hashCode(this.identifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.sortOrderAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListLineageNodeHistoryRequest)) {
            return false;
        }
        ListLineageNodeHistoryRequest other = (ListLineageNodeHistoryRequest)obj;
        return Objects.equals(this.directionAsString(), other.directionAsString()) && Objects.equals(this.domainIdentifier(), other.domainIdentifier()) && Objects.equals(this.eventTimestampGTE(), other.eventTimestampGTE()) && Objects.equals(this.eventTimestampLTE(), other.eventTimestampLTE()) && Objects.equals(this.identifier(), other.identifier()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.sortOrderAsString(), other.sortOrderAsString());
    }

    public final String toString() {
        return ToString.builder("ListLineageNodeHistoryRequest").add("Direction", this.directionAsString()).add("DomainIdentifier", this.domainIdentifier()).add("EventTimestampGTE", this.eventTimestampGTE()).add("EventTimestampLTE", this.eventTimestampLTE()).add("Identifier", this.identifier()).add("MaxResults", this.maxResults()).add("NextToken", this.nextToken()).add("SortOrder", this.sortOrderAsString()).build();
    }

    @Override
    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "direction": {
                return Optional.ofNullable(clazz.cast(this.directionAsString()));
            }
            case "domainIdentifier": {
                return Optional.ofNullable(clazz.cast(this.domainIdentifier()));
            }
            case "eventTimestampGTE": {
                return Optional.ofNullable(clazz.cast(this.eventTimestampGTE()));
            }
            case "eventTimestampLTE": {
                return Optional.ofNullable(clazz.cast(this.eventTimestampLTE()));
            }
            case "identifier": {
                return Optional.ofNullable(clazz.cast(this.identifier()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "sortOrder": {
                return Optional.ofNullable(clazz.cast(this.sortOrderAsString()));
            }
        }
        return Optional.empty();
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<Object>> map = new HashMap<String, SdkField<Object>>();
        map.put("direction", DIRECTION_FIELD);
        map.put("domainIdentifier", DOMAIN_IDENTIFIER_FIELD);
        map.put("timestampGTE", EVENT_TIMESTAMP_GTE_FIELD);
        map.put("timestampLTE", EVENT_TIMESTAMP_LTE_FIELD);
        map.put("identifier", IDENTIFIER_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("sortOrder", SORT_ORDER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListLineageNodeHistoryRequest, T> g) {
        return obj -> g.apply((ListLineageNodeHistoryRequest)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DataZoneRequest.BuilderImpl
    implements Builder {
        private String direction;
        private String domainIdentifier;
        private Instant eventTimestampGTE;
        private Instant eventTimestampLTE;
        private String identifier;
        private Integer maxResults;
        private String nextToken;
        private String sortOrder;

        private BuilderImpl() {
        }

        private BuilderImpl(ListLineageNodeHistoryRequest model) {
            super(model);
            this.direction(model.direction);
            this.domainIdentifier(model.domainIdentifier);
            this.eventTimestampGTE(model.eventTimestampGTE);
            this.eventTimestampLTE(model.eventTimestampLTE);
            this.identifier(model.identifier);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
            this.sortOrder(model.sortOrder);
        }

        public final String getDirection() {
            return this.direction;
        }

        public final void setDirection(String direction) {
            this.direction = direction;
        }

        @Override
        public final Builder direction(String direction) {
            this.direction = direction;
            return this;
        }

        @Override
        public final Builder direction(EdgeDirection direction) {
            this.direction(direction == null ? null : direction.toString());
            return this;
        }

        public final String getDomainIdentifier() {
            return this.domainIdentifier;
        }

        public final void setDomainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
        }

        @Override
        public final Builder domainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
            return this;
        }

        public final Instant getEventTimestampGTE() {
            return this.eventTimestampGTE;
        }

        public final void setEventTimestampGTE(Instant eventTimestampGTE) {
            this.eventTimestampGTE = eventTimestampGTE;
        }

        @Override
        public final Builder eventTimestampGTE(Instant eventTimestampGTE) {
            this.eventTimestampGTE = eventTimestampGTE;
            return this;
        }

        public final Instant getEventTimestampLTE() {
            return this.eventTimestampLTE;
        }

        public final void setEventTimestampLTE(Instant eventTimestampLTE) {
            this.eventTimestampLTE = eventTimestampLTE;
        }

        @Override
        public final Builder eventTimestampLTE(Instant eventTimestampLTE) {
            this.eventTimestampLTE = eventTimestampLTE;
            return this;
        }

        public final String getIdentifier() {
            return this.identifier;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        @Override
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getSortOrder() {
            return this.sortOrder;
        }

        public final void setSortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
        }

        @Override
        public final Builder sortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        @Override
        public final Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder(sortOrder == null ? null : sortOrder.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListLineageNodeHistoryRequest build() {
            return new ListLineageNodeHistoryRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends DataZoneRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListLineageNodeHistoryRequest> {
        public Builder direction(String var1);

        public Builder direction(EdgeDirection var1);

        public Builder domainIdentifier(String var1);

        public Builder eventTimestampGTE(Instant var1);

        public Builder eventTimestampLTE(Instant var1);

        public Builder identifier(String var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder sortOrder(String var1);

        public Builder sortOrder(SortOrder var1);

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

