/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.services.datazone.model.AwsLocation;
import software.amazon.awssdk.services.datazone.model.GlueConnection;
import software.amazon.awssdk.services.datazone.model.Protocol;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PhysicalEndpoint
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PhysicalEndpoint> {
    private static final SdkField<AwsLocation> AWS_LOCATION_FIELD = SdkField.builder(MarshallingType.SDK_POJO).memberName("awsLocation").getter(PhysicalEndpoint.getter(PhysicalEndpoint::awsLocation)).setter(PhysicalEndpoint.setter(Builder::awsLocation)).constructor(AwsLocation::builder).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsLocation").build()).build();
    private static final SdkField<Boolean> ENABLE_TRUSTED_IDENTITY_PROPAGATION_FIELD = SdkField.builder(MarshallingType.BOOLEAN).memberName("enableTrustedIdentityPropagation").getter(PhysicalEndpoint.getter(PhysicalEndpoint::enableTrustedIdentityPropagation)).setter(PhysicalEndpoint.setter(Builder::enableTrustedIdentityPropagation)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enableTrustedIdentityPropagation").build()).build();
    private static final SdkField<GlueConnection> GLUE_CONNECTION_FIELD = SdkField.builder(MarshallingType.SDK_POJO).memberName("glueConnection").getter(PhysicalEndpoint.getter(PhysicalEndpoint::glueConnection)).setter(PhysicalEndpoint.setter(Builder::glueConnection)).constructor(GlueConnection::builder).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("glueConnection").build()).build();
    private static final SdkField<String> GLUE_CONNECTION_NAME_FIELD = SdkField.builder(MarshallingType.STRING).memberName("glueConnectionName").getter(PhysicalEndpoint.getter(PhysicalEndpoint::glueConnectionName)).setter(PhysicalEndpoint.setter(Builder::glueConnectionName)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("glueConnectionName").build()).build();
    private static final SdkField<String> HOST_FIELD = SdkField.builder(MarshallingType.STRING).memberName("host").getter(PhysicalEndpoint.getter(PhysicalEndpoint::host)).setter(PhysicalEndpoint.setter(Builder::host)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("host").build()).build();
    private static final SdkField<Integer> PORT_FIELD = SdkField.builder(MarshallingType.INTEGER).memberName("port").getter(PhysicalEndpoint.getter(PhysicalEndpoint::port)).setter(PhysicalEndpoint.setter(Builder::port)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("port").build()).build();
    private static final SdkField<String> PROTOCOL_FIELD = SdkField.builder(MarshallingType.STRING).memberName("protocol").getter(PhysicalEndpoint.getter(PhysicalEndpoint::protocolAsString)).setter(PhysicalEndpoint.setter(Builder::protocol)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("protocol").build()).build();
    private static final SdkField<String> STAGE_FIELD = SdkField.builder(MarshallingType.STRING).memberName("stage").getter(PhysicalEndpoint.getter(PhysicalEndpoint::stage)).setter(PhysicalEndpoint.setter(Builder::stage)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stage").build()).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_LOCATION_FIELD, ENABLE_TRUSTED_IDENTITY_PROPAGATION_FIELD, GLUE_CONNECTION_FIELD, GLUE_CONNECTION_NAME_FIELD, HOST_FIELD, PORT_FIELD, PROTOCOL_FIELD, STAGE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PhysicalEndpoint.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final AwsLocation awsLocation;
    private final Boolean enableTrustedIdentityPropagation;
    private final GlueConnection glueConnection;
    private final String glueConnectionName;
    private final String host;
    private final Integer port;
    private final String protocol;
    private final String stage;

    private PhysicalEndpoint(BuilderImpl builder) {
        this.awsLocation = builder.awsLocation;
        this.enableTrustedIdentityPropagation = builder.enableTrustedIdentityPropagation;
        this.glueConnection = builder.glueConnection;
        this.glueConnectionName = builder.glueConnectionName;
        this.host = builder.host;
        this.port = builder.port;
        this.protocol = builder.protocol;
        this.stage = builder.stage;
    }

    public final AwsLocation awsLocation() {
        return this.awsLocation;
    }

    public final Boolean enableTrustedIdentityPropagation() {
        return this.enableTrustedIdentityPropagation;
    }

    public final GlueConnection glueConnection() {
        return this.glueConnection;
    }

    public final String glueConnectionName() {
        return this.glueConnectionName;
    }

    public final String host() {
        return this.host;
    }

    public final Integer port() {
        return this.port;
    }

    public final Protocol protocol() {
        return Protocol.fromValue(this.protocol);
    }

    public final String protocolAsString() {
        return this.protocol;
    }

    public final String stage() {
        return this.stage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.awsLocation());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableTrustedIdentityPropagation());
        hashCode = 31 * hashCode + Objects.hashCode(this.glueConnection());
        hashCode = 31 * hashCode + Objects.hashCode(this.glueConnectionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.host());
        hashCode = 31 * hashCode + Objects.hashCode(this.port());
        hashCode = 31 * hashCode + Objects.hashCode(this.protocolAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.stage());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PhysicalEndpoint)) {
            return false;
        }
        PhysicalEndpoint other = (PhysicalEndpoint)obj;
        return Objects.equals(this.awsLocation(), other.awsLocation()) && Objects.equals(this.enableTrustedIdentityPropagation(), other.enableTrustedIdentityPropagation()) && Objects.equals(this.glueConnection(), other.glueConnection()) && Objects.equals(this.glueConnectionName(), other.glueConnectionName()) && Objects.equals(this.host(), other.host()) && Objects.equals(this.port(), other.port()) && Objects.equals(this.protocolAsString(), other.protocolAsString()) && Objects.equals(this.stage(), other.stage());
    }

    public final String toString() {
        return ToString.builder("PhysicalEndpoint").add("AwsLocation", this.awsLocation()).add("EnableTrustedIdentityPropagation", this.enableTrustedIdentityPropagation()).add("GlueConnection", this.glueConnection()).add("GlueConnectionName", this.glueConnectionName()).add("Host", this.host()).add("Port", this.port()).add("Protocol", this.protocolAsString()).add("Stage", this.stage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "awsLocation": {
                return Optional.ofNullable(clazz.cast(this.awsLocation()));
            }
            case "enableTrustedIdentityPropagation": {
                return Optional.ofNullable(clazz.cast(this.enableTrustedIdentityPropagation()));
            }
            case "glueConnection": {
                return Optional.ofNullable(clazz.cast(this.glueConnection()));
            }
            case "glueConnectionName": {
                return Optional.ofNullable(clazz.cast(this.glueConnectionName()));
            }
            case "host": {
                return Optional.ofNullable(clazz.cast(this.host()));
            }
            case "port": {
                return Optional.ofNullable(clazz.cast(this.port()));
            }
            case "protocol": {
                return Optional.ofNullable(clazz.cast(this.protocolAsString()));
            }
            case "stage": {
                return Optional.ofNullable(clazz.cast(this.stage()));
            }
        }
        return Optional.empty();
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<Object>> map = new HashMap<String, SdkField<Object>>();
        map.put("awsLocation", AWS_LOCATION_FIELD);
        map.put("enableTrustedIdentityPropagation", ENABLE_TRUSTED_IDENTITY_PROPAGATION_FIELD);
        map.put("glueConnection", GLUE_CONNECTION_FIELD);
        map.put("glueConnectionName", GLUE_CONNECTION_NAME_FIELD);
        map.put("host", HOST_FIELD);
        map.put("port", PORT_FIELD);
        map.put("protocol", PROTOCOL_FIELD);
        map.put("stage", STAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PhysicalEndpoint, T> g) {
        return obj -> g.apply((PhysicalEndpoint)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private AwsLocation awsLocation;
        private Boolean enableTrustedIdentityPropagation;
        private GlueConnection glueConnection;
        private String glueConnectionName;
        private String host;
        private Integer port;
        private String protocol;
        private String stage;

        private BuilderImpl() {
        }

        private BuilderImpl(PhysicalEndpoint model) {
            this.awsLocation(model.awsLocation);
            this.enableTrustedIdentityPropagation(model.enableTrustedIdentityPropagation);
            this.glueConnection(model.glueConnection);
            this.glueConnectionName(model.glueConnectionName);
            this.host(model.host);
            this.port(model.port);
            this.protocol(model.protocol);
            this.stage(model.stage);
        }

        public final AwsLocation.Builder getAwsLocation() {
            return this.awsLocation != null ? this.awsLocation.toBuilder() : null;
        }

        public final void setAwsLocation(AwsLocation.BuilderImpl awsLocation) {
            this.awsLocation = awsLocation != null ? awsLocation.build() : null;
        }

        @Override
        public final Builder awsLocation(AwsLocation awsLocation) {
            this.awsLocation = awsLocation;
            return this;
        }

        public final Boolean getEnableTrustedIdentityPropagation() {
            return this.enableTrustedIdentityPropagation;
        }

        public final void setEnableTrustedIdentityPropagation(Boolean enableTrustedIdentityPropagation) {
            this.enableTrustedIdentityPropagation = enableTrustedIdentityPropagation;
        }

        @Override
        public final Builder enableTrustedIdentityPropagation(Boolean enableTrustedIdentityPropagation) {
            this.enableTrustedIdentityPropagation = enableTrustedIdentityPropagation;
            return this;
        }

        public final GlueConnection.Builder getGlueConnection() {
            return this.glueConnection != null ? this.glueConnection.toBuilder() : null;
        }

        public final void setGlueConnection(GlueConnection.BuilderImpl glueConnection) {
            this.glueConnection = glueConnection != null ? glueConnection.build() : null;
        }

        @Override
        public final Builder glueConnection(GlueConnection glueConnection) {
            this.glueConnection = glueConnection;
            return this;
        }

        public final String getGlueConnectionName() {
            return this.glueConnectionName;
        }

        public final void setGlueConnectionName(String glueConnectionName) {
            this.glueConnectionName = glueConnectionName;
        }

        @Override
        public final Builder glueConnectionName(String glueConnectionName) {
            this.glueConnectionName = glueConnectionName;
            return this;
        }

        public final String getHost() {
            return this.host;
        }

        public final void setHost(String host) {
            this.host = host;
        }

        @Override
        public final Builder host(String host) {
            this.host = host;
            return this;
        }

        public final Integer getPort() {
            return this.port;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final String getProtocol() {
            return this.protocol;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        @Override
        public final Builder protocol(Protocol protocol) {
            this.protocol(protocol == null ? null : protocol.toString());
            return this;
        }

        public final String getStage() {
            return this.stage;
        }

        public final void setStage(String stage) {
            this.stage = stage;
        }

        @Override
        public final Builder stage(String stage) {
            this.stage = stage;
            return this;
        }

        @Override
        public PhysicalEndpoint build() {
            return new PhysicalEndpoint(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PhysicalEndpoint> {
        public Builder awsLocation(AwsLocation var1);

        default public Builder awsLocation(Consumer<AwsLocation.Builder> awsLocation) {
            return this.awsLocation((AwsLocation)AwsLocation.builder().applyMutation(awsLocation).build());
        }

        public Builder enableTrustedIdentityPropagation(Boolean var1);

        public Builder glueConnection(GlueConnection var1);

        default public Builder glueConnection(Consumer<GlueConnection.Builder> glueConnection) {
            return this.glueConnection((GlueConnection)GlueConnection.builder().applyMutation(glueConnection).build());
        }

        public Builder glueConnectionName(String var1);

        public Builder host(String var1);

        public Builder port(Integer var1);

        public Builder protocol(String var1);

        public Builder protocol(Protocol var1);

        public Builder stage(String var1);
    }
}

