/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.services.datazone.model.ProjectDesignation;
import software.amazon.awssdk.services.datazone.model.ProjectGrantFilter;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ProjectPolicyGrantPrincipal
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ProjectPolicyGrantPrincipal> {
    private static final SdkField<String> PROJECT_DESIGNATION_FIELD = SdkField.builder(MarshallingType.STRING).memberName("projectDesignation").getter(ProjectPolicyGrantPrincipal.getter(ProjectPolicyGrantPrincipal::projectDesignationAsString)).setter(ProjectPolicyGrantPrincipal.setter(Builder::projectDesignation)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("projectDesignation").build()).build();
    private static final SdkField<ProjectGrantFilter> PROJECT_GRANT_FILTER_FIELD = SdkField.builder(MarshallingType.SDK_POJO).memberName("projectGrantFilter").getter(ProjectPolicyGrantPrincipal.getter(ProjectPolicyGrantPrincipal::projectGrantFilter)).setter(ProjectPolicyGrantPrincipal.setter(Builder::projectGrantFilter)).constructor(ProjectGrantFilter::builder).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("projectGrantFilter").build()).build();
    private static final SdkField<String> PROJECT_IDENTIFIER_FIELD = SdkField.builder(MarshallingType.STRING).memberName("projectIdentifier").getter(ProjectPolicyGrantPrincipal.getter(ProjectPolicyGrantPrincipal::projectIdentifier)).setter(ProjectPolicyGrantPrincipal.setter(Builder::projectIdentifier)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("projectIdentifier").build()).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROJECT_DESIGNATION_FIELD, PROJECT_GRANT_FILTER_FIELD, PROJECT_IDENTIFIER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ProjectPolicyGrantPrincipal.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String projectDesignation;
    private final ProjectGrantFilter projectGrantFilter;
    private final String projectIdentifier;

    private ProjectPolicyGrantPrincipal(BuilderImpl builder) {
        this.projectDesignation = builder.projectDesignation;
        this.projectGrantFilter = builder.projectGrantFilter;
        this.projectIdentifier = builder.projectIdentifier;
    }

    public final ProjectDesignation projectDesignation() {
        return ProjectDesignation.fromValue(this.projectDesignation);
    }

    public final String projectDesignationAsString() {
        return this.projectDesignation;
    }

    public final ProjectGrantFilter projectGrantFilter() {
        return this.projectGrantFilter;
    }

    public final String projectIdentifier() {
        return this.projectIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.projectDesignationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.projectGrantFilter());
        hashCode = 31 * hashCode + Objects.hashCode(this.projectIdentifier());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProjectPolicyGrantPrincipal)) {
            return false;
        }
        ProjectPolicyGrantPrincipal other = (ProjectPolicyGrantPrincipal)obj;
        return Objects.equals(this.projectDesignationAsString(), other.projectDesignationAsString()) && Objects.equals(this.projectGrantFilter(), other.projectGrantFilter()) && Objects.equals(this.projectIdentifier(), other.projectIdentifier());
    }

    public final String toString() {
        return ToString.builder("ProjectPolicyGrantPrincipal").add("ProjectDesignation", this.projectDesignationAsString()).add("ProjectGrantFilter", this.projectGrantFilter()).add("ProjectIdentifier", this.projectIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "projectDesignation": {
                return Optional.ofNullable(clazz.cast(this.projectDesignationAsString()));
            }
            case "projectGrantFilter": {
                return Optional.ofNullable(clazz.cast(this.projectGrantFilter()));
            }
            case "projectIdentifier": {
                return Optional.ofNullable(clazz.cast(this.projectIdentifier()));
            }
        }
        return Optional.empty();
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<Object>> map = new HashMap<String, SdkField<Object>>();
        map.put("projectDesignation", PROJECT_DESIGNATION_FIELD);
        map.put("projectGrantFilter", PROJECT_GRANT_FILTER_FIELD);
        map.put("projectIdentifier", PROJECT_IDENTIFIER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ProjectPolicyGrantPrincipal, T> g) {
        return obj -> g.apply((ProjectPolicyGrantPrincipal)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String projectDesignation;
        private ProjectGrantFilter projectGrantFilter;
        private String projectIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(ProjectPolicyGrantPrincipal model) {
            this.projectDesignation(model.projectDesignation);
            this.projectGrantFilter(model.projectGrantFilter);
            this.projectIdentifier(model.projectIdentifier);
        }

        public final String getProjectDesignation() {
            return this.projectDesignation;
        }

        public final void setProjectDesignation(String projectDesignation) {
            this.projectDesignation = projectDesignation;
        }

        @Override
        public final Builder projectDesignation(String projectDesignation) {
            this.projectDesignation = projectDesignation;
            return this;
        }

        @Override
        public final Builder projectDesignation(ProjectDesignation projectDesignation) {
            this.projectDesignation(projectDesignation == null ? null : projectDesignation.toString());
            return this;
        }

        public final ProjectGrantFilter.Builder getProjectGrantFilter() {
            return this.projectGrantFilter != null ? this.projectGrantFilter.toBuilder() : null;
        }

        public final void setProjectGrantFilter(ProjectGrantFilter.BuilderImpl projectGrantFilter) {
            this.projectGrantFilter = projectGrantFilter != null ? projectGrantFilter.build() : null;
        }

        @Override
        public final Builder projectGrantFilter(ProjectGrantFilter projectGrantFilter) {
            this.projectGrantFilter = projectGrantFilter;
            return this;
        }

        public final String getProjectIdentifier() {
            return this.projectIdentifier;
        }

        public final void setProjectIdentifier(String projectIdentifier) {
            this.projectIdentifier = projectIdentifier;
        }

        @Override
        public final Builder projectIdentifier(String projectIdentifier) {
            this.projectIdentifier = projectIdentifier;
            return this;
        }

        @Override
        public ProjectPolicyGrantPrincipal build() {
            return new ProjectPolicyGrantPrincipal(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ProjectPolicyGrantPrincipal> {
        public Builder projectDesignation(String var1);

        public Builder projectDesignation(ProjectDesignation var1);

        public Builder projectGrantFilter(ProjectGrantFilter var1);

        default public Builder projectGrantFilter(Consumer<ProjectGrantFilter.Builder> projectGrantFilter) {
            return this.projectGrantFilter((ProjectGrantFilter)ProjectGrantFilter.builder().applyMutation(projectGrantFilter).build());
        }

        public Builder projectIdentifier(String var1);
    }
}

