/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class S3PropertiesInput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, S3PropertiesInput> {
    private static final SdkField<String> S3_ACCESS_GRANT_LOCATION_ID_FIELD = SdkField.builder(MarshallingType.STRING).memberName("s3AccessGrantLocationId").getter(S3PropertiesInput.getter(S3PropertiesInput::s3AccessGrantLocationId)).setter(S3PropertiesInput.setter(Builder::s3AccessGrantLocationId)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3AccessGrantLocationId").build()).build();
    private static final SdkField<String> S3_URI_FIELD = SdkField.builder(MarshallingType.STRING).memberName("s3Uri").getter(S3PropertiesInput.getter(S3PropertiesInput::s3Uri)).setter(S3PropertiesInput.setter(Builder::s3Uri)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3Uri").build()).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_ACCESS_GRANT_LOCATION_ID_FIELD, S3_URI_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = S3PropertiesInput.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String s3AccessGrantLocationId;
    private final String s3Uri;

    private S3PropertiesInput(BuilderImpl builder) {
        this.s3AccessGrantLocationId = builder.s3AccessGrantLocationId;
        this.s3Uri = builder.s3Uri;
    }

    public final String s3AccessGrantLocationId() {
        return this.s3AccessGrantLocationId;
    }

    public final String s3Uri() {
        return this.s3Uri;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.s3AccessGrantLocationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Uri());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3PropertiesInput)) {
            return false;
        }
        S3PropertiesInput other = (S3PropertiesInput)obj;
        return Objects.equals(this.s3AccessGrantLocationId(), other.s3AccessGrantLocationId()) && Objects.equals(this.s3Uri(), other.s3Uri());
    }

    public final String toString() {
        return ToString.builder("S3PropertiesInput").add("S3AccessGrantLocationId", this.s3AccessGrantLocationId()).add("S3Uri", this.s3Uri()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "s3AccessGrantLocationId": {
                return Optional.ofNullable(clazz.cast(this.s3AccessGrantLocationId()));
            }
            case "s3Uri": {
                return Optional.ofNullable(clazz.cast(this.s3Uri()));
            }
        }
        return Optional.empty();
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("s3AccessGrantLocationId", S3_ACCESS_GRANT_LOCATION_ID_FIELD);
        map.put("s3Uri", S3_URI_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<S3PropertiesInput, T> g) {
        return obj -> g.apply((S3PropertiesInput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String s3AccessGrantLocationId;
        private String s3Uri;

        private BuilderImpl() {
        }

        private BuilderImpl(S3PropertiesInput model) {
            this.s3AccessGrantLocationId(model.s3AccessGrantLocationId);
            this.s3Uri(model.s3Uri);
        }

        public final String getS3AccessGrantLocationId() {
            return this.s3AccessGrantLocationId;
        }

        public final void setS3AccessGrantLocationId(String s3AccessGrantLocationId) {
            this.s3AccessGrantLocationId = s3AccessGrantLocationId;
        }

        @Override
        public final Builder s3AccessGrantLocationId(String s3AccessGrantLocationId) {
            this.s3AccessGrantLocationId = s3AccessGrantLocationId;
            return this;
        }

        public final String getS3Uri() {
            return this.s3Uri;
        }

        public final void setS3Uri(String s3Uri) {
            this.s3Uri = s3Uri;
        }

        @Override
        public final Builder s3Uri(String s3Uri) {
            this.s3Uri = s3Uri;
            return this;
        }

        @Override
        public S3PropertiesInput build() {
            return new S3PropertiesInput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, S3PropertiesInput> {
        public Builder s3AccessGrantLocationId(String var1);

        public Builder s3Uri(String var1);
    }
}

