/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.datazone.model.SubscribedGroup;
import software.amazon.awssdk.services.datazone.model.SubscribedProject;
import software.amazon.awssdk.services.datazone.model.SubscribedUser;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SubscribedPrincipal
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SubscribedPrincipal> {
    private static final SdkField<SubscribedGroup> GROUP_FIELD = SdkField.builder(MarshallingType.SDK_POJO).memberName("group").getter(SubscribedPrincipal.getter(SubscribedPrincipal::group)).setter(SubscribedPrincipal.setter(Builder::group)).constructor(SubscribedGroup::builder).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("group").build()).build();
    private static final SdkField<SubscribedProject> PROJECT_FIELD = SdkField.builder(MarshallingType.SDK_POJO).memberName("project").getter(SubscribedPrincipal.getter(SubscribedPrincipal::project)).setter(SubscribedPrincipal.setter(Builder::project)).constructor(SubscribedProject::builder).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("project").build()).build();
    private static final SdkField<SubscribedUser> USER_FIELD = SdkField.builder(MarshallingType.SDK_POJO).memberName("user").getter(SubscribedPrincipal.getter(SubscribedPrincipal::user)).setter(SubscribedPrincipal.setter(Builder::user)).constructor(SubscribedUser::builder).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("user").build()).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUP_FIELD, PROJECT_FIELD, USER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SubscribedPrincipal.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final SubscribedGroup group;
    private final SubscribedProject project;
    private final SubscribedUser user;
    private final Type type;

    private SubscribedPrincipal(BuilderImpl builder) {
        this.group = builder.group;
        this.project = builder.project;
        this.user = builder.user;
        this.type = builder.type;
    }

    public final SubscribedGroup group() {
        return this.group;
    }

    public final SubscribedProject project() {
        return this.project;
    }

    public final SubscribedUser user() {
        return this.user;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.group());
        hashCode = 31 * hashCode + Objects.hashCode(this.project());
        hashCode = 31 * hashCode + Objects.hashCode(this.user());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SubscribedPrincipal)) {
            return false;
        }
        SubscribedPrincipal other = (SubscribedPrincipal)obj;
        return Objects.equals(this.group(), other.group()) && Objects.equals(this.project(), other.project()) && Objects.equals(this.user(), other.user());
    }

    public final String toString() {
        return ToString.builder("SubscribedPrincipal").add("Group", this.group()).add("Project", this.project()).add("User", this.user()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "group": {
                return Optional.ofNullable(clazz.cast(this.group()));
            }
            case "project": {
                return Optional.ofNullable(clazz.cast(this.project()));
            }
            case "user": {
                return Optional.ofNullable(clazz.cast(this.user()));
            }
        }
        return Optional.empty();
    }

    public static SubscribedPrincipal fromGroup(SubscribedGroup group) {
        return (SubscribedPrincipal)SubscribedPrincipal.builder().group(group).build();
    }

    public static SubscribedPrincipal fromGroup(Consumer<SubscribedGroup.Builder> group) {
        SubscribedGroup.Builder builder = SubscribedGroup.builder();
        group.accept(builder);
        return SubscribedPrincipal.fromGroup((SubscribedGroup)builder.build());
    }

    public static SubscribedPrincipal fromProject(SubscribedProject project) {
        return (SubscribedPrincipal)SubscribedPrincipal.builder().project(project).build();
    }

    public static SubscribedPrincipal fromProject(Consumer<SubscribedProject.Builder> project) {
        SubscribedProject.Builder builder = SubscribedProject.builder();
        project.accept(builder);
        return SubscribedPrincipal.fromProject((SubscribedProject)builder.build());
    }

    public static SubscribedPrincipal fromUser(SubscribedUser user) {
        return (SubscribedPrincipal)SubscribedPrincipal.builder().user(user).build();
    }

    public static SubscribedPrincipal fromUser(Consumer<SubscribedUser.Builder> user) {
        SubscribedUser.Builder builder = SubscribedUser.builder();
        user.accept(builder);
        return SubscribedPrincipal.fromUser((SubscribedUser)builder.build());
    }

    public Type type() {
        return this.type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<SdkPojo>> map = new HashMap<String, SdkField<SdkPojo>>();
        map.put("group", GROUP_FIELD);
        map.put("project", PROJECT_FIELD);
        map.put("user", USER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SubscribedPrincipal, T> g) {
        return obj -> g.apply((SubscribedPrincipal)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private SubscribedGroup group;
        private SubscribedProject project;
        private SubscribedUser user;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(SubscribedPrincipal model) {
            this.group(model.group);
            this.project(model.project);
            this.user(model.user);
        }

        public final SubscribedGroup.Builder getGroup() {
            return this.group != null ? this.group.toBuilder() : null;
        }

        public final void setGroup(SubscribedGroup.BuilderImpl group) {
            SubscribedGroup oldValue = this.group;
            this.group = group != null ? group.build() : null;
            this.handleUnionValueChange(Type.GROUP, oldValue, this.group);
        }

        @Override
        public final Builder group(SubscribedGroup group) {
            SubscribedGroup oldValue = this.group;
            this.group = group;
            this.handleUnionValueChange(Type.GROUP, oldValue, this.group);
            return this;
        }

        public final SubscribedProject.Builder getProject() {
            return this.project != null ? this.project.toBuilder() : null;
        }

        public final void setProject(SubscribedProject.BuilderImpl project) {
            SubscribedProject oldValue = this.project;
            this.project = project != null ? project.build() : null;
            this.handleUnionValueChange(Type.PROJECT, oldValue, this.project);
        }

        @Override
        public final Builder project(SubscribedProject project) {
            SubscribedProject oldValue = this.project;
            this.project = project;
            this.handleUnionValueChange(Type.PROJECT, oldValue, this.project);
            return this;
        }

        public final SubscribedUser.Builder getUser() {
            return this.user != null ? this.user.toBuilder() : null;
        }

        public final void setUser(SubscribedUser.BuilderImpl user) {
            SubscribedUser oldValue = this.user;
            this.user = user != null ? user.build() : null;
            this.handleUnionValueChange(Type.USER, oldValue, this.user);
        }

        @Override
        public final Builder user(SubscribedUser user) {
            SubscribedUser oldValue = this.user;
            this.user = user;
            this.handleUnionValueChange(Type.USER, oldValue, this.user);
            return this;
        }

        @Override
        public SubscribedPrincipal build() {
            return new SubscribedPrincipal(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static enum Type {
        GROUP,
        PROJECT,
        USER,
        UNKNOWN_TO_SDK_VERSION;

    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SubscribedPrincipal> {
        public Builder group(SubscribedGroup var1);

        default public Builder group(Consumer<SubscribedGroup.Builder> group) {
            return this.group((SubscribedGroup)SubscribedGroup.builder().applyMutation(group).build());
        }

        public Builder project(SubscribedProject var1);

        default public Builder project(Consumer<SubscribedProject.Builder> project) {
            return this.project((SubscribedProject)SubscribedProject.builder().applyMutation(project).build());
        }

        public Builder user(SubscribedUser var1);

        default public Builder user(Consumer<SubscribedUser.Builder> user) {
            return this.user((SubscribedUser)SubscribedUser.builder().applyMutation(user).build());
        }
    }
}

