/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.datazone.model.AssetInDataProductListingItem;
import software.amazon.awssdk.services.datazone.model.AssetInDataProductListingItemsCopier;
import software.amazon.awssdk.services.datazone.model.DetailedGlossaryTerm;
import software.amazon.awssdk.services.datazone.model.DetailedGlossaryTermsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SubscribedProductListing
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SubscribedProductListing> {
    private static final SdkField<List<AssetInDataProductListingItem>> ASSET_LISTINGS_FIELD = SdkField.builder(MarshallingType.LIST).memberName("assetListings").getter(SubscribedProductListing.getter(SubscribedProductListing::assetListings)).setter(SubscribedProductListing.setter(Builder::assetListings)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetListings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder(MarshallingType.SDK_POJO).constructor(AssetInDataProductListingItem::builder).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()).build()).build()).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder(MarshallingType.STRING).memberName("description").getter(SubscribedProductListing.getter(SubscribedProductListing::description)).setter(SubscribedProductListing.setter(Builder::description)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();
    private static final SdkField<String> ENTITY_ID_FIELD = SdkField.builder(MarshallingType.STRING).memberName("entityId").getter(SubscribedProductListing.getter(SubscribedProductListing::entityId)).setter(SubscribedProductListing.setter(Builder::entityId)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entityId").build()).build();
    private static final SdkField<String> ENTITY_REVISION_FIELD = SdkField.builder(MarshallingType.STRING).memberName("entityRevision").getter(SubscribedProductListing.getter(SubscribedProductListing::entityRevision)).setter(SubscribedProductListing.setter(Builder::entityRevision)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entityRevision").build()).build();
    private static final SdkField<List<DetailedGlossaryTerm>> GLOSSARY_TERMS_FIELD = SdkField.builder(MarshallingType.LIST).memberName("glossaryTerms").getter(SubscribedProductListing.getter(SubscribedProductListing::glossaryTerms)).setter(SubscribedProductListing.setter(Builder::glossaryTerms)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("glossaryTerms").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder(MarshallingType.SDK_POJO).constructor(DetailedGlossaryTerm::builder).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()).build()).build()).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder(MarshallingType.STRING).memberName("name").getter(SubscribedProductListing.getter(SubscribedProductListing::name)).setter(SubscribedProductListing.setter(Builder::name)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSET_LISTINGS_FIELD, DESCRIPTION_FIELD, ENTITY_ID_FIELD, ENTITY_REVISION_FIELD, GLOSSARY_TERMS_FIELD, NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SubscribedProductListing.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<AssetInDataProductListingItem> assetListings;
    private final String description;
    private final String entityId;
    private final String entityRevision;
    private final List<DetailedGlossaryTerm> glossaryTerms;
    private final String name;

    private SubscribedProductListing(BuilderImpl builder) {
        this.assetListings = builder.assetListings;
        this.description = builder.description;
        this.entityId = builder.entityId;
        this.entityRevision = builder.entityRevision;
        this.glossaryTerms = builder.glossaryTerms;
        this.name = builder.name;
    }

    public final boolean hasAssetListings() {
        return this.assetListings != null && !(this.assetListings instanceof SdkAutoConstructList);
    }

    public final List<AssetInDataProductListingItem> assetListings() {
        return this.assetListings;
    }

    public final String description() {
        return this.description;
    }

    public final String entityId() {
        return this.entityId;
    }

    public final String entityRevision() {
        return this.entityRevision;
    }

    public final boolean hasGlossaryTerms() {
        return this.glossaryTerms != null && !(this.glossaryTerms instanceof SdkAutoConstructList);
    }

    public final List<DetailedGlossaryTerm> glossaryTerms() {
        return this.glossaryTerms;
    }

    public final String name() {
        return this.name;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAssetListings() ? this.assetListings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.entityId());
        hashCode = 31 * hashCode + Objects.hashCode(this.entityRevision());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGlossaryTerms() ? this.glossaryTerms() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SubscribedProductListing)) {
            return false;
        }
        SubscribedProductListing other = (SubscribedProductListing)obj;
        return this.hasAssetListings() == other.hasAssetListings() && Objects.equals(this.assetListings(), other.assetListings()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.entityId(), other.entityId()) && Objects.equals(this.entityRevision(), other.entityRevision()) && this.hasGlossaryTerms() == other.hasGlossaryTerms() && Objects.equals(this.glossaryTerms(), other.glossaryTerms()) && Objects.equals(this.name(), other.name());
    }

    public final String toString() {
        return ToString.builder("SubscribedProductListing").add("AssetListings", this.hasAssetListings() ? this.assetListings() : null).add("Description", this.description()).add("EntityId", this.entityId()).add("EntityRevision", this.entityRevision()).add("GlossaryTerms", this.hasGlossaryTerms() ? this.glossaryTerms() : null).add("Name", this.name()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "assetListings": {
                return Optional.ofNullable(clazz.cast(this.assetListings()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "entityId": {
                return Optional.ofNullable(clazz.cast(this.entityId()));
            }
            case "entityRevision": {
                return Optional.ofNullable(clazz.cast(this.entityRevision()));
            }
            case "glossaryTerms": {
                return Optional.ofNullable(clazz.cast(this.glossaryTerms()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
        }
        return Optional.empty();
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<Object>> map = new HashMap<String, SdkField<Object>>();
        map.put("assetListings", ASSET_LISTINGS_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("entityId", ENTITY_ID_FIELD);
        map.put("entityRevision", ENTITY_REVISION_FIELD);
        map.put("glossaryTerms", GLOSSARY_TERMS_FIELD);
        map.put("name", NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SubscribedProductListing, T> g) {
        return obj -> g.apply((SubscribedProductListing)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<AssetInDataProductListingItem> assetListings = DefaultSdkAutoConstructList.getInstance();
        private String description;
        private String entityId;
        private String entityRevision;
        private List<DetailedGlossaryTerm> glossaryTerms = DefaultSdkAutoConstructList.getInstance();
        private String name;

        private BuilderImpl() {
        }

        private BuilderImpl(SubscribedProductListing model) {
            this.assetListings(model.assetListings);
            this.description(model.description);
            this.entityId(model.entityId);
            this.entityRevision(model.entityRevision);
            this.glossaryTerms(model.glossaryTerms);
            this.name(model.name);
        }

        public final List<AssetInDataProductListingItem.Builder> getAssetListings() {
            List<AssetInDataProductListingItem.Builder> result = AssetInDataProductListingItemsCopier.copyToBuilder(this.assetListings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAssetListings(Collection<AssetInDataProductListingItem.BuilderImpl> assetListings) {
            this.assetListings = AssetInDataProductListingItemsCopier.copyFromBuilder(assetListings);
        }

        @Override
        public final Builder assetListings(Collection<AssetInDataProductListingItem> assetListings) {
            this.assetListings = AssetInDataProductListingItemsCopier.copy(assetListings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assetListings(AssetInDataProductListingItem ... assetListings) {
            this.assetListings(Arrays.asList(assetListings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assetListings(Consumer<AssetInDataProductListingItem.Builder> ... assetListings) {
            this.assetListings(Stream.of(assetListings).map(c -> (AssetInDataProductListingItem)((AssetInDataProductListingItem.Builder)AssetInDataProductListingItem.builder().applyMutation(c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getEntityId() {
            return this.entityId;
        }

        public final void setEntityId(String entityId) {
            this.entityId = entityId;
        }

        @Override
        public final Builder entityId(String entityId) {
            this.entityId = entityId;
            return this;
        }

        public final String getEntityRevision() {
            return this.entityRevision;
        }

        public final void setEntityRevision(String entityRevision) {
            this.entityRevision = entityRevision;
        }

        @Override
        public final Builder entityRevision(String entityRevision) {
            this.entityRevision = entityRevision;
            return this;
        }

        public final List<DetailedGlossaryTerm.Builder> getGlossaryTerms() {
            List<DetailedGlossaryTerm.Builder> result = DetailedGlossaryTermsCopier.copyToBuilder(this.glossaryTerms);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGlossaryTerms(Collection<DetailedGlossaryTerm.BuilderImpl> glossaryTerms) {
            this.glossaryTerms = DetailedGlossaryTermsCopier.copyFromBuilder(glossaryTerms);
        }

        @Override
        public final Builder glossaryTerms(Collection<DetailedGlossaryTerm> glossaryTerms) {
            this.glossaryTerms = DetailedGlossaryTermsCopier.copy(glossaryTerms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder glossaryTerms(DetailedGlossaryTerm ... glossaryTerms) {
            this.glossaryTerms(Arrays.asList(glossaryTerms));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder glossaryTerms(Consumer<DetailedGlossaryTerm.Builder> ... glossaryTerms) {
            this.glossaryTerms(Stream.of(glossaryTerms).map(c -> (DetailedGlossaryTerm)((DetailedGlossaryTerm.Builder)DetailedGlossaryTerm.builder().applyMutation(c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public SubscribedProductListing build() {
            return new SubscribedProductListing(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SubscribedProductListing> {
        public Builder assetListings(Collection<AssetInDataProductListingItem> var1);

        public Builder assetListings(AssetInDataProductListingItem ... var1);

        public Builder assetListings(Consumer<AssetInDataProductListingItem.Builder> ... var1);

        public Builder description(String var1);

        public Builder entityId(String var1);

        public Builder entityRevision(String var1);

        public Builder glossaryTerms(Collection<DetailedGlossaryTerm> var1);

        public Builder glossaryTerms(DetailedGlossaryTerm ... var1);

        public Builder glossaryTerms(Consumer<DetailedGlossaryTerm.Builder> ... var1);

        public Builder name(String var1);
    }
}

