/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.datazone.model.MatchOffset;
import software.amazon.awssdk.services.datazone.model.MatchOffsetsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TextMatchItem
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TextMatchItem> {
    private static final SdkField<String> ATTRIBUTE_FIELD = SdkField.builder(MarshallingType.STRING).memberName("attribute").getter(TextMatchItem.getter(TextMatchItem::attribute)).setter(TextMatchItem.setter(Builder::attribute)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attribute").build()).build();
    private static final SdkField<List<MatchOffset>> MATCH_OFFSETS_FIELD = SdkField.builder(MarshallingType.LIST).memberName("matchOffsets").getter(TextMatchItem.getter(TextMatchItem::matchOffsets)).setter(TextMatchItem.setter(Builder::matchOffsets)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("matchOffsets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder(MarshallingType.SDK_POJO).constructor(MatchOffset::builder).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()).build()).build()).build();
    private static final SdkField<String> TEXT_FIELD = SdkField.builder(MarshallingType.STRING).memberName("text").getter(TextMatchItem.getter(TextMatchItem::text)).setter(TextMatchItem.setter(Builder::text)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("text").build()).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTRIBUTE_FIELD, MATCH_OFFSETS_FIELD, TEXT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TextMatchItem.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String attribute;
    private final List<MatchOffset> matchOffsets;
    private final String text;

    private TextMatchItem(BuilderImpl builder) {
        this.attribute = builder.attribute;
        this.matchOffsets = builder.matchOffsets;
        this.text = builder.text;
    }

    public final String attribute() {
        return this.attribute;
    }

    public final boolean hasMatchOffsets() {
        return this.matchOffsets != null && !(this.matchOffsets instanceof SdkAutoConstructList);
    }

    public final List<MatchOffset> matchOffsets() {
        return this.matchOffsets;
    }

    public final String text() {
        return this.text;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.attribute());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMatchOffsets() ? this.matchOffsets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.text());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TextMatchItem)) {
            return false;
        }
        TextMatchItem other = (TextMatchItem)obj;
        return Objects.equals(this.attribute(), other.attribute()) && this.hasMatchOffsets() == other.hasMatchOffsets() && Objects.equals(this.matchOffsets(), other.matchOffsets()) && Objects.equals(this.text(), other.text());
    }

    public final String toString() {
        return ToString.builder("TextMatchItem").add("Attribute", this.attribute()).add("MatchOffsets", this.hasMatchOffsets() ? this.matchOffsets() : null).add("Text", this.text()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "attribute": {
                return Optional.ofNullable(clazz.cast(this.attribute()));
            }
            case "matchOffsets": {
                return Optional.ofNullable(clazz.cast(this.matchOffsets()));
            }
            case "text": {
                return Optional.ofNullable(clazz.cast(this.text()));
            }
        }
        return Optional.empty();
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<Object>> map = new HashMap<String, SdkField<Object>>();
        map.put("attribute", ATTRIBUTE_FIELD);
        map.put("matchOffsets", MATCH_OFFSETS_FIELD);
        map.put("text", TEXT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TextMatchItem, T> g) {
        return obj -> g.apply((TextMatchItem)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String attribute;
        private List<MatchOffset> matchOffsets = DefaultSdkAutoConstructList.getInstance();
        private String text;

        private BuilderImpl() {
        }

        private BuilderImpl(TextMatchItem model) {
            this.attribute(model.attribute);
            this.matchOffsets(model.matchOffsets);
            this.text(model.text);
        }

        public final String getAttribute() {
            return this.attribute;
        }

        public final void setAttribute(String attribute) {
            this.attribute = attribute;
        }

        @Override
        public final Builder attribute(String attribute) {
            this.attribute = attribute;
            return this;
        }

        public final List<MatchOffset.Builder> getMatchOffsets() {
            List<MatchOffset.Builder> result = MatchOffsetsCopier.copyToBuilder(this.matchOffsets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMatchOffsets(Collection<MatchOffset.BuilderImpl> matchOffsets) {
            this.matchOffsets = MatchOffsetsCopier.copyFromBuilder(matchOffsets);
        }

        @Override
        public final Builder matchOffsets(Collection<MatchOffset> matchOffsets) {
            this.matchOffsets = MatchOffsetsCopier.copy(matchOffsets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder matchOffsets(MatchOffset ... matchOffsets) {
            this.matchOffsets(Arrays.asList(matchOffsets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder matchOffsets(Consumer<MatchOffset.Builder> ... matchOffsets) {
            this.matchOffsets(Stream.of(matchOffsets).map(c -> (MatchOffset)((MatchOffset.Builder)MatchOffset.builder().applyMutation(c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getText() {
            return this.text;
        }

        public final void setText(String text) {
            this.text = text;
        }

        @Override
        public final Builder text(String text) {
            this.text = text;
            return this;
        }

        @Override
        public TextMatchItem build() {
            return new TextMatchItem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TextMatchItem> {
        public Builder attribute(String var1);

        public Builder matchOffsets(Collection<MatchOffset> var1);

        public Builder matchOffsets(MatchOffset ... var1);

        public Builder matchOffsets(Consumer<MatchOffset.Builder> ... var1);

        public Builder text(String var1);
    }
}

