/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.datazone.DataZoneClient;
import software.amazon.awssdk.services.datazone.internal.UserAgentUtils;
import software.amazon.awssdk.services.datazone.model.AccountPoolSummary;
import software.amazon.awssdk.services.datazone.model.ListAccountPoolsRequest;
import software.amazon.awssdk.services.datazone.model.ListAccountPoolsResponse;

public class ListAccountPoolsIterable
implements SdkIterable<ListAccountPoolsResponse> {
    private final DataZoneClient client;
    private final ListAccountPoolsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAccountPoolsIterable(DataZoneClient client, ListAccountPoolsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListAccountPoolsResponseFetcher();
    }

    @Override
    public Iterator<ListAccountPoolsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<AccountPoolSummary> items() {
        Function<ListAccountPoolsResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable(this).itemIteratorFunction(getIterator).build();
    }

    private class ListAccountPoolsResponseFetcher
    implements SyncPageFetcher<ListAccountPoolsResponse> {
        private ListAccountPoolsResponseFetcher() {
        }

        @Override
        public boolean hasNextPage(ListAccountPoolsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable(previousPage.nextToken());
        }

        @Override
        public ListAccountPoolsResponse nextPage(ListAccountPoolsResponse previousPage) {
            if (previousPage == null) {
                return ListAccountPoolsIterable.this.client.listAccountPools(ListAccountPoolsIterable.this.firstRequest);
            }
            return ListAccountPoolsIterable.this.client.listAccountPools((ListAccountPoolsRequest)ListAccountPoolsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build());
        }
    }
}

