/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.datazone.DataZoneClient;
import software.amazon.awssdk.services.datazone.internal.UserAgentUtils;
import software.amazon.awssdk.services.datazone.model.DataSourceSummary;
import software.amazon.awssdk.services.datazone.model.ListDataSourcesRequest;
import software.amazon.awssdk.services.datazone.model.ListDataSourcesResponse;

public class ListDataSourcesIterable
implements SdkIterable<ListDataSourcesResponse> {
    private final DataZoneClient client;
    private final ListDataSourcesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListDataSourcesIterable(DataZoneClient client, ListDataSourcesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListDataSourcesResponseFetcher();
    }

    @Override
    public Iterator<ListDataSourcesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<DataSourceSummary> items() {
        Function<ListDataSourcesResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable(this).itemIteratorFunction(getIterator).build();
    }

    private class ListDataSourcesResponseFetcher
    implements SyncPageFetcher<ListDataSourcesResponse> {
        private ListDataSourcesResponseFetcher() {
        }

        @Override
        public boolean hasNextPage(ListDataSourcesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable(previousPage.nextToken());
        }

        @Override
        public ListDataSourcesResponse nextPage(ListDataSourcesResponse previousPage) {
            if (previousPage == null) {
                return ListDataSourcesIterable.this.client.listDataSources(ListDataSourcesIterable.this.firstRequest);
            }
            return ListDataSourcesIterable.this.client.listDataSources((ListDataSourcesRequest)ListDataSourcesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build());
        }
    }
}

