/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.datazone.DataZoneAsyncClient;
import software.amazon.awssdk.services.datazone.internal.UserAgentUtils;
import software.amazon.awssdk.services.datazone.model.DomainUnitSummary;
import software.amazon.awssdk.services.datazone.model.ListDomainUnitsForParentRequest;
import software.amazon.awssdk.services.datazone.model.ListDomainUnitsForParentResponse;

public class ListDomainUnitsForParentPublisher
implements SdkPublisher<ListDomainUnitsForParentResponse> {
    private final DataZoneAsyncClient client;
    private final ListDomainUnitsForParentRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListDomainUnitsForParentPublisher(DataZoneAsyncClient client, ListDomainUnitsForParentRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListDomainUnitsForParentPublisher(DataZoneAsyncClient client, ListDomainUnitsForParentRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListDomainUnitsForParentResponseFetcher();
    }

    @Override
    public void subscribe(Subscriber<? super ListDomainUnitsForParentResponse> subscriber) {
        subscriber.onSubscribe(((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<DomainUnitSummary> items() {
        Function<ListDomainUnitsForParentResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher(new ListDomainUnitsForParentResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListDomainUnitsForParentResponseFetcher
    implements AsyncPageFetcher<ListDomainUnitsForParentResponse> {
        private ListDomainUnitsForParentResponseFetcher() {
        }

        @Override
        public boolean hasNextPage(ListDomainUnitsForParentResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable(previousPage.nextToken());
        }

        @Override
        public CompletableFuture<ListDomainUnitsForParentResponse> nextPage(ListDomainUnitsForParentResponse previousPage) {
            if (previousPage == null) {
                return ListDomainUnitsForParentPublisher.this.client.listDomainUnitsForParent(ListDomainUnitsForParentPublisher.this.firstRequest);
            }
            return ListDomainUnitsForParentPublisher.this.client.listDomainUnitsForParent((ListDomainUnitsForParentRequest)ListDomainUnitsForParentPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build());
        }
    }
}

