/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.datazone.DataZoneClient;
import software.amazon.awssdk.services.datazone.internal.UserAgentUtils;
import software.amazon.awssdk.services.datazone.model.DomainSummary;
import software.amazon.awssdk.services.datazone.model.ListDomainsRequest;
import software.amazon.awssdk.services.datazone.model.ListDomainsResponse;

public class ListDomainsIterable
implements SdkIterable<ListDomainsResponse> {
    private final DataZoneClient client;
    private final ListDomainsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListDomainsIterable(DataZoneClient client, ListDomainsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListDomainsResponseFetcher();
    }

    @Override
    public Iterator<ListDomainsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<DomainSummary> items() {
        Function<ListDomainsResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable(this).itemIteratorFunction(getIterator).build();
    }

    private class ListDomainsResponseFetcher
    implements SyncPageFetcher<ListDomainsResponse> {
        private ListDomainsResponseFetcher() {
        }

        @Override
        public boolean hasNextPage(ListDomainsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable(previousPage.nextToken());
        }

        @Override
        public ListDomainsResponse nextPage(ListDomainsResponse previousPage) {
            if (previousPage == null) {
                return ListDomainsIterable.this.client.listDomains(ListDomainsIterable.this.firstRequest);
            }
            return ListDomainsIterable.this.client.listDomains((ListDomainsRequest)ListDomainsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build());
        }
    }
}

