/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.datazone.DataZoneClient;
import software.amazon.awssdk.services.datazone.internal.UserAgentUtils;
import software.amazon.awssdk.services.datazone.model.EnvironmentProfileSummary;
import software.amazon.awssdk.services.datazone.model.ListEnvironmentProfilesRequest;
import software.amazon.awssdk.services.datazone.model.ListEnvironmentProfilesResponse;

public class ListEnvironmentProfilesIterable
implements SdkIterable<ListEnvironmentProfilesResponse> {
    private final DataZoneClient client;
    private final ListEnvironmentProfilesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListEnvironmentProfilesIterable(DataZoneClient client, ListEnvironmentProfilesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListEnvironmentProfilesResponseFetcher();
    }

    @Override
    public Iterator<ListEnvironmentProfilesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<EnvironmentProfileSummary> items() {
        Function<ListEnvironmentProfilesResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable(this).itemIteratorFunction(getIterator).build();
    }

    private class ListEnvironmentProfilesResponseFetcher
    implements SyncPageFetcher<ListEnvironmentProfilesResponse> {
        private ListEnvironmentProfilesResponseFetcher() {
        }

        @Override
        public boolean hasNextPage(ListEnvironmentProfilesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable(previousPage.nextToken());
        }

        @Override
        public ListEnvironmentProfilesResponse nextPage(ListEnvironmentProfilesResponse previousPage) {
            if (previousPage == null) {
                return ListEnvironmentProfilesIterable.this.client.listEnvironmentProfiles(ListEnvironmentProfilesIterable.this.firstRequest);
            }
            return ListEnvironmentProfilesIterable.this.client.listEnvironmentProfiles((ListEnvironmentProfilesRequest)ListEnvironmentProfilesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build());
        }
    }
}

