/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.datazone.DataZoneClient;
import software.amazon.awssdk.services.datazone.internal.UserAgentUtils;
import software.amazon.awssdk.services.datazone.model.EnvironmentSummary;
import software.amazon.awssdk.services.datazone.model.ListEnvironmentsRequest;
import software.amazon.awssdk.services.datazone.model.ListEnvironmentsResponse;

public class ListEnvironmentsIterable
implements SdkIterable<ListEnvironmentsResponse> {
    private final DataZoneClient client;
    private final ListEnvironmentsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListEnvironmentsIterable(DataZoneClient client, ListEnvironmentsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListEnvironmentsResponseFetcher();
    }

    @Override
    public Iterator<ListEnvironmentsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<EnvironmentSummary> items() {
        Function<ListEnvironmentsResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable(this).itemIteratorFunction(getIterator).build();
    }

    private class ListEnvironmentsResponseFetcher
    implements SyncPageFetcher<ListEnvironmentsResponse> {
        private ListEnvironmentsResponseFetcher() {
        }

        @Override
        public boolean hasNextPage(ListEnvironmentsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable(previousPage.nextToken());
        }

        @Override
        public ListEnvironmentsResponse nextPage(ListEnvironmentsResponse previousPage) {
            if (previousPage == null) {
                return ListEnvironmentsIterable.this.client.listEnvironments(ListEnvironmentsIterable.this.firstRequest);
            }
            return ListEnvironmentsIterable.this.client.listEnvironments((ListEnvironmentsRequest)ListEnvironmentsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build());
        }
    }
}

