/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.datazone.DataZoneAsyncClient;
import software.amazon.awssdk.services.datazone.internal.UserAgentUtils;
import software.amazon.awssdk.services.datazone.model.ListPolicyGrantsRequest;
import software.amazon.awssdk.services.datazone.model.ListPolicyGrantsResponse;
import software.amazon.awssdk.services.datazone.model.PolicyGrantMember;

public class ListPolicyGrantsPublisher
implements SdkPublisher<ListPolicyGrantsResponse> {
    private final DataZoneAsyncClient client;
    private final ListPolicyGrantsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListPolicyGrantsPublisher(DataZoneAsyncClient client, ListPolicyGrantsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListPolicyGrantsPublisher(DataZoneAsyncClient client, ListPolicyGrantsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListPolicyGrantsResponseFetcher();
    }

    @Override
    public void subscribe(Subscriber<? super ListPolicyGrantsResponse> subscriber) {
        subscriber.onSubscribe(((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<PolicyGrantMember> grantList() {
        Function<ListPolicyGrantsResponse, Iterator> getIterator = response -> {
            if (response != null && response.grantList() != null) {
                return response.grantList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher(new ListPolicyGrantsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListPolicyGrantsResponseFetcher
    implements AsyncPageFetcher<ListPolicyGrantsResponse> {
        private ListPolicyGrantsResponseFetcher() {
        }

        @Override
        public boolean hasNextPage(ListPolicyGrantsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable(previousPage.nextToken());
        }

        @Override
        public CompletableFuture<ListPolicyGrantsResponse> nextPage(ListPolicyGrantsResponse previousPage) {
            if (previousPage == null) {
                return ListPolicyGrantsPublisher.this.client.listPolicyGrants(ListPolicyGrantsPublisher.this.firstRequest);
            }
            return ListPolicyGrantsPublisher.this.client.listPolicyGrants((ListPolicyGrantsRequest)ListPolicyGrantsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build());
        }
    }
}

