/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.datazone.DataZoneAsyncClient;
import software.amazon.awssdk.services.datazone.internal.UserAgentUtils;
import software.amazon.awssdk.services.datazone.model.SearchUserProfilesRequest;
import software.amazon.awssdk.services.datazone.model.SearchUserProfilesResponse;
import software.amazon.awssdk.services.datazone.model.UserProfileSummary;

public class SearchUserProfilesPublisher
implements SdkPublisher<SearchUserProfilesResponse> {
    private final DataZoneAsyncClient client;
    private final SearchUserProfilesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public SearchUserProfilesPublisher(DataZoneAsyncClient client, SearchUserProfilesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private SearchUserProfilesPublisher(DataZoneAsyncClient client, SearchUserProfilesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new SearchUserProfilesResponseFetcher();
    }

    @Override
    public void subscribe(Subscriber<? super SearchUserProfilesResponse> subscriber) {
        subscriber.onSubscribe(((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<UserProfileSummary> items() {
        Function<SearchUserProfilesResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher(new SearchUserProfilesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class SearchUserProfilesResponseFetcher
    implements AsyncPageFetcher<SearchUserProfilesResponse> {
        private SearchUserProfilesResponseFetcher() {
        }

        @Override
        public boolean hasNextPage(SearchUserProfilesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable(previousPage.nextToken());
        }

        @Override
        public CompletableFuture<SearchUserProfilesResponse> nextPage(SearchUserProfilesResponse previousPage) {
            if (previousPage == null) {
                return SearchUserProfilesPublisher.this.client.searchUserProfiles(SearchUserProfilesPublisher.this.firstRequest);
            }
            return SearchUserProfilesPublisher.this.client.searchUserProfiles((SearchUserProfilesRequest)SearchUserProfilesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build());
        }
    }
}

