/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lakeformation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lakeformation.model.BatchPermissionsFailureEntry;
import software.amazon.awssdk.services.lakeformation.model.BatchPermissionsFailureListCopier;
import software.amazon.awssdk.services.lakeformation.model.LakeFormationResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchRevokePermissionsResponse
extends LakeFormationResponse
implements ToCopyableBuilder<Builder, BatchRevokePermissionsResponse> {
    private static final SdkField<List<BatchPermissionsFailureEntry>> FAILURES_FIELD = SdkField.builder(MarshallingType.LIST).memberName("Failures").getter(BatchRevokePermissionsResponse.getter(BatchRevokePermissionsResponse::failures)).setter(BatchRevokePermissionsResponse.setter(Builder::failures)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Failures").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder(MarshallingType.SDK_POJO).constructor(BatchPermissionsFailureEntry::builder).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()).build()).build()).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FAILURES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BatchRevokePermissionsResponse.memberNameToFieldInitializer();
    private final List<BatchPermissionsFailureEntry> failures;

    private BatchRevokePermissionsResponse(BuilderImpl builder) {
        super(builder);
        this.failures = builder.failures;
    }

    public final boolean hasFailures() {
        return this.failures != null && !(this.failures instanceof SdkAutoConstructList);
    }

    public final List<BatchPermissionsFailureEntry> failures() {
        return this.failures;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFailures() ? this.failures() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchRevokePermissionsResponse)) {
            return false;
        }
        BatchRevokePermissionsResponse other = (BatchRevokePermissionsResponse)obj;
        return this.hasFailures() == other.hasFailures() && Objects.equals(this.failures(), other.failures());
    }

    public final String toString() {
        return ToString.builder("BatchRevokePermissionsResponse").add("Failures", this.hasFailures() ? this.failures() : null).build();
    }

    @Override
    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Failures": {
                return Optional.ofNullable(clazz.cast(this.failures()));
            }
        }
        return Optional.empty();
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<BatchPermissionsFailureEntry>>> map = new HashMap<String, SdkField<List<BatchPermissionsFailureEntry>>>();
        map.put("Failures", FAILURES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchRevokePermissionsResponse, T> g) {
        return obj -> g.apply((BatchRevokePermissionsResponse)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LakeFormationResponse.BuilderImpl
    implements Builder {
        private List<BatchPermissionsFailureEntry> failures = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchRevokePermissionsResponse model) {
            super(model);
            this.failures(model.failures);
        }

        public final List<BatchPermissionsFailureEntry.Builder> getFailures() {
            List<BatchPermissionsFailureEntry.Builder> result = BatchPermissionsFailureListCopier.copyToBuilder(this.failures);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFailures(Collection<BatchPermissionsFailureEntry.BuilderImpl> failures) {
            this.failures = BatchPermissionsFailureListCopier.copyFromBuilder(failures);
        }

        @Override
        public final Builder failures(Collection<BatchPermissionsFailureEntry> failures) {
            this.failures = BatchPermissionsFailureListCopier.copy(failures);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failures(BatchPermissionsFailureEntry ... failures) {
            this.failures(Arrays.asList(failures));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failures(Consumer<BatchPermissionsFailureEntry.Builder> ... failures) {
            this.failures(Stream.of(failures).map(c -> (BatchPermissionsFailureEntry)((BatchPermissionsFailureEntry.Builder)BatchPermissionsFailureEntry.builder().applyMutation(c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchRevokePermissionsResponse build() {
            return new BatchRevokePermissionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends LakeFormationResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchRevokePermissionsResponse> {
        public Builder failures(Collection<BatchPermissionsFailureEntry> var1);

        public Builder failures(BatchPermissionsFailureEntry ... var1);

        public Builder failures(Consumer<BatchPermissionsFailureEntry.Builder> ... var1);
    }
}

