/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lakeformation.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.services.lakeformation.model.Condition;
import software.amazon.awssdk.services.lakeformation.model.DataLakePrincipal;
import software.amazon.awssdk.services.lakeformation.model.LakeFormationRequest;
import software.amazon.awssdk.services.lakeformation.model.Resource;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateLakeFormationOptInRequest
extends LakeFormationRequest
implements ToCopyableBuilder<Builder, CreateLakeFormationOptInRequest> {
    private static final SdkField<DataLakePrincipal> PRINCIPAL_FIELD = SdkField.builder(MarshallingType.SDK_POJO).memberName("Principal").getter(CreateLakeFormationOptInRequest.getter(CreateLakeFormationOptInRequest::principal)).setter(CreateLakeFormationOptInRequest.setter(Builder::principal)).constructor(DataLakePrincipal::builder).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Principal").build()).build();
    private static final SdkField<Resource> RESOURCE_FIELD = SdkField.builder(MarshallingType.SDK_POJO).memberName("Resource").getter(CreateLakeFormationOptInRequest.getter(CreateLakeFormationOptInRequest::resource)).setter(CreateLakeFormationOptInRequest.setter(Builder::resource)).constructor(Resource::builder).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Resource").build()).build();
    private static final SdkField<Condition> CONDITION_FIELD = SdkField.builder(MarshallingType.SDK_POJO).memberName("Condition").getter(CreateLakeFormationOptInRequest.getter(CreateLakeFormationOptInRequest::condition)).setter(CreateLakeFormationOptInRequest.setter(Builder::condition)).constructor(Condition::builder).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Condition").build()).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRINCIPAL_FIELD, RESOURCE_FIELD, CONDITION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateLakeFormationOptInRequest.memberNameToFieldInitializer();
    private final DataLakePrincipal principal;
    private final Resource resource;
    private final Condition condition;

    private CreateLakeFormationOptInRequest(BuilderImpl builder) {
        super(builder);
        this.principal = builder.principal;
        this.resource = builder.resource;
        this.condition = builder.condition;
    }

    public final DataLakePrincipal principal() {
        return this.principal;
    }

    public final Resource resource() {
        return this.resource;
    }

    public final Condition condition() {
        return this.condition;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.principal());
        hashCode = 31 * hashCode + Objects.hashCode(this.resource());
        hashCode = 31 * hashCode + Objects.hashCode(this.condition());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateLakeFormationOptInRequest)) {
            return false;
        }
        CreateLakeFormationOptInRequest other = (CreateLakeFormationOptInRequest)obj;
        return Objects.equals(this.principal(), other.principal()) && Objects.equals(this.resource(), other.resource()) && Objects.equals(this.condition(), other.condition());
    }

    public final String toString() {
        return ToString.builder("CreateLakeFormationOptInRequest").add("Principal", this.principal()).add("Resource", this.resource()).add("Condition", this.condition()).build();
    }

    @Override
    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Principal": {
                return Optional.ofNullable(clazz.cast(this.principal()));
            }
            case "Resource": {
                return Optional.ofNullable(clazz.cast(this.resource()));
            }
            case "Condition": {
                return Optional.ofNullable(clazz.cast(this.condition()));
            }
        }
        return Optional.empty();
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<SdkPojo>> map = new HashMap<String, SdkField<SdkPojo>>();
        map.put("Principal", PRINCIPAL_FIELD);
        map.put("Resource", RESOURCE_FIELD);
        map.put("Condition", CONDITION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateLakeFormationOptInRequest, T> g) {
        return obj -> g.apply((CreateLakeFormationOptInRequest)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LakeFormationRequest.BuilderImpl
    implements Builder {
        private DataLakePrincipal principal;
        private Resource resource;
        private Condition condition;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateLakeFormationOptInRequest model) {
            super(model);
            this.principal(model.principal);
            this.resource(model.resource);
            this.condition(model.condition);
        }

        public final DataLakePrincipal.Builder getPrincipal() {
            return this.principal != null ? this.principal.toBuilder() : null;
        }

        public final void setPrincipal(DataLakePrincipal.BuilderImpl principal) {
            this.principal = principal != null ? principal.build() : null;
        }

        @Override
        public final Builder principal(DataLakePrincipal principal) {
            this.principal = principal;
            return this;
        }

        public final Resource.Builder getResource() {
            return this.resource != null ? this.resource.toBuilder() : null;
        }

        public final void setResource(Resource.BuilderImpl resource) {
            this.resource = resource != null ? resource.build() : null;
        }

        @Override
        public final Builder resource(Resource resource) {
            this.resource = resource;
            return this;
        }

        public final Condition.Builder getCondition() {
            return this.condition != null ? this.condition.toBuilder() : null;
        }

        public final void setCondition(Condition.BuilderImpl condition) {
            this.condition = condition != null ? condition.build() : null;
        }

        @Override
        public final Builder condition(Condition condition) {
            this.condition = condition;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateLakeFormationOptInRequest build() {
            return new CreateLakeFormationOptInRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends LakeFormationRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateLakeFormationOptInRequest> {
        public Builder principal(DataLakePrincipal var1);

        default public Builder principal(Consumer<DataLakePrincipal.Builder> principal) {
            return this.principal((DataLakePrincipal)DataLakePrincipal.builder().applyMutation(principal).build());
        }

        public Builder resource(Resource var1);

        default public Builder resource(Consumer<Resource.Builder> resource) {
            return this.resource((Resource)Resource.builder().applyMutation(resource).build());
        }

        public Builder condition(Condition var1);

        default public Builder condition(Consumer<Condition.Builder> condition) {
            return this.condition((Condition)Condition.builder().applyMutation(condition).build());
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

