/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lakeformation.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.services.lakeformation.model.LakeFormationResponse;
import software.amazon.awssdk.services.lakeformation.model.QueryStateString;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetQueryStateResponse
extends LakeFormationResponse
implements ToCopyableBuilder<Builder, GetQueryStateResponse> {
    private static final SdkField<String> ERROR_FIELD = SdkField.builder(MarshallingType.STRING).memberName("Error").getter(GetQueryStateResponse.getter(GetQueryStateResponse::error)).setter(GetQueryStateResponse.setter(Builder::error)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Error").build()).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder(MarshallingType.STRING).memberName("State").getter(GetQueryStateResponse.getter(GetQueryStateResponse::stateAsString)).setter(GetQueryStateResponse.setter(Builder::state)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ERROR_FIELD, STATE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetQueryStateResponse.memberNameToFieldInitializer();
    private final String error;
    private final String state;

    private GetQueryStateResponse(BuilderImpl builder) {
        super(builder);
        this.error = builder.error;
        this.state = builder.state;
    }

    public final String error() {
        return this.error;
    }

    public final QueryStateString state() {
        return QueryStateString.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.error());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetQueryStateResponse)) {
            return false;
        }
        GetQueryStateResponse other = (GetQueryStateResponse)obj;
        return Objects.equals(this.error(), other.error()) && Objects.equals(this.stateAsString(), other.stateAsString());
    }

    public final String toString() {
        return ToString.builder("GetQueryStateResponse").add("Error", this.error()).add("State", this.stateAsString()).build();
    }

    @Override
    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Error": {
                return Optional.ofNullable(clazz.cast(this.error()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
        }
        return Optional.empty();
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("Error", ERROR_FIELD);
        map.put("State", STATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetQueryStateResponse, T> g) {
        return obj -> g.apply((GetQueryStateResponse)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LakeFormationResponse.BuilderImpl
    implements Builder {
        private String error;
        private String state;

        private BuilderImpl() {
        }

        private BuilderImpl(GetQueryStateResponse model) {
            super(model);
            this.error(model.error);
            this.state(model.state);
        }

        public final String getError() {
            return this.error;
        }

        public final void setError(String error) {
            this.error = error;
        }

        @Override
        public final Builder error(String error) {
            this.error = error;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(QueryStateString state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        @Override
        public GetQueryStateResponse build() {
            return new GetQueryStateResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends LakeFormationResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetQueryStateResponse> {
        public Builder error(String var1);

        public Builder state(String var1);

        public Builder state(QueryStateString var1);
    }
}

