/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lakeformation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lakeformation.model.DataCellsFilter;
import software.amazon.awssdk.services.lakeformation.model.DataCellsFilterListCopier;
import software.amazon.awssdk.services.lakeformation.model.LakeFormationResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListDataCellsFilterResponse
extends LakeFormationResponse
implements ToCopyableBuilder<Builder, ListDataCellsFilterResponse> {
    private static final SdkField<List<DataCellsFilter>> DATA_CELLS_FILTERS_FIELD = SdkField.builder(MarshallingType.LIST).memberName("DataCellsFilters").getter(ListDataCellsFilterResponse.getter(ListDataCellsFilterResponse::dataCellsFilters)).setter(ListDataCellsFilterResponse.setter(Builder::dataCellsFilters)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataCellsFilters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder(MarshallingType.SDK_POJO).constructor(DataCellsFilter::builder).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()).build()).build()).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder(MarshallingType.STRING).memberName("NextToken").getter(ListDataCellsFilterResponse.getter(ListDataCellsFilterResponse::nextToken)).setter(ListDataCellsFilterResponse.setter(Builder::nextToken)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_CELLS_FILTERS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListDataCellsFilterResponse.memberNameToFieldInitializer();
    private final List<DataCellsFilter> dataCellsFilters;
    private final String nextToken;

    private ListDataCellsFilterResponse(BuilderImpl builder) {
        super(builder);
        this.dataCellsFilters = builder.dataCellsFilters;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasDataCellsFilters() {
        return this.dataCellsFilters != null && !(this.dataCellsFilters instanceof SdkAutoConstructList);
    }

    public final List<DataCellsFilter> dataCellsFilters() {
        return this.dataCellsFilters;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDataCellsFilters() ? this.dataCellsFilters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDataCellsFilterResponse)) {
            return false;
        }
        ListDataCellsFilterResponse other = (ListDataCellsFilterResponse)obj;
        return this.hasDataCellsFilters() == other.hasDataCellsFilters() && Objects.equals(this.dataCellsFilters(), other.dataCellsFilters()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder("ListDataCellsFilterResponse").add("DataCellsFilters", this.hasDataCellsFilters() ? this.dataCellsFilters() : null).add("NextToken", this.nextToken()).build();
    }

    @Override
    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DataCellsFilters": {
                return Optional.ofNullable(clazz.cast(this.dataCellsFilters()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<Object>> map = new HashMap<String, SdkField<Object>>();
        map.put("DataCellsFilters", DATA_CELLS_FILTERS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListDataCellsFilterResponse, T> g) {
        return obj -> g.apply((ListDataCellsFilterResponse)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LakeFormationResponse.BuilderImpl
    implements Builder {
        private List<DataCellsFilter> dataCellsFilters = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDataCellsFilterResponse model) {
            super(model);
            this.dataCellsFilters(model.dataCellsFilters);
            this.nextToken(model.nextToken);
        }

        public final List<DataCellsFilter.Builder> getDataCellsFilters() {
            List<DataCellsFilter.Builder> result = DataCellsFilterListCopier.copyToBuilder(this.dataCellsFilters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDataCellsFilters(Collection<DataCellsFilter.BuilderImpl> dataCellsFilters) {
            this.dataCellsFilters = DataCellsFilterListCopier.copyFromBuilder(dataCellsFilters);
        }

        @Override
        public final Builder dataCellsFilters(Collection<DataCellsFilter> dataCellsFilters) {
            this.dataCellsFilters = DataCellsFilterListCopier.copy(dataCellsFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataCellsFilters(DataCellsFilter ... dataCellsFilters) {
            this.dataCellsFilters(Arrays.asList(dataCellsFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataCellsFilters(Consumer<DataCellsFilter.Builder> ... dataCellsFilters) {
            this.dataCellsFilters(Stream.of(dataCellsFilters).map(c -> (DataCellsFilter)((DataCellsFilter.Builder)DataCellsFilter.builder().applyMutation(c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListDataCellsFilterResponse build() {
            return new ListDataCellsFilterResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends LakeFormationResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListDataCellsFilterResponse> {
        public Builder dataCellsFilters(Collection<DataCellsFilter> var1);

        public Builder dataCellsFilters(DataCellsFilter ... var1);

        public Builder dataCellsFilters(Consumer<DataCellsFilter.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

