/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lakeformation.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum PermissionType {
    COLUMN_PERMISSION("COLUMN_PERMISSION"),
    CELL_FILTER_PERMISSION("CELL_FILTER_PERMISSION"),
    NESTED_PERMISSION("NESTED_PERMISSION"),
    NESTED_CELL_PERMISSION("NESTED_CELL_PERMISSION"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, PermissionType> VALUE_MAP;
    private final String value;

    private PermissionType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static PermissionType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<PermissionType> knownValues() {
        EnumSet<PermissionType> knownValues = EnumSet.allOf(PermissionType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(PermissionType.class, PermissionType::toString);
    }
}

