/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lakeformation.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum TransactionType {
    READ_AND_WRITE("READ_AND_WRITE"),
    READ_ONLY("READ_ONLY"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, TransactionType> VALUE_MAP;
    private final String value;

    private TransactionType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static TransactionType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<TransactionType> knownValues() {
        EnumSet<TransactionType> knownValues = EnumSet.allOf(TransactionType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(TransactionType.class, TransactionType::toString);
    }
}

