/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lakeformation.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.lakeformation.model.LakeFormationRequest;
import software.amazon.awssdk.services.lakeformation.model.OptimizerType;
import software.amazon.awssdk.services.lakeformation.model.StorageOptimizerConfigMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateTableStorageOptimizerRequest
extends LakeFormationRequest
implements ToCopyableBuilder<Builder, UpdateTableStorageOptimizerRequest> {
    private static final SdkField<String> CATALOG_ID_FIELD = SdkField.builder(MarshallingType.STRING).memberName("CatalogId").getter(UpdateTableStorageOptimizerRequest.getter(UpdateTableStorageOptimizerRequest::catalogId)).setter(UpdateTableStorageOptimizerRequest.setter(Builder::catalogId)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CatalogId").build()).build();
    private static final SdkField<String> DATABASE_NAME_FIELD = SdkField.builder(MarshallingType.STRING).memberName("DatabaseName").getter(UpdateTableStorageOptimizerRequest.getter(UpdateTableStorageOptimizerRequest::databaseName)).setter(UpdateTableStorageOptimizerRequest.setter(Builder::databaseName)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseName").build()).build();
    private static final SdkField<String> TABLE_NAME_FIELD = SdkField.builder(MarshallingType.STRING).memberName("TableName").getter(UpdateTableStorageOptimizerRequest.getter(UpdateTableStorageOptimizerRequest::tableName)).setter(UpdateTableStorageOptimizerRequest.setter(Builder::tableName)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableName").build()).build();
    private static final SdkField<Map<String, Map<String, String>>> STORAGE_OPTIMIZER_CONFIG_FIELD = SdkField.builder(MarshallingType.MAP).memberName("StorageOptimizerConfig").getter(UpdateTableStorageOptimizerRequest.getter(UpdateTableStorageOptimizerRequest::storageOptimizerConfigAsStrings)).setter(UpdateTableStorageOptimizerRequest.setter(Builder::storageOptimizerConfigWithStrings)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageOptimizerConfig").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder(MarshallingType.MAP).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder(MarshallingType.STRING).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()).build()).build()).build()).build()).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_ID_FIELD, DATABASE_NAME_FIELD, TABLE_NAME_FIELD, STORAGE_OPTIMIZER_CONFIG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateTableStorageOptimizerRequest.memberNameToFieldInitializer();
    private final String catalogId;
    private final String databaseName;
    private final String tableName;
    private final Map<String, Map<String, String>> storageOptimizerConfig;

    private UpdateTableStorageOptimizerRequest(BuilderImpl builder) {
        super(builder);
        this.catalogId = builder.catalogId;
        this.databaseName = builder.databaseName;
        this.tableName = builder.tableName;
        this.storageOptimizerConfig = builder.storageOptimizerConfig;
    }

    public final String catalogId() {
        return this.catalogId;
    }

    public final String databaseName() {
        return this.databaseName;
    }

    public final String tableName() {
        return this.tableName;
    }

    public final Map<OptimizerType, Map<String, String>> storageOptimizerConfig() {
        return StorageOptimizerConfigMapCopier.copyStringToEnum(this.storageOptimizerConfig);
    }

    public final boolean hasStorageOptimizerConfig() {
        return this.storageOptimizerConfig != null && !(this.storageOptimizerConfig instanceof SdkAutoConstructMap);
    }

    public final Map<String, Map<String, String>> storageOptimizerConfigAsStrings() {
        return this.storageOptimizerConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.catalogId());
        hashCode = 31 * hashCode + Objects.hashCode(this.databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(this.tableName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStorageOptimizerConfig() ? this.storageOptimizerConfigAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateTableStorageOptimizerRequest)) {
            return false;
        }
        UpdateTableStorageOptimizerRequest other = (UpdateTableStorageOptimizerRequest)obj;
        return Objects.equals(this.catalogId(), other.catalogId()) && Objects.equals(this.databaseName(), other.databaseName()) && Objects.equals(this.tableName(), other.tableName()) && this.hasStorageOptimizerConfig() == other.hasStorageOptimizerConfig() && Objects.equals(this.storageOptimizerConfigAsStrings(), other.storageOptimizerConfigAsStrings());
    }

    public final String toString() {
        return ToString.builder("UpdateTableStorageOptimizerRequest").add("CatalogId", this.catalogId()).add("DatabaseName", this.databaseName()).add("TableName", this.tableName()).add("StorageOptimizerConfig", this.hasStorageOptimizerConfig() ? this.storageOptimizerConfigAsStrings() : null).build();
    }

    @Override
    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CatalogId": {
                return Optional.ofNullable(clazz.cast(this.catalogId()));
            }
            case "DatabaseName": {
                return Optional.ofNullable(clazz.cast(this.databaseName()));
            }
            case "TableName": {
                return Optional.ofNullable(clazz.cast(this.tableName()));
            }
            case "StorageOptimizerConfig": {
                return Optional.ofNullable(clazz.cast(this.storageOptimizerConfigAsStrings()));
            }
        }
        return Optional.empty();
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<Object>> map = new HashMap<String, SdkField<Object>>();
        map.put("CatalogId", CATALOG_ID_FIELD);
        map.put("DatabaseName", DATABASE_NAME_FIELD);
        map.put("TableName", TABLE_NAME_FIELD);
        map.put("StorageOptimizerConfig", STORAGE_OPTIMIZER_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateTableStorageOptimizerRequest, T> g) {
        return obj -> g.apply((UpdateTableStorageOptimizerRequest)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LakeFormationRequest.BuilderImpl
    implements Builder {
        private String catalogId;
        private String databaseName;
        private String tableName;
        private Map<String, Map<String, String>> storageOptimizerConfig = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateTableStorageOptimizerRequest model) {
            super(model);
            this.catalogId(model.catalogId);
            this.databaseName(model.databaseName);
            this.tableName(model.tableName);
            this.storageOptimizerConfigWithStrings(model.storageOptimizerConfig);
        }

        public final String getCatalogId() {
            return this.catalogId;
        }

        public final void setCatalogId(String catalogId) {
            this.catalogId = catalogId;
        }

        @Override
        public final Builder catalogId(String catalogId) {
            this.catalogId = catalogId;
            return this;
        }

        public final String getDatabaseName() {
            return this.databaseName;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final String getTableName() {
            return this.tableName;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final Map<String, ? extends Map<String, String>> getStorageOptimizerConfig() {
            if (this.storageOptimizerConfig instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.storageOptimizerConfig;
        }

        public final void setStorageOptimizerConfig(Map<String, ? extends Map<String, String>> storageOptimizerConfig) {
            this.storageOptimizerConfig = StorageOptimizerConfigMapCopier.copy(storageOptimizerConfig);
        }

        @Override
        public final Builder storageOptimizerConfigWithStrings(Map<String, ? extends Map<String, String>> storageOptimizerConfig) {
            this.storageOptimizerConfig = StorageOptimizerConfigMapCopier.copy(storageOptimizerConfig);
            return this;
        }

        @Override
        public final Builder storageOptimizerConfig(Map<OptimizerType, ? extends Map<String, String>> storageOptimizerConfig) {
            this.storageOptimizerConfig = StorageOptimizerConfigMapCopier.copyEnumToString(storageOptimizerConfig);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateTableStorageOptimizerRequest build() {
            return new UpdateTableStorageOptimizerRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends LakeFormationRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateTableStorageOptimizerRequest> {
        public Builder catalogId(String var1);

        public Builder databaseName(String var1);

        public Builder tableName(String var1);

        public Builder storageOptimizerConfigWithStrings(Map<String, ? extends Map<String, String>> var1);

        public Builder storageOptimizerConfig(Map<OptimizerType, ? extends Map<String, String>> var1);

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

