/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lakeformation.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.lakeformation.LakeFormationAsyncClient;
import software.amazon.awssdk.services.lakeformation.internal.UserAgentUtils;
import software.amazon.awssdk.services.lakeformation.model.GetEffectivePermissionsForPathRequest;
import software.amazon.awssdk.services.lakeformation.model.GetEffectivePermissionsForPathResponse;

public class GetEffectivePermissionsForPathPublisher
implements SdkPublisher<GetEffectivePermissionsForPathResponse> {
    private final LakeFormationAsyncClient client;
    private final GetEffectivePermissionsForPathRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetEffectivePermissionsForPathPublisher(LakeFormationAsyncClient client, GetEffectivePermissionsForPathRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetEffectivePermissionsForPathPublisher(LakeFormationAsyncClient client, GetEffectivePermissionsForPathRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetEffectivePermissionsForPathResponseFetcher();
    }

    @Override
    public void subscribe(Subscriber<? super GetEffectivePermissionsForPathResponse> subscriber) {
        subscriber.onSubscribe(((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class GetEffectivePermissionsForPathResponseFetcher
    implements AsyncPageFetcher<GetEffectivePermissionsForPathResponse> {
        private GetEffectivePermissionsForPathResponseFetcher() {
        }

        @Override
        public boolean hasNextPage(GetEffectivePermissionsForPathResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable(previousPage.nextToken());
        }

        @Override
        public CompletableFuture<GetEffectivePermissionsForPathResponse> nextPage(GetEffectivePermissionsForPathResponse previousPage) {
            if (previousPage == null) {
                return GetEffectivePermissionsForPathPublisher.this.client.getEffectivePermissionsForPath(GetEffectivePermissionsForPathPublisher.this.firstRequest);
            }
            return GetEffectivePermissionsForPathPublisher.this.client.getEffectivePermissionsForPath((GetEffectivePermissionsForPathRequest)GetEffectivePermissionsForPathPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build());
        }
    }
}

