/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lakeformation.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.lakeformation.LakeFormationClient;
import software.amazon.awssdk.services.lakeformation.internal.UserAgentUtils;
import software.amazon.awssdk.services.lakeformation.model.SearchDatabasesByLfTagsRequest;
import software.amazon.awssdk.services.lakeformation.model.SearchDatabasesByLfTagsResponse;
import software.amazon.awssdk.services.lakeformation.model.TaggedDatabase;

public class SearchDatabasesByLFTagsIterable
implements SdkIterable<SearchDatabasesByLfTagsResponse> {
    private final LakeFormationClient client;
    private final SearchDatabasesByLfTagsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public SearchDatabasesByLFTagsIterable(LakeFormationClient client, SearchDatabasesByLfTagsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new SearchDatabasesByLfTagsResponseFetcher();
    }

    @Override
    public Iterator<SearchDatabasesByLfTagsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<TaggedDatabase> databaseList() {
        Function<SearchDatabasesByLfTagsResponse, Iterator> getIterator = response -> {
            if (response != null && response.databaseList() != null) {
                return response.databaseList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable(this).itemIteratorFunction(getIterator).build();
    }

    private class SearchDatabasesByLfTagsResponseFetcher
    implements SyncPageFetcher<SearchDatabasesByLfTagsResponse> {
        private SearchDatabasesByLfTagsResponseFetcher() {
        }

        @Override
        public boolean hasNextPage(SearchDatabasesByLfTagsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable(previousPage.nextToken());
        }

        @Override
        public SearchDatabasesByLfTagsResponse nextPage(SearchDatabasesByLfTagsResponse previousPage) {
            if (previousPage == null) {
                return SearchDatabasesByLFTagsIterable.this.client.searchDatabasesByLFTags(SearchDatabasesByLFTagsIterable.this.firstRequest);
            }
            return SearchDatabasesByLFTagsIterable.this.client.searchDatabasesByLFTags((SearchDatabasesByLfTagsRequest)SearchDatabasesByLFTagsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build());
        }
    }
}

