/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lakeformation.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.lakeformation.LakeFormationAsyncClient;
import software.amazon.awssdk.services.lakeformation.internal.UserAgentUtils;
import software.amazon.awssdk.services.lakeformation.model.SearchTablesByLfTagsRequest;
import software.amazon.awssdk.services.lakeformation.model.SearchTablesByLfTagsResponse;
import software.amazon.awssdk.services.lakeformation.model.TaggedTable;

public class SearchTablesByLFTagsPublisher
implements SdkPublisher<SearchTablesByLfTagsResponse> {
    private final LakeFormationAsyncClient client;
    private final SearchTablesByLfTagsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public SearchTablesByLFTagsPublisher(LakeFormationAsyncClient client, SearchTablesByLfTagsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private SearchTablesByLFTagsPublisher(LakeFormationAsyncClient client, SearchTablesByLfTagsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new SearchTablesByLfTagsResponseFetcher();
    }

    @Override
    public void subscribe(Subscriber<? super SearchTablesByLfTagsResponse> subscriber) {
        subscriber.onSubscribe(((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<TaggedTable> tableList() {
        Function<SearchTablesByLfTagsResponse, Iterator> getIterator = response -> {
            if (response != null && response.tableList() != null) {
                return response.tableList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher(new SearchTablesByLfTagsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class SearchTablesByLfTagsResponseFetcher
    implements AsyncPageFetcher<SearchTablesByLfTagsResponse> {
        private SearchTablesByLfTagsResponseFetcher() {
        }

        @Override
        public boolean hasNextPage(SearchTablesByLfTagsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable(previousPage.nextToken());
        }

        @Override
        public CompletableFuture<SearchTablesByLfTagsResponse> nextPage(SearchTablesByLfTagsResponse previousPage) {
            if (previousPage == null) {
                return SearchTablesByLFTagsPublisher.this.client.searchTablesByLFTags(SearchTablesByLFTagsPublisher.this.firstRequest);
            }
            return SearchTablesByLFTagsPublisher.this.client.searchTablesByLFTags((SearchTablesByLfTagsRequest)SearchTablesByLFTagsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build());
        }
    }
}

