/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.internal.signing;

import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.auth.signer.AwsSignerExecutionAttribute;
import software.amazon.awssdk.awscore.AwsExecutionAttribute;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.defaultsmode.DefaultsMode;
import software.amazon.awssdk.awscore.endpoint.AwsClientEndpointProvider;
import software.amazon.awssdk.awscore.internal.AwsExecutionContextBuilder;
import software.amazon.awssdk.awscore.internal.defaultsmode.DefaultsModeConfiguration;
import software.amazon.awssdk.awscore.presigner.PresignRequest;
import software.amazon.awssdk.awscore.presigner.PresignedRequest;
import software.amazon.awssdk.core.ClientType;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SelectedAuthScheme;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.http.ExecutionContext;
import software.amazon.awssdk.core.interceptor.ClasspathInterceptorChainFactory;
import software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import software.amazon.awssdk.core.interceptor.ExecutionInterceptor;
import software.amazon.awssdk.core.interceptor.ExecutionInterceptorChain;
import software.amazon.awssdk.core.interceptor.InterceptorContext;
import software.amazon.awssdk.core.interceptor.SdkExecutionAttribute;
import software.amazon.awssdk.core.interceptor.SdkInternalExecutionAttribute;
import software.amazon.awssdk.core.signer.Presigner;
import software.amazon.awssdk.core.signer.Signer;
import software.amazon.awssdk.core.sync.RequestBody;
import software.amazon.awssdk.http.ContentStreamProvider;
import software.amazon.awssdk.http.SdkHttpFullRequest;
import software.amazon.awssdk.http.SdkHttpMethod;
import software.amazon.awssdk.http.SdkHttpRequest;
import software.amazon.awssdk.http.auth.aws.scheme.AwsV4AuthScheme;
import software.amazon.awssdk.http.auth.aws.scheme.AwsV4aAuthScheme;
import software.amazon.awssdk.http.auth.aws.signer.AwsV4FamilyHttpSigner;
import software.amazon.awssdk.http.auth.spi.scheme.AuthScheme;
import software.amazon.awssdk.http.auth.spi.scheme.AuthSchemeOption;
import software.amazon.awssdk.http.auth.spi.signer.HttpSigner;
import software.amazon.awssdk.http.auth.spi.signer.SignRequest;
import software.amazon.awssdk.http.auth.spi.signer.SignedRequest;
import software.amazon.awssdk.identity.spi.AwsCredentialsIdentity;
import software.amazon.awssdk.identity.spi.Identity;
import software.amazon.awssdk.identity.spi.IdentityProvider;
import software.amazon.awssdk.identity.spi.IdentityProviders;
import software.amazon.awssdk.protocols.xml.AwsS3ProtocolFactory;
import software.amazon.awssdk.regions.ServiceMetadataAdvancedOption;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.S3Configuration;
import software.amazon.awssdk.services.s3.auth.scheme.S3AuthSchemeProvider;
import software.amazon.awssdk.services.s3.auth.scheme.internal.S3AuthSchemeInterceptor;
import software.amazon.awssdk.services.s3.endpoints.S3ClientContextParams;
import software.amazon.awssdk.services.s3.endpoints.S3EndpointProvider;
import software.amazon.awssdk.services.s3.endpoints.internal.S3RequestSetEndpointInterceptor;
import software.amazon.awssdk.services.s3.endpoints.internal.S3ResolveEndpointInterceptor;
import software.amazon.awssdk.services.s3.internal.endpoints.UseGlobalEndpointResolver;
import software.amazon.awssdk.services.s3.internal.s3express.S3ExpressAuthSchemeProvider;
import software.amazon.awssdk.services.s3.internal.signing.DefaultSdkPresigner;
import software.amazon.awssdk.services.s3.model.AbortMultipartUploadRequest;
import software.amazon.awssdk.services.s3.model.CompleteMultipartUploadRequest;
import software.amazon.awssdk.services.s3.model.CreateMultipartUploadRequest;
import software.amazon.awssdk.services.s3.model.DeleteObjectRequest;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.HeadBucketRequest;
import software.amazon.awssdk.services.s3.model.HeadObjectRequest;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;
import software.amazon.awssdk.services.s3.model.UploadPartRequest;
import software.amazon.awssdk.services.s3.presigner.S3Presigner;
import software.amazon.awssdk.services.s3.presigner.model.AbortMultipartUploadPresignRequest;
import software.amazon.awssdk.services.s3.presigner.model.CompleteMultipartUploadPresignRequest;
import software.amazon.awssdk.services.s3.presigner.model.CreateMultipartUploadPresignRequest;
import software.amazon.awssdk.services.s3.presigner.model.DeleteObjectPresignRequest;
import software.amazon.awssdk.services.s3.presigner.model.GetObjectPresignRequest;
import software.amazon.awssdk.services.s3.presigner.model.HeadBucketPresignRequest;
import software.amazon.awssdk.services.s3.presigner.model.HeadObjectPresignRequest;
import software.amazon.awssdk.services.s3.presigner.model.PresignedAbortMultipartUploadRequest;
import software.amazon.awssdk.services.s3.presigner.model.PresignedCompleteMultipartUploadRequest;
import software.amazon.awssdk.services.s3.presigner.model.PresignedCreateMultipartUploadRequest;
import software.amazon.awssdk.services.s3.presigner.model.PresignedDeleteObjectRequest;
import software.amazon.awssdk.services.s3.presigner.model.PresignedGetObjectRequest;
import software.amazon.awssdk.services.s3.presigner.model.PresignedHeadBucketRequest;
import software.amazon.awssdk.services.s3.presigner.model.PresignedHeadObjectRequest;
import software.amazon.awssdk.services.s3.presigner.model.PresignedPutObjectRequest;
import software.amazon.awssdk.services.s3.presigner.model.PresignedUploadPartRequest;
import software.amazon.awssdk.services.s3.presigner.model.PutObjectPresignRequest;
import software.amazon.awssdk.services.s3.presigner.model.UploadPartPresignRequest;
import software.amazon.awssdk.services.s3.s3express.S3ExpressAuthScheme;
import software.amazon.awssdk.services.s3.transform.AbortMultipartUploadRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.CompleteMultipartUploadRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.CreateMultipartUploadRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.DeleteObjectRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.GetObjectRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.HeadBucketRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.HeadObjectRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.PutObjectRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.UploadPartRequestMarshaller;
import software.amazon.awssdk.utils.AttributeMap;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.CompletableFutureUtils;
import software.amazon.awssdk.utils.FunctionalUtils;
import software.amazon.awssdk.utils.IoUtils;
import software.amazon.awssdk.utils.Logger;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public final class DefaultS3Presigner
extends DefaultSdkPresigner
implements S3Presigner {
    private static final Logger log = Logger.loggerFor(DefaultS3Presigner.class);
    private static final String SERVICE_NAME = "s3";
    private static final String SIGNING_NAME = "s3";
    private final S3Configuration serviceConfiguration;
    private final List<ExecutionInterceptor> clientInterceptors;
    private final GetObjectRequestMarshaller getObjectRequestMarshaller;
    private final HeadObjectRequestMarshaller headObjectRequestMarshaller;
    private final HeadBucketRequestMarshaller headBucketRequestMarshaller;
    private final PutObjectRequestMarshaller putObjectRequestMarshaller;
    private final CreateMultipartUploadRequestMarshaller createMultipartUploadRequestMarshaller;
    private final UploadPartRequestMarshaller uploadPartRequestMarshaller;
    private final DeleteObjectRequestMarshaller deleteObjectRequestMarshaller;
    private final CompleteMultipartUploadRequestMarshaller completeMultipartUploadRequestMarshaller;
    private final AbortMultipartUploadRequestMarshaller abortMultipartUploadRequestMarshaller;
    private final SdkClientConfiguration clientConfiguration;
    private final UseGlobalEndpointResolver useGlobalEndpointResolver;
    private final Boolean disableS3ExpressSessionAuth;
    private final S3Client s3Client;

    private DefaultS3Presigner(Builder b) {
        super(b);
        S3Configuration serviceConfiguration = b.serviceConfiguration != null ? b.serviceConfiguration : (S3Configuration)S3Configuration.builder().profileFile(this.profileFileSupplier()).profileName(this.profileName()).checksumValidationEnabled(false).build();
        S3Configuration.Builder serviceConfigBuilder = serviceConfiguration.toBuilder();
        if (serviceConfiguration.checksumValidationEnabled()) {
            log.debug(() -> "The provided S3Configuration has ChecksumValidationEnabled set to true. Please note that the pre-signed request can't be executed using a web browser if checksum validation is enabled.");
        }
        if (this.dualstackEnabled() != null && serviceConfigBuilder.dualstackEnabled() != null) {
            throw new IllegalStateException("Dualstack has been configured in both S3Configuration and at the presigner/global level. Please limit dualstack configuration to one location.");
        }
        if (this.dualstackEnabled() != null) {
            serviceConfigBuilder.dualstackEnabled(this.dualstackEnabled());
        }
        this.disableS3ExpressSessionAuth = b.disableS3ExpressSessionAuth;
        this.s3Client = b.s3Client;
        this.serviceConfiguration = (S3Configuration)serviceConfigBuilder.build();
        this.clientInterceptors = this.initializeInterceptors();
        this.clientConfiguration = this.createClientConfiguration();
        AwsS3ProtocolFactory protocolFactory = ((AwsS3ProtocolFactory.Builder)AwsS3ProtocolFactory.builder().clientConfiguration(this.clientConfiguration)).build();
        this.getObjectRequestMarshaller = new GetObjectRequestMarshaller(protocolFactory);
        this.headObjectRequestMarshaller = new HeadObjectRequestMarshaller(protocolFactory);
        this.headBucketRequestMarshaller = new HeadBucketRequestMarshaller(protocolFactory);
        this.putObjectRequestMarshaller = new PutObjectRequestMarshaller(protocolFactory);
        this.createMultipartUploadRequestMarshaller = new CreateMultipartUploadRequestMarshaller(protocolFactory);
        this.uploadPartRequestMarshaller = new UploadPartRequestMarshaller(protocolFactory);
        this.deleteObjectRequestMarshaller = new DeleteObjectRequestMarshaller(protocolFactory);
        this.completeMultipartUploadRequestMarshaller = new CompleteMultipartUploadRequestMarshaller(protocolFactory);
        this.abortMultipartUploadRequestMarshaller = new AbortMultipartUploadRequestMarshaller(protocolFactory);
        this.useGlobalEndpointResolver = this.createUseGlobalEndpointResolver();
    }

    public static S3Presigner.Builder builder() {
        return new Builder();
    }

    private List<ExecutionInterceptor> initializeInterceptors() {
        ClasspathInterceptorChainFactory interceptorFactory = new ClasspathInterceptorChainFactory();
        List<ExecutionInterceptor> s3Interceptors = interceptorFactory.getInterceptors("software/amazon/awssdk/services/s3/execution.interceptors");
        ArrayList<ExecutionInterceptor> additionalInterceptors = new ArrayList<ExecutionInterceptor>();
        additionalInterceptors.add(new S3AuthSchemeInterceptor());
        additionalInterceptors.add(new S3ResolveEndpointInterceptor());
        additionalInterceptors.add(new S3RequestSetEndpointInterceptor());
        s3Interceptors = CollectionUtils.mergeLists(s3Interceptors, additionalInterceptors);
        return CollectionUtils.mergeLists(interceptorFactory.getGlobalInterceptors(), s3Interceptors);
    }

    private SdkClientConfiguration createClientConfiguration() {
        AwsClientEndpointProvider endpointProvider = AwsClientEndpointProvider.builder().clientEndpointOverride(this.endpointOverride()).serviceEndpointOverrideEnvironmentVariable("AWS_ENDPOINT_URL_S3").serviceEndpointOverrideSystemProperty("aws.endpointUrlS3").serviceProfileProperty("s3").serviceEndpointPrefix("s3").defaultProtocol("https").region(this.region()).profileFile(this.profileFileSupplier()).profileName(this.profileName()).dualstackEnabled(this.serviceConfiguration.dualstackEnabled()).fipsEnabled(this.fipsEnabled()).build();
        endpointProvider.clientEndpoint();
        return SdkClientConfiguration.builder().option(SdkClientOption.CLIENT_ENDPOINT_PROVIDER, endpointProvider).build();
    }

    @Override
    public PresignedGetObjectRequest presignGetObject(GetObjectPresignRequest request) {
        return this.presign(PresignedGetObjectRequest.builder(), request, request.getObjectRequest(), GetObjectRequest.class, this.getObjectRequestMarshaller::marshall, "GetObject").build();
    }

    @Override
    public PresignedHeadObjectRequest presignHeadObject(HeadObjectPresignRequest request) {
        return this.presign(PresignedHeadObjectRequest.builder(), request, request.headObjectRequest(), HeadObjectRequest.class, this.headObjectRequestMarshaller::marshall, "HeadObject").build();
    }

    @Override
    public PresignedHeadBucketRequest presignHeadBucket(HeadBucketPresignRequest request) {
        return this.presign(PresignedHeadBucketRequest.builder(), request, request.headBucketRequest(), HeadBucketRequest.class, this.headBucketRequestMarshaller::marshall, "HeadBucket").build();
    }

    @Override
    public PresignedPutObjectRequest presignPutObject(PutObjectPresignRequest request) {
        return this.presign(PresignedPutObjectRequest.builder(), request, request.putObjectRequest(), PutObjectRequest.class, this.putObjectRequestMarshaller::marshall, "PutObject").build();
    }

    @Override
    public PresignedDeleteObjectRequest presignDeleteObject(DeleteObjectPresignRequest request) {
        return this.presign(PresignedDeleteObjectRequest.builder(), request, request.deleteObjectRequest(), DeleteObjectRequest.class, this.deleteObjectRequestMarshaller::marshall, "DeleteObject").build();
    }

    @Override
    public PresignedCreateMultipartUploadRequest presignCreateMultipartUpload(CreateMultipartUploadPresignRequest request) {
        return this.presign(PresignedCreateMultipartUploadRequest.builder(), request, request.createMultipartUploadRequest(), CreateMultipartUploadRequest.class, this.createMultipartUploadRequestMarshaller::marshall, "CreateMultipartUpload").build();
    }

    @Override
    public PresignedUploadPartRequest presignUploadPart(UploadPartPresignRequest request) {
        return this.presign(PresignedUploadPartRequest.builder(), request, request.uploadPartRequest(), UploadPartRequest.class, this.uploadPartRequestMarshaller::marshall, "UploadPart").build();
    }

    @Override
    public PresignedCompleteMultipartUploadRequest presignCompleteMultipartUpload(CompleteMultipartUploadPresignRequest request) {
        return this.presign(PresignedCompleteMultipartUploadRequest.builder(), request, request.completeMultipartUploadRequest(), CompleteMultipartUploadRequest.class, this.completeMultipartUploadRequestMarshaller::marshall, "CompleteMultipartUpload").build();
    }

    @Override
    public PresignedAbortMultipartUploadRequest presignAbortMultipartUpload(AbortMultipartUploadPresignRequest request) {
        return this.presign(PresignedAbortMultipartUploadRequest.builder(), request, request.abortMultipartUploadRequest(), AbortMultipartUploadRequest.class, this.abortMultipartUploadRequestMarshaller::marshall, "AbortMultipartUpload").build();
    }

    protected S3Configuration serviceConfiguration() {
        return this.serviceConfiguration;
    }

    private <T extends PresignedRequest.Builder, U> T presign(T presignedRequest, PresignRequest presignRequest, SdkRequest requestToPresign, Class<U> requestToPresignType, Function<U, SdkHttpFullRequest> requestMarshaller, String operationName) {
        Instant signingInstant = Instant.now();
        Clock signingClock = Clock.fixed(signingInstant, ZoneOffset.UTC);
        Duration expirationDuration = presignRequest.signatureDuration();
        Instant expiration = signingInstant.plus(expirationDuration);
        ExecutionContext execCtx = this.invokeInterceptorsAndCreateExecutionContext(requestToPresign, operationName, expiration, signingClock);
        this.callBeforeMarshallingHooks(execCtx);
        this.marshalRequestAndUpdateContext(execCtx, requestToPresignType, requestMarshaller);
        this.callAfterMarshallingHooks(execCtx);
        this.addRequestLevelHeadersAndQueryParameters(execCtx);
        this.callModifyHttpRequestHooksAndUpdateContext(execCtx);
        SdkHttpFullRequest httpRequest = this.getHttpFullRequest(execCtx);
        SdkHttpFullRequest signedHttpRequest = execCtx.signer() != null ? this.presignRequest(execCtx, httpRequest) : this.sraPresignRequest(execCtx, httpRequest, signingClock, expirationDuration);
        this.initializePresignedRequest(presignedRequest, signedHttpRequest, expiration);
        return presignedRequest;
    }

    private ExecutionContext invokeInterceptorsAndCreateExecutionContext(SdkRequest sdkRequest, String operationName, Instant expiration, Clock signingClock) {
        ExecutionAttributes executionAttributes = new ExecutionAttributes().putAttribute(AwsSignerExecutionAttribute.SERVICE_SIGNING_NAME, "s3").putAttribute(AwsExecutionAttribute.AWS_REGION, this.region()).putAttribute(AwsSignerExecutionAttribute.SIGNING_REGION, this.region()).putAttribute(SdkInternalExecutionAttribute.IS_FULL_DUPLEX, false).putAttribute(SdkExecutionAttribute.CLIENT_TYPE, ClientType.SYNC).putAttribute(SdkExecutionAttribute.SERVICE_NAME, "s3").putAttribute(SdkExecutionAttribute.OPERATION_NAME, operationName).putAttribute(SdkExecutionAttribute.SERVICE_CONFIG, this.serviceConfiguration()).putAttribute(AwsSignerExecutionAttribute.PRESIGNER_EXPIRATION, expiration).putAttribute(AwsSignerExecutionAttribute.SIGNING_CLOCK, signingClock).putAttribute(SdkInternalExecutionAttribute.CLIENT_ENDPOINT_PROVIDER, this.clientConfiguration.option(SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).putAttribute(AwsExecutionAttribute.FIPS_ENDPOINT_ENABLED, this.fipsEnabled()).putAttribute(AwsExecutionAttribute.DUALSTACK_ENDPOINT_ENABLED, this.serviceConfiguration.dualstackEnabled()).putAttribute(SdkInternalExecutionAttribute.ENDPOINT_PROVIDER, S3EndpointProvider.defaultProvider()).putAttribute(AwsExecutionAttribute.USE_GLOBAL_ENDPOINT, this.useGlobalEndpointResolver.resolve(this.region())).putAttribute(SdkInternalExecutionAttribute.AUTH_SCHEME_RESOLVER, S3ExpressAuthSchemeProvider.create(S3AuthSchemeProvider.defaultProvider())).putAttribute(SdkInternalExecutionAttribute.AUTH_SCHEMES, this.authSchemes()).putAttribute(SdkInternalExecutionAttribute.IDENTITY_PROVIDERS, this.resolveIdentityProviders(sdkRequest));
        Boolean resolvedDisableS3ExpressSessionAuth = this.disableS3ExpressSessionAuth;
        if (this.s3Client != null) {
            executionAttributes.putAttribute(SdkInternalExecutionAttribute.SDK_CLIENT, this.s3Client);
        } else {
            resolvedDisableS3ExpressSessionAuth = Boolean.TRUE;
        }
        AttributeMap clientContextParams = this.createClientContextParams(resolvedDisableS3ExpressSessionAuth);
        executionAttributes.putAttribute(SdkInternalExecutionAttribute.CLIENT_CONTEXT_PARAMS, clientContextParams);
        ExecutionInterceptorChain executionInterceptorChain = new ExecutionInterceptorChain(this.clientInterceptors);
        InterceptorContext interceptorContext = InterceptorContext.builder().request(sdkRequest).build();
        interceptorContext = AwsExecutionContextBuilder.runInitialInterceptors(interceptorContext, executionAttributes, executionInterceptorChain);
        Signer signer = sdkRequest.overrideConfiguration().flatMap(RequestOverrideConfiguration::signer).orElse(null);
        return ExecutionContext.builder().interceptorChain(executionInterceptorChain).interceptorContext(interceptorContext).executionAttributes(executionAttributes).signer(signer).build();
    }

    private IdentityProviders resolveIdentityProviders(SdkRequest originalRequest) {
        IdentityProvider<? extends AwsCredentialsIdentity> identityProvider = originalRequest.overrideConfiguration().filter(c -> c instanceof AwsRequestOverrideConfiguration).map(c -> (AwsRequestOverrideConfiguration)c).flatMap(AwsRequestOverrideConfiguration::credentialsIdentityProvider).orElse(this.credentialsProvider());
        return (IdentityProviders)IdentityProviders.builder().putIdentityProvider(identityProvider).build();
    }

    private Map<String, AuthScheme<?>> authSchemes() {
        HashMap<String, AuthScheme<AwsCredentialsIdentity>> schemes = new HashMap<String, AuthScheme<AwsCredentialsIdentity>>(3);
        AwsV4AuthScheme awsV4AuthScheme = AwsV4AuthScheme.create();
        schemes.put(awsV4AuthScheme.schemeId(), awsV4AuthScheme);
        AwsV4aAuthScheme awsV4aAuthScheme = AwsV4aAuthScheme.create();
        schemes.put(awsV4aAuthScheme.schemeId(), awsV4aAuthScheme);
        S3ExpressAuthScheme s3ExpressAuthScheme = S3ExpressAuthScheme.create();
        schemes.put(s3ExpressAuthScheme.schemeId(), s3ExpressAuthScheme);
        return Collections.unmodifiableMap(schemes);
    }

    private void callBeforeMarshallingHooks(ExecutionContext execCtx) {
        execCtx.interceptorChain().beforeMarshalling(execCtx.interceptorContext(), execCtx.executionAttributes());
    }

    private <T> void marshalRequestAndUpdateContext(ExecutionContext execCtx, Class<T> requestType, Function<T, SdkHttpFullRequest> requestMarshaller) {
        T sdkRequest = Validate.isInstanceOf(requestType, execCtx.interceptorContext().request(), "Interceptor generated unsupported type (%s) when %s was expected.", execCtx.interceptorContext().request().getClass(), requestType);
        SdkHttpFullRequest marshalledRequest = requestMarshaller.apply(sdkRequest);
        Optional<RequestBody> requestBody = marshalledRequest.contentStreamProvider().map(ContentStreamProvider::newStream).map(is -> FunctionalUtils.invokeSafely(() -> IoUtils.toByteArray(is))).map(RequestBody::fromBytes);
        execCtx.interceptorContext((InterceptorContext)execCtx.interceptorContext().copy(r -> r.httpRequest(marshalledRequest).requestBody(requestBody.orElse(null))));
    }

    private void callAfterMarshallingHooks(ExecutionContext execCtx) {
        execCtx.interceptorChain().afterMarshalling(execCtx.interceptorContext(), execCtx.executionAttributes());
    }

    private void addRequestLevelHeadersAndQueryParameters(ExecutionContext execCtx) {
        SdkHttpRequest httpRequest = execCtx.interceptorContext().httpRequest();
        SdkRequest sdkRequest = execCtx.interceptorContext().request();
        SdkHttpRequest updatedHttpRequest = (SdkHttpRequest)((SdkHttpRequest.Builder)httpRequest.toBuilder()).applyMutation(b -> this.addRequestLevelHeaders((SdkHttpRequest.Builder)b, sdkRequest)).applyMutation(b -> this.addRequestLeveQueryParameters((SdkHttpRequest.Builder)b, sdkRequest)).build();
        execCtx.interceptorContext((InterceptorContext)execCtx.interceptorContext().copy(c -> c.httpRequest(updatedHttpRequest)));
    }

    private void addRequestLevelHeaders(SdkHttpRequest.Builder builder, SdkRequest request) {
        request.overrideConfiguration().ifPresent(overrideConfig -> {
            if (!overrideConfig.headers().isEmpty()) {
                overrideConfig.headers().forEach(builder::putHeader);
            }
        });
    }

    private void addRequestLeveQueryParameters(SdkHttpRequest.Builder builder, SdkRequest request) {
        request.overrideConfiguration().ifPresent(overrideConfig -> {
            if (!overrideConfig.rawQueryParameters().isEmpty()) {
                overrideConfig.rawQueryParameters().forEach(builder::putRawQueryParameter);
            }
        });
    }

    private void callModifyHttpRequestHooksAndUpdateContext(ExecutionContext execCtx) {
        execCtx.interceptorContext(execCtx.interceptorChain().modifyHttpRequestAndHttpContent(execCtx.interceptorContext(), execCtx.executionAttributes()));
    }

    private SdkHttpFullRequest getHttpFullRequest(ExecutionContext execCtx) {
        SdkHttpRequest requestFromInterceptor = execCtx.interceptorContext().httpRequest();
        Optional<RequestBody> bodyFromInterceptor = execCtx.interceptorContext().requestBody();
        return SdkHttpFullRequest.builder().method(requestFromInterceptor.method()).protocol(requestFromInterceptor.protocol()).host(requestFromInterceptor.host()).port(requestFromInterceptor.port()).encodedPath(requestFromInterceptor.encodedPath()).applyMutation(r -> {
            requestFromInterceptor.forEachHeader(r::putHeader);
            requestFromInterceptor.forEachRawQueryParameter(r::putRawQueryParameter);
        }).contentStreamProvider(bodyFromInterceptor.map(RequestBody::contentStreamProvider).orElse(null)).build();
    }

    private SdkHttpFullRequest presignRequest(ExecutionContext execCtx, SdkHttpFullRequest request) {
        Presigner presigner = Validate.isInstanceOf(Presigner.class, execCtx.signer(), "Configured signer (%s) does not support presigning (must implement %s).", execCtx.signer().getClass(), Presigner.class);
        return presigner.presign(request, execCtx.executionAttributes());
    }

    private SdkHttpFullRequest sraPresignRequest(ExecutionContext execCtx, SdkHttpFullRequest request, Clock signingClock, Duration expirationDuration) {
        SelectedAuthScheme<?> selectedAuthScheme = execCtx.executionAttributes().getAttribute(SdkInternalExecutionAttribute.SELECTED_AUTH_SCHEME);
        return this.doSraPresign(request, selectedAuthScheme, signingClock, expirationDuration);
    }

    private <T extends Identity> SdkHttpFullRequest doSraPresign(SdkHttpFullRequest request, SelectedAuthScheme<T> selectedAuthScheme, Clock signingClock, Duration expirationDuration) {
        CompletableFuture<T> identityFuture = selectedAuthScheme.identity();
        Identity identity = (Identity)CompletableFutureUtils.joinLikeSync(identityFuture);
        SignRequest.Builder signRequestBuilder = (SignRequest.Builder)((SignRequest.Builder)((SignRequest.Builder)((SignRequest.Builder)((SignRequest.Builder)((SignRequest.Builder)((SignRequest.Builder)((SignRequest.Builder)SignRequest.builder(identity).putProperty(AwsV4FamilyHttpSigner.AUTH_LOCATION, AwsV4FamilyHttpSigner.AuthLocation.QUERY_STRING)).putProperty(AwsV4FamilyHttpSigner.PAYLOAD_SIGNING_ENABLED, false)).putProperty(AwsV4FamilyHttpSigner.EXPIRATION_DURATION, expirationDuration)).putProperty(HttpSigner.SIGNING_CLOCK, signingClock)).putProperty(AwsV4FamilyHttpSigner.NORMALIZE_PATH, false)).putProperty(AwsV4FamilyHttpSigner.DOUBLE_URL_ENCODE, false)).request(request)).payload(request.contentStreamProvider().orElse(null));
        AuthSchemeOption authSchemeOption = selectedAuthScheme.authSchemeOption();
        authSchemeOption.forEachSignerProperty(signRequestBuilder::putProperty);
        HttpSigner<T> signer = selectedAuthScheme.signer();
        SignedRequest signedRequest = signer.sign((SignRequest)signRequestBuilder.build());
        return this.toSdkHttpFullRequest(signedRequest);
    }

    private SdkHttpFullRequest toSdkHttpFullRequest(SignedRequest signedRequest) {
        SdkHttpRequest request = signedRequest.request();
        return SdkHttpFullRequest.builder().contentStreamProvider(signedRequest.payload().orElse(null)).protocol(request.protocol()).method(request.method()).host(request.host()).port(request.port()).encodedPath(request.encodedPath()).applyMutation(r -> request.forEachHeader(r::putHeader)).applyMutation(r -> request.forEachRawQueryParameter(r::putRawQueryParameter)).build();
    }

    private void initializePresignedRequest(PresignedRequest.Builder presignedRequest, SdkHttpFullRequest signedHttpRequest, Instant expiration) {
        SdkBytes signedPayload = signedHttpRequest.contentStreamProvider().map(p -> SdkBytes.fromInputStream(p.newStream())).orElse(null);
        List<String> signedHeadersQueryParam = signedHttpRequest.firstMatchingRawQueryParameters("X-Amz-SignedHeaders");
        Validate.validState(!signedHeadersQueryParam.isEmpty(), "Only SigV4 signers are supported at this time, but the configured signer did not seem to generate a SigV4 signature.", new Object[0]);
        Map<String, List<String>> signedHeaders = signedHeadersQueryParam.stream().flatMap(h -> Stream.of(h.split(";"))).collect(Collectors.toMap(h -> h, h -> signedHttpRequest.firstMatchingHeader((String)h).map(Collections::singletonList).orElseGet(ArrayList::new)));
        boolean isBrowserExecutable = signedHttpRequest.method() == SdkHttpMethod.GET && signedPayload == null && (signedHeaders.isEmpty() || signedHeaders.size() == 1 && signedHeaders.containsKey("host"));
        presignedRequest.expiration(expiration).isBrowserExecutable(isBrowserExecutable).httpRequest(signedHttpRequest).signedHeaders(signedHeaders).signedPayload(signedPayload);
    }

    private AttributeMap createClientContextParams(Boolean resolvedDisableS3ExpressSessionAuth) {
        AttributeMap.Builder params = AttributeMap.builder();
        params.put(S3ClientContextParams.USE_ARN_REGION, this.serviceConfiguration.useArnRegionEnabled());
        params.put(S3ClientContextParams.DISABLE_MULTI_REGION_ACCESS_POINTS, !this.serviceConfiguration.multiRegionEnabled());
        params.put(S3ClientContextParams.FORCE_PATH_STYLE, this.serviceConfiguration.pathStyleAccessEnabled());
        params.put(S3ClientContextParams.ACCELERATE, this.serviceConfiguration.accelerateModeEnabled());
        params.put(S3ClientContextParams.DISABLE_S3_EXPRESS_SESSION_AUTH, resolvedDisableS3ExpressSessionAuth);
        return params.build();
    }

    private UseGlobalEndpointResolver createUseGlobalEndpointResolver() {
        String legacyOption = DefaultsModeConfiguration.defaultConfig(DefaultsMode.LEGACY).get(ServiceMetadataAdvancedOption.DEFAULT_S3_US_EAST_1_REGIONAL_ENDPOINT);
        SdkClientConfiguration config = this.clientConfiguration.toBuilder().option(ServiceMetadataAdvancedOption.DEFAULT_S3_US_EAST_1_REGIONAL_ENDPOINT, legacyOption).option(SdkClientOption.PROFILE_FILE_SUPPLIER, this.profileFileSupplier()).option(SdkClientOption.PROFILE_NAME, this.profileName()).build();
        return new UseGlobalEndpointResolver(config);
    }

    @SdkInternalApi
    public static final class Builder
    extends DefaultSdkPresigner.Builder<Builder>
    implements S3Presigner.Builder {
        private S3Configuration serviceConfiguration;
        private Boolean disableS3ExpressSessionAuth;
        private S3Client s3Client;

        private Builder() {
        }

        @Override
        public Builder serviceConfiguration(S3Configuration serviceConfiguration) {
            this.serviceConfiguration = serviceConfiguration;
            return this;
        }

        @Override
        public Builder disableS3ExpressSessionAuth(Boolean disableS3ExpressSessionAuth) {
            this.disableS3ExpressSessionAuth = disableS3ExpressSessionAuth;
            return this;
        }

        @Override
        public Builder s3Client(S3Client s3Client) {
            this.s3Client = s3Client;
            return this;
        }

        @Override
        public S3Presigner build() {
            return new DefaultS3Presigner(this);
        }
    }
}

