/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.RequiredTrait;
import software.amazon.awssdk.services.s3.model.MetadataTableEncryptionConfiguration;
import software.amazon.awssdk.services.s3.model.RecordExpiration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class JournalTableConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, JournalTableConfiguration> {
    private static final SdkField<RecordExpiration> RECORD_EXPIRATION_FIELD = SdkField.builder(MarshallingType.SDK_POJO).memberName("RecordExpiration").getter(JournalTableConfiguration.getter(JournalTableConfiguration::recordExpiration)).setter(JournalTableConfiguration.setter(Builder::recordExpiration)).constructor(RecordExpiration::builder).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecordExpiration").unmarshallLocationName("RecordExpiration").build(), RequiredTrait.create()).build();
    private static final SdkField<MetadataTableEncryptionConfiguration> ENCRYPTION_CONFIGURATION_FIELD = SdkField.builder(MarshallingType.SDK_POJO).memberName("EncryptionConfiguration").getter(JournalTableConfiguration.getter(JournalTableConfiguration::encryptionConfiguration)).setter(JournalTableConfiguration.setter(Builder::encryptionConfiguration)).constructor(MetadataTableEncryptionConfiguration::builder).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionConfiguration").unmarshallLocationName("EncryptionConfiguration").build()).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RECORD_EXPIRATION_FIELD, ENCRYPTION_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = JournalTableConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final RecordExpiration recordExpiration;
    private final MetadataTableEncryptionConfiguration encryptionConfiguration;

    private JournalTableConfiguration(BuilderImpl builder) {
        this.recordExpiration = builder.recordExpiration;
        this.encryptionConfiguration = builder.encryptionConfiguration;
    }

    public final RecordExpiration recordExpiration() {
        return this.recordExpiration;
    }

    public final MetadataTableEncryptionConfiguration encryptionConfiguration() {
        return this.encryptionConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.recordExpiration());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JournalTableConfiguration)) {
            return false;
        }
        JournalTableConfiguration other = (JournalTableConfiguration)obj;
        return Objects.equals(this.recordExpiration(), other.recordExpiration()) && Objects.equals(this.encryptionConfiguration(), other.encryptionConfiguration());
    }

    public final String toString() {
        return ToString.builder("JournalTableConfiguration").add("RecordExpiration", this.recordExpiration()).add("EncryptionConfiguration", this.encryptionConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RecordExpiration": {
                return Optional.ofNullable(clazz.cast(this.recordExpiration()));
            }
            case "EncryptionConfiguration": {
                return Optional.ofNullable(clazz.cast(this.encryptionConfiguration()));
            }
        }
        return Optional.empty();
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<SdkPojo>> map = new HashMap<String, SdkField<SdkPojo>>();
        map.put("RecordExpiration", RECORD_EXPIRATION_FIELD);
        map.put("EncryptionConfiguration", ENCRYPTION_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<JournalTableConfiguration, T> g) {
        return obj -> g.apply((JournalTableConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private RecordExpiration recordExpiration;
        private MetadataTableEncryptionConfiguration encryptionConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(JournalTableConfiguration model) {
            this.recordExpiration(model.recordExpiration);
            this.encryptionConfiguration(model.encryptionConfiguration);
        }

        public final RecordExpiration.Builder getRecordExpiration() {
            return this.recordExpiration != null ? this.recordExpiration.toBuilder() : null;
        }

        public final void setRecordExpiration(RecordExpiration.BuilderImpl recordExpiration) {
            this.recordExpiration = recordExpiration != null ? recordExpiration.build() : null;
        }

        @Override
        public final Builder recordExpiration(RecordExpiration recordExpiration) {
            this.recordExpiration = recordExpiration;
            return this;
        }

        public final MetadataTableEncryptionConfiguration.Builder getEncryptionConfiguration() {
            return this.encryptionConfiguration != null ? this.encryptionConfiguration.toBuilder() : null;
        }

        public final void setEncryptionConfiguration(MetadataTableEncryptionConfiguration.BuilderImpl encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration != null ? encryptionConfiguration.build() : null;
        }

        @Override
        public final Builder encryptionConfiguration(MetadataTableEncryptionConfiguration encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration;
            return this;
        }

        @Override
        public JournalTableConfiguration build() {
            return new JournalTableConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, JournalTableConfiguration> {
        public Builder recordExpiration(RecordExpiration var1);

        default public Builder recordExpiration(Consumer<RecordExpiration.Builder> recordExpiration) {
            return this.recordExpiration((RecordExpiration)RecordExpiration.builder().applyMutation(recordExpiration).build());
        }

        public Builder encryptionConfiguration(MetadataTableEncryptionConfiguration var1);

        default public Builder encryptionConfiguration(Consumer<MetadataTableEncryptionConfiguration.Builder> encryptionConfiguration) {
            return this.encryptionConfiguration((MetadataTableEncryptionConfiguration)MetadataTableEncryptionConfiguration.builder().applyMutation(encryptionConfiguration).build());
        }
    }
}

