/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sso.auth.scheme.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.http.auth.aws.signer.AwsV4HttpSigner;
import software.amazon.awssdk.http.auth.spi.scheme.AuthSchemeOption;
import software.amazon.awssdk.services.sso.auth.scheme.SsoAuthSchemeParams;
import software.amazon.awssdk.services.sso.auth.scheme.SsoAuthSchemeProvider;

@SdkInternalApi
public final class DefaultSsoAuthSchemeProvider
implements SsoAuthSchemeProvider {
    private static final DefaultSsoAuthSchemeProvider DEFAULT = new DefaultSsoAuthSchemeProvider();

    private DefaultSsoAuthSchemeProvider() {
    }

    public static DefaultSsoAuthSchemeProvider create() {
        return DEFAULT;
    }

    @Override
    public List<AuthSchemeOption> resolveAuthScheme(SsoAuthSchemeParams params) {
        ArrayList<AuthSchemeOption> options = new ArrayList<AuthSchemeOption>();
        switch (params.operation()) {
            case "GetRoleCredentials": 
            case "ListAccountRoles": 
            case "ListAccounts": 
            case "Logout": {
                options.add((AuthSchemeOption)AuthSchemeOption.builder().schemeId("smithy.api#noAuth").build());
                break;
            }
            default: {
                options.add((AuthSchemeOption)AuthSchemeOption.builder().schemeId("aws.auth#sigv4").putSignerProperty(AwsV4HttpSigner.SERVICE_SIGNING_NAME, "awsssoportal").putSignerProperty(AwsV4HttpSigner.REGION_NAME, params.region().id()).build());
            }
        }
        return Collections.unmodifiableList(options);
    }
}

