/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sso.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sso.model.AccountInfo;
import software.amazon.awssdk.services.sso.model.AccountListTypeCopier;
import software.amazon.awssdk.services.sso.model.SsoResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAccountsResponse
extends SsoResponse
implements ToCopyableBuilder<Builder, ListAccountsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder(MarshallingType.STRING).memberName("nextToken").getter(ListAccountsResponse.getter(ListAccountsResponse::nextToken)).setter(ListAccountsResponse.setter(Builder::nextToken)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();
    private static final SdkField<List<AccountInfo>> ACCOUNT_LIST_FIELD = SdkField.builder(MarshallingType.LIST).memberName("accountList").getter(ListAccountsResponse.getter(ListAccountsResponse::accountList)).setter(ListAccountsResponse.setter(Builder::accountList)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder(MarshallingType.SDK_POJO).constructor(AccountInfo::builder).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()).build()).build()).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, ACCOUNT_LIST_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListAccountsResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<AccountInfo> accountList;

    private ListAccountsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.accountList = builder.accountList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasAccountList() {
        return this.accountList != null && !(this.accountList instanceof SdkAutoConstructList);
    }

    public final List<AccountInfo> accountList() {
        return this.accountList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAccountList() ? this.accountList() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAccountsResponse)) {
            return false;
        }
        ListAccountsResponse other = (ListAccountsResponse)obj;
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasAccountList() == other.hasAccountList() && Objects.equals(this.accountList(), other.accountList());
    }

    public final String toString() {
        return ToString.builder("ListAccountsResponse").add("NextToken", this.nextToken()).add("AccountList", this.hasAccountList() ? this.accountList() : null).build();
    }

    @Override
    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "accountList": {
                return Optional.ofNullable(clazz.cast(this.accountList()));
            }
        }
        return Optional.empty();
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<Object>> map = new HashMap<String, SdkField<Object>>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("accountList", ACCOUNT_LIST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListAccountsResponse, T> g) {
        return obj -> g.apply((ListAccountsResponse)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsoResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<AccountInfo> accountList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListAccountsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.accountList(model.accountList);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<AccountInfo.Builder> getAccountList() {
            List<AccountInfo.Builder> result = AccountListTypeCopier.copyToBuilder(this.accountList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAccountList(Collection<AccountInfo.BuilderImpl> accountList) {
            this.accountList = AccountListTypeCopier.copyFromBuilder(accountList);
        }

        @Override
        public final Builder accountList(Collection<AccountInfo> accountList) {
            this.accountList = AccountListTypeCopier.copy(accountList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountList(AccountInfo ... accountList) {
            this.accountList(Arrays.asList(accountList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountList(Consumer<AccountInfo.Builder> ... accountList) {
            this.accountList(Stream.of(accountList).map(c -> (AccountInfo)((AccountInfo.Builder)AccountInfo.builder().applyMutation(c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListAccountsResponse build() {
            return new ListAccountsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SsoResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAccountsResponse> {
        public Builder nextToken(String var1);

        public Builder accountList(Collection<AccountInfo> var1);

        public Builder accountList(AccountInfo ... var1);

        public Builder accountList(Consumer<AccountInfo.Builder> ... var1);
    }
}

