/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sso.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sso.SsoClient;
import software.amazon.awssdk.services.sso.internal.UserAgentUtils;
import software.amazon.awssdk.services.sso.model.AccountInfo;
import software.amazon.awssdk.services.sso.model.ListAccountsRequest;
import software.amazon.awssdk.services.sso.model.ListAccountsResponse;

public class ListAccountsIterable
implements SdkIterable<ListAccountsResponse> {
    private final SsoClient client;
    private final ListAccountsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAccountsIterable(SsoClient client, ListAccountsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListAccountsResponseFetcher();
    }

    @Override
    public Iterator<ListAccountsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<AccountInfo> accountList() {
        Function<ListAccountsResponse, Iterator> getIterator = response -> {
            if (response != null && response.accountList() != null) {
                return response.accountList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable(this).itemIteratorFunction(getIterator).build();
    }

    private class ListAccountsResponseFetcher
    implements SyncPageFetcher<ListAccountsResponse> {
        private ListAccountsResponseFetcher() {
        }

        @Override
        public boolean hasNextPage(ListAccountsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable(previousPage.nextToken());
        }

        @Override
        public ListAccountsResponse nextPage(ListAccountsResponse previousPage) {
            if (previousPage == null) {
                return ListAccountsIterable.this.client.listAccounts(ListAccountsIterable.this.firstRequest);
            }
            return ListAccountsIterable.this.client.listAccounts((ListAccountsRequest)ListAccountsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build());
        }
    }
}

