/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssoadmin.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum KmsKeyType {
    AWS_OWNED_KMS_KEY("AWS_OWNED_KMS_KEY"),
    CUSTOMER_MANAGED_KEY("CUSTOMER_MANAGED_KEY"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, KmsKeyType> VALUE_MAP;
    private final String value;

    private KmsKeyType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static KmsKeyType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<KmsKeyType> knownValues() {
        EnumSet<KmsKeyType> knownValues = EnumSet.allOf(KmsKeyType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(KmsKeyType.class, KmsKeyType::toString);
    }
}

