/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssoadmin.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ssoadmin.model.AccountListCopier;
import software.amazon.awssdk.services.ssoadmin.model.SsoAdminResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAccountsForProvisionedPermissionSetResponse
extends SsoAdminResponse
implements ToCopyableBuilder<Builder, ListAccountsForProvisionedPermissionSetResponse> {
    private static final SdkField<List<String>> ACCOUNT_IDS_FIELD = SdkField.builder(MarshallingType.LIST).memberName("AccountIds").getter(ListAccountsForProvisionedPermissionSetResponse.getter(ListAccountsForProvisionedPermissionSetResponse::accountIds)).setter(ListAccountsForProvisionedPermissionSetResponse.setter(Builder::accountIds)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder(MarshallingType.STRING).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()).build()).build()).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder(MarshallingType.STRING).memberName("NextToken").getter(ListAccountsForProvisionedPermissionSetResponse.getter(ListAccountsForProvisionedPermissionSetResponse::nextToken)).setter(ListAccountsForProvisionedPermissionSetResponse.setter(Builder::nextToken)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_IDS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListAccountsForProvisionedPermissionSetResponse.memberNameToFieldInitializer();
    private final List<String> accountIds;
    private final String nextToken;

    private ListAccountsForProvisionedPermissionSetResponse(BuilderImpl builder) {
        super(builder);
        this.accountIds = builder.accountIds;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasAccountIds() {
        return this.accountIds != null && !(this.accountIds instanceof SdkAutoConstructList);
    }

    public final List<String> accountIds() {
        return this.accountIds;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAccountIds() ? this.accountIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAccountsForProvisionedPermissionSetResponse)) {
            return false;
        }
        ListAccountsForProvisionedPermissionSetResponse other = (ListAccountsForProvisionedPermissionSetResponse)obj;
        return this.hasAccountIds() == other.hasAccountIds() && Objects.equals(this.accountIds(), other.accountIds()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder("ListAccountsForProvisionedPermissionSetResponse").add("AccountIds", this.hasAccountIds() ? this.accountIds() : null).add("NextToken", this.nextToken()).build();
    }

    @Override
    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccountIds": {
                return Optional.ofNullable(clazz.cast(this.accountIds()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<Object>> map = new HashMap<String, SdkField<Object>>();
        map.put("AccountIds", ACCOUNT_IDS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListAccountsForProvisionedPermissionSetResponse, T> g) {
        return obj -> g.apply((ListAccountsForProvisionedPermissionSetResponse)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsoAdminResponse.BuilderImpl
    implements Builder {
        private List<String> accountIds = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAccountsForProvisionedPermissionSetResponse model) {
            super(model);
            this.accountIds(model.accountIds);
            this.nextToken(model.nextToken);
        }

        public final Collection<String> getAccountIds() {
            if (this.accountIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.accountIds;
        }

        public final void setAccountIds(Collection<String> accountIds) {
            this.accountIds = AccountListCopier.copy(accountIds);
        }

        @Override
        public final Builder accountIds(Collection<String> accountIds) {
            this.accountIds = AccountListCopier.copy(accountIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountIds(String ... accountIds) {
            this.accountIds(Arrays.asList(accountIds));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListAccountsForProvisionedPermissionSetResponse build() {
            return new ListAccountsForProvisionedPermissionSetResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SsoAdminResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAccountsForProvisionedPermissionSetResponse> {
        public Builder accountIds(Collection<String> var1);

        public Builder accountIds(String ... var1);

        public Builder nextToken(String var1);
    }
}

