/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssoadmin.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ssoadmin.model.ScopeDetails;
import software.amazon.awssdk.services.ssoadmin.model.ScopesCopier;
import software.amazon.awssdk.services.ssoadmin.model.SsoAdminResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListApplicationAccessScopesResponse
extends SsoAdminResponse
implements ToCopyableBuilder<Builder, ListApplicationAccessScopesResponse> {
    private static final SdkField<List<ScopeDetails>> SCOPES_FIELD = SdkField.builder(MarshallingType.LIST).memberName("Scopes").getter(ListApplicationAccessScopesResponse.getter(ListApplicationAccessScopesResponse::scopes)).setter(ListApplicationAccessScopesResponse.setter(Builder::scopes)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Scopes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder(MarshallingType.SDK_POJO).constructor(ScopeDetails::builder).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()).build()).build()).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder(MarshallingType.STRING).memberName("NextToken").getter(ListApplicationAccessScopesResponse.getter(ListApplicationAccessScopesResponse::nextToken)).setter(ListApplicationAccessScopesResponse.setter(Builder::nextToken)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCOPES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListApplicationAccessScopesResponse.memberNameToFieldInitializer();
    private final List<ScopeDetails> scopes;
    private final String nextToken;

    private ListApplicationAccessScopesResponse(BuilderImpl builder) {
        super(builder);
        this.scopes = builder.scopes;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasScopes() {
        return this.scopes != null && !(this.scopes instanceof SdkAutoConstructList);
    }

    public final List<ScopeDetails> scopes() {
        return this.scopes;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasScopes() ? this.scopes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListApplicationAccessScopesResponse)) {
            return false;
        }
        ListApplicationAccessScopesResponse other = (ListApplicationAccessScopesResponse)obj;
        return this.hasScopes() == other.hasScopes() && Objects.equals(this.scopes(), other.scopes()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder("ListApplicationAccessScopesResponse").add("Scopes", this.hasScopes() ? this.scopes() : null).add("NextToken", this.nextToken()).build();
    }

    @Override
    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Scopes": {
                return Optional.ofNullable(clazz.cast(this.scopes()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<Object>> map = new HashMap<String, SdkField<Object>>();
        map.put("Scopes", SCOPES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListApplicationAccessScopesResponse, T> g) {
        return obj -> g.apply((ListApplicationAccessScopesResponse)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsoAdminResponse.BuilderImpl
    implements Builder {
        private List<ScopeDetails> scopes = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListApplicationAccessScopesResponse model) {
            super(model);
            this.scopes(model.scopes);
            this.nextToken(model.nextToken);
        }

        public final List<ScopeDetails.Builder> getScopes() {
            List<ScopeDetails.Builder> result = ScopesCopier.copyToBuilder(this.scopes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setScopes(Collection<ScopeDetails.BuilderImpl> scopes) {
            this.scopes = ScopesCopier.copyFromBuilder(scopes);
        }

        @Override
        public final Builder scopes(Collection<ScopeDetails> scopes) {
            this.scopes = ScopesCopier.copy(scopes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scopes(ScopeDetails ... scopes) {
            this.scopes(Arrays.asList(scopes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scopes(Consumer<ScopeDetails.Builder> ... scopes) {
            this.scopes(Stream.of(scopes).map(c -> (ScopeDetails)((ScopeDetails.Builder)ScopeDetails.builder().applyMutation(c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListApplicationAccessScopesResponse build() {
            return new ListApplicationAccessScopesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SsoAdminResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListApplicationAccessScopesResponse> {
        public Builder scopes(Collection<ScopeDetails> var1);

        public Builder scopes(ScopeDetails ... var1);

        public Builder scopes(Consumer<ScopeDetails.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

