/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssoadmin.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.services.ssoadmin.model.JwksRetrievalOption;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OidcJwtConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OidcJwtConfiguration> {
    private static final SdkField<String> ISSUER_URL_FIELD = SdkField.builder(MarshallingType.STRING).memberName("IssuerUrl").getter(OidcJwtConfiguration.getter(OidcJwtConfiguration::issuerUrl)).setter(OidcJwtConfiguration.setter(Builder::issuerUrl)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IssuerUrl").build()).build();
    private static final SdkField<String> CLAIM_ATTRIBUTE_PATH_FIELD = SdkField.builder(MarshallingType.STRING).memberName("ClaimAttributePath").getter(OidcJwtConfiguration.getter(OidcJwtConfiguration::claimAttributePath)).setter(OidcJwtConfiguration.setter(Builder::claimAttributePath)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClaimAttributePath").build()).build();
    private static final SdkField<String> IDENTITY_STORE_ATTRIBUTE_PATH_FIELD = SdkField.builder(MarshallingType.STRING).memberName("IdentityStoreAttributePath").getter(OidcJwtConfiguration.getter(OidcJwtConfiguration::identityStoreAttributePath)).setter(OidcJwtConfiguration.setter(Builder::identityStoreAttributePath)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityStoreAttributePath").build()).build();
    private static final SdkField<String> JWKS_RETRIEVAL_OPTION_FIELD = SdkField.builder(MarshallingType.STRING).memberName("JwksRetrievalOption").getter(OidcJwtConfiguration.getter(OidcJwtConfiguration::jwksRetrievalOptionAsString)).setter(OidcJwtConfiguration.setter(Builder::jwksRetrievalOption)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JwksRetrievalOption").build()).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ISSUER_URL_FIELD, CLAIM_ATTRIBUTE_PATH_FIELD, IDENTITY_STORE_ATTRIBUTE_PATH_FIELD, JWKS_RETRIEVAL_OPTION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = OidcJwtConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String issuerUrl;
    private final String claimAttributePath;
    private final String identityStoreAttributePath;
    private final String jwksRetrievalOption;

    private OidcJwtConfiguration(BuilderImpl builder) {
        this.issuerUrl = builder.issuerUrl;
        this.claimAttributePath = builder.claimAttributePath;
        this.identityStoreAttributePath = builder.identityStoreAttributePath;
        this.jwksRetrievalOption = builder.jwksRetrievalOption;
    }

    public final String issuerUrl() {
        return this.issuerUrl;
    }

    public final String claimAttributePath() {
        return this.claimAttributePath;
    }

    public final String identityStoreAttributePath() {
        return this.identityStoreAttributePath;
    }

    public final JwksRetrievalOption jwksRetrievalOption() {
        return JwksRetrievalOption.fromValue(this.jwksRetrievalOption);
    }

    public final String jwksRetrievalOptionAsString() {
        return this.jwksRetrievalOption;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.issuerUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.claimAttributePath());
        hashCode = 31 * hashCode + Objects.hashCode(this.identityStoreAttributePath());
        hashCode = 31 * hashCode + Objects.hashCode(this.jwksRetrievalOptionAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OidcJwtConfiguration)) {
            return false;
        }
        OidcJwtConfiguration other = (OidcJwtConfiguration)obj;
        return Objects.equals(this.issuerUrl(), other.issuerUrl()) && Objects.equals(this.claimAttributePath(), other.claimAttributePath()) && Objects.equals(this.identityStoreAttributePath(), other.identityStoreAttributePath()) && Objects.equals(this.jwksRetrievalOptionAsString(), other.jwksRetrievalOptionAsString());
    }

    public final String toString() {
        return ToString.builder("OidcJwtConfiguration").add("IssuerUrl", this.issuerUrl()).add("ClaimAttributePath", this.claimAttributePath()).add("IdentityStoreAttributePath", this.identityStoreAttributePath()).add("JwksRetrievalOption", this.jwksRetrievalOptionAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IssuerUrl": {
                return Optional.ofNullable(clazz.cast(this.issuerUrl()));
            }
            case "ClaimAttributePath": {
                return Optional.ofNullable(clazz.cast(this.claimAttributePath()));
            }
            case "IdentityStoreAttributePath": {
                return Optional.ofNullable(clazz.cast(this.identityStoreAttributePath()));
            }
            case "JwksRetrievalOption": {
                return Optional.ofNullable(clazz.cast(this.jwksRetrievalOptionAsString()));
            }
        }
        return Optional.empty();
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("IssuerUrl", ISSUER_URL_FIELD);
        map.put("ClaimAttributePath", CLAIM_ATTRIBUTE_PATH_FIELD);
        map.put("IdentityStoreAttributePath", IDENTITY_STORE_ATTRIBUTE_PATH_FIELD);
        map.put("JwksRetrievalOption", JWKS_RETRIEVAL_OPTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OidcJwtConfiguration, T> g) {
        return obj -> g.apply((OidcJwtConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String issuerUrl;
        private String claimAttributePath;
        private String identityStoreAttributePath;
        private String jwksRetrievalOption;

        private BuilderImpl() {
        }

        private BuilderImpl(OidcJwtConfiguration model) {
            this.issuerUrl(model.issuerUrl);
            this.claimAttributePath(model.claimAttributePath);
            this.identityStoreAttributePath(model.identityStoreAttributePath);
            this.jwksRetrievalOption(model.jwksRetrievalOption);
        }

        public final String getIssuerUrl() {
            return this.issuerUrl;
        }

        public final void setIssuerUrl(String issuerUrl) {
            this.issuerUrl = issuerUrl;
        }

        @Override
        public final Builder issuerUrl(String issuerUrl) {
            this.issuerUrl = issuerUrl;
            return this;
        }

        public final String getClaimAttributePath() {
            return this.claimAttributePath;
        }

        public final void setClaimAttributePath(String claimAttributePath) {
            this.claimAttributePath = claimAttributePath;
        }

        @Override
        public final Builder claimAttributePath(String claimAttributePath) {
            this.claimAttributePath = claimAttributePath;
            return this;
        }

        public final String getIdentityStoreAttributePath() {
            return this.identityStoreAttributePath;
        }

        public final void setIdentityStoreAttributePath(String identityStoreAttributePath) {
            this.identityStoreAttributePath = identityStoreAttributePath;
        }

        @Override
        public final Builder identityStoreAttributePath(String identityStoreAttributePath) {
            this.identityStoreAttributePath = identityStoreAttributePath;
            return this;
        }

        public final String getJwksRetrievalOption() {
            return this.jwksRetrievalOption;
        }

        public final void setJwksRetrievalOption(String jwksRetrievalOption) {
            this.jwksRetrievalOption = jwksRetrievalOption;
        }

        @Override
        public final Builder jwksRetrievalOption(String jwksRetrievalOption) {
            this.jwksRetrievalOption = jwksRetrievalOption;
            return this;
        }

        @Override
        public final Builder jwksRetrievalOption(JwksRetrievalOption jwksRetrievalOption) {
            this.jwksRetrievalOption(jwksRetrievalOption == null ? null : jwksRetrievalOption.toString());
            return this;
        }

        @Override
        public OidcJwtConfiguration build() {
            return new OidcJwtConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OidcJwtConfiguration> {
        public Builder issuerUrl(String var1);

        public Builder claimAttributePath(String var1);

        public Builder identityStoreAttributePath(String var1);

        public Builder jwksRetrievalOption(String var1);

        public Builder jwksRetrievalOption(JwksRetrievalOption var1);
    }
}

