/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssoadmin.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ssoadmin.model.SsoAdminRequest;
import software.amazon.awssdk.services.ssoadmin.model.TagKeyListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UntagResourceRequest
extends SsoAdminRequest
implements ToCopyableBuilder<Builder, UntagResourceRequest> {
    private static final SdkField<String> INSTANCE_ARN_FIELD = SdkField.builder(MarshallingType.STRING).memberName("InstanceArn").getter(UntagResourceRequest.getter(UntagResourceRequest::instanceArn)).setter(UntagResourceRequest.setter(Builder::instanceArn)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceArn").build()).build();
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.builder(MarshallingType.STRING).memberName("ResourceArn").getter(UntagResourceRequest.getter(UntagResourceRequest::resourceArn)).setter(UntagResourceRequest.setter(Builder::resourceArn)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceArn").build()).build();
    private static final SdkField<List<String>> TAG_KEYS_FIELD = SdkField.builder(MarshallingType.LIST).memberName("TagKeys").getter(UntagResourceRequest.getter(UntagResourceRequest::tagKeys)).setter(UntagResourceRequest.setter(Builder::tagKeys)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagKeys").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder(MarshallingType.STRING).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()).build()).build()).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ARN_FIELD, RESOURCE_ARN_FIELD, TAG_KEYS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UntagResourceRequest.memberNameToFieldInitializer();
    private final String instanceArn;
    private final String resourceArn;
    private final List<String> tagKeys;

    private UntagResourceRequest(BuilderImpl builder) {
        super(builder);
        this.instanceArn = builder.instanceArn;
        this.resourceArn = builder.resourceArn;
        this.tagKeys = builder.tagKeys;
    }

    public final String instanceArn() {
        return this.instanceArn;
    }

    public final String resourceArn() {
        return this.resourceArn;
    }

    public final boolean hasTagKeys() {
        return this.tagKeys != null && !(this.tagKeys instanceof SdkAutoConstructList);
    }

    public final List<String> tagKeys() {
        return this.tagKeys;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTagKeys() ? this.tagKeys() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UntagResourceRequest)) {
            return false;
        }
        UntagResourceRequest other = (UntagResourceRequest)obj;
        return Objects.equals(this.instanceArn(), other.instanceArn()) && Objects.equals(this.resourceArn(), other.resourceArn()) && this.hasTagKeys() == other.hasTagKeys() && Objects.equals(this.tagKeys(), other.tagKeys());
    }

    public final String toString() {
        return ToString.builder("UntagResourceRequest").add("InstanceArn", this.instanceArn()).add("ResourceArn", this.resourceArn()).add("TagKeys", this.hasTagKeys() ? this.tagKeys() : null).build();
    }

    @Override
    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceArn": {
                return Optional.ofNullable(clazz.cast(this.instanceArn()));
            }
            case "ResourceArn": {
                return Optional.ofNullable(clazz.cast(this.resourceArn()));
            }
            case "TagKeys": {
                return Optional.ofNullable(clazz.cast(this.tagKeys()));
            }
        }
        return Optional.empty();
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<Object>> map = new HashMap<String, SdkField<Object>>();
        map.put("InstanceArn", INSTANCE_ARN_FIELD);
        map.put("ResourceArn", RESOURCE_ARN_FIELD);
        map.put("TagKeys", TAG_KEYS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UntagResourceRequest, T> g) {
        return obj -> g.apply((UntagResourceRequest)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsoAdminRequest.BuilderImpl
    implements Builder {
        private String instanceArn;
        private String resourceArn;
        private List<String> tagKeys = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UntagResourceRequest model) {
            super(model);
            this.instanceArn(model.instanceArn);
            this.resourceArn(model.resourceArn);
            this.tagKeys(model.tagKeys);
        }

        public final String getInstanceArn() {
            return this.instanceArn;
        }

        public final void setInstanceArn(String instanceArn) {
            this.instanceArn = instanceArn;
        }

        @Override
        public final Builder instanceArn(String instanceArn) {
            this.instanceArn = instanceArn;
            return this;
        }

        public final String getResourceArn() {
            return this.resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final Collection<String> getTagKeys() {
            if (this.tagKeys instanceof SdkAutoConstructList) {
                return null;
            }
            return this.tagKeys;
        }

        public final void setTagKeys(Collection<String> tagKeys) {
            this.tagKeys = TagKeyListCopier.copy(tagKeys);
        }

        @Override
        public final Builder tagKeys(Collection<String> tagKeys) {
            this.tagKeys = TagKeyListCopier.copy(tagKeys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagKeys(String ... tagKeys) {
            this.tagKeys(Arrays.asList(tagKeys));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UntagResourceRequest build() {
            return new UntagResourceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SsoAdminRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UntagResourceRequest> {
        public Builder instanceArn(String var1);

        public Builder resourceArn(String var1);

        public Builder tagKeys(Collection<String> var1);

        public Builder tagKeys(String ... var1);

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

