/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssoadmin.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ssoadmin.SsoAdminAsyncClient;
import software.amazon.awssdk.services.ssoadmin.internal.UserAgentUtils;
import software.amazon.awssdk.services.ssoadmin.model.AccountAssignmentForPrincipal;
import software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentsForPrincipalRequest;
import software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentsForPrincipalResponse;

public class ListAccountAssignmentsForPrincipalPublisher
implements SdkPublisher<ListAccountAssignmentsForPrincipalResponse> {
    private final SsoAdminAsyncClient client;
    private final ListAccountAssignmentsForPrincipalRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAccountAssignmentsForPrincipalPublisher(SsoAdminAsyncClient client, ListAccountAssignmentsForPrincipalRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAccountAssignmentsForPrincipalPublisher(SsoAdminAsyncClient client, ListAccountAssignmentsForPrincipalRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAccountAssignmentsForPrincipalResponseFetcher();
    }

    @Override
    public void subscribe(Subscriber<? super ListAccountAssignmentsForPrincipalResponse> subscriber) {
        subscriber.onSubscribe(((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<AccountAssignmentForPrincipal> accountAssignments() {
        Function<ListAccountAssignmentsForPrincipalResponse, Iterator> getIterator = response -> {
            if (response != null && response.accountAssignments() != null) {
                return response.accountAssignments().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher(new ListAccountAssignmentsForPrincipalResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListAccountAssignmentsForPrincipalResponseFetcher
    implements AsyncPageFetcher<ListAccountAssignmentsForPrincipalResponse> {
        private ListAccountAssignmentsForPrincipalResponseFetcher() {
        }

        @Override
        public boolean hasNextPage(ListAccountAssignmentsForPrincipalResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable(previousPage.nextToken());
        }

        @Override
        public CompletableFuture<ListAccountAssignmentsForPrincipalResponse> nextPage(ListAccountAssignmentsForPrincipalResponse previousPage) {
            if (previousPage == null) {
                return ListAccountAssignmentsForPrincipalPublisher.this.client.listAccountAssignmentsForPrincipal(ListAccountAssignmentsForPrincipalPublisher.this.firstRequest);
            }
            return ListAccountAssignmentsForPrincipalPublisher.this.client.listAccountAssignmentsForPrincipal((ListAccountAssignmentsForPrincipalRequest)ListAccountAssignmentsForPrincipalPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build());
        }
    }
}

