/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssoadmin.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ssoadmin.SsoAdminAsyncClient;
import software.amazon.awssdk.services.ssoadmin.internal.UserAgentUtils;
import software.amazon.awssdk.services.ssoadmin.model.ListApplicationAccessScopesRequest;
import software.amazon.awssdk.services.ssoadmin.model.ListApplicationAccessScopesResponse;
import software.amazon.awssdk.services.ssoadmin.model.ScopeDetails;

public class ListApplicationAccessScopesPublisher
implements SdkPublisher<ListApplicationAccessScopesResponse> {
    private final SsoAdminAsyncClient client;
    private final ListApplicationAccessScopesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListApplicationAccessScopesPublisher(SsoAdminAsyncClient client, ListApplicationAccessScopesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListApplicationAccessScopesPublisher(SsoAdminAsyncClient client, ListApplicationAccessScopesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListApplicationAccessScopesResponseFetcher();
    }

    @Override
    public void subscribe(Subscriber<? super ListApplicationAccessScopesResponse> subscriber) {
        subscriber.onSubscribe(((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ScopeDetails> scopes() {
        Function<ListApplicationAccessScopesResponse, Iterator> getIterator = response -> {
            if (response != null && response.scopes() != null) {
                return response.scopes().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher(new ListApplicationAccessScopesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListApplicationAccessScopesResponseFetcher
    implements AsyncPageFetcher<ListApplicationAccessScopesResponse> {
        private ListApplicationAccessScopesResponseFetcher() {
        }

        @Override
        public boolean hasNextPage(ListApplicationAccessScopesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable(previousPage.nextToken());
        }

        @Override
        public CompletableFuture<ListApplicationAccessScopesResponse> nextPage(ListApplicationAccessScopesResponse previousPage) {
            if (previousPage == null) {
                return ListApplicationAccessScopesPublisher.this.client.listApplicationAccessScopes(ListApplicationAccessScopesPublisher.this.firstRequest);
            }
            return ListApplicationAccessScopesPublisher.this.client.listApplicationAccessScopes((ListApplicationAccessScopesRequest)ListApplicationAccessScopesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build());
        }
    }
}

