/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssoadmin.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ssoadmin.SsoAdminAsyncClient;
import software.amazon.awssdk.services.ssoadmin.internal.UserAgentUtils;
import software.amazon.awssdk.services.ssoadmin.model.ApplicationAssignment;
import software.amazon.awssdk.services.ssoadmin.model.ListApplicationAssignmentsRequest;
import software.amazon.awssdk.services.ssoadmin.model.ListApplicationAssignmentsResponse;

public class ListApplicationAssignmentsPublisher
implements SdkPublisher<ListApplicationAssignmentsResponse> {
    private final SsoAdminAsyncClient client;
    private final ListApplicationAssignmentsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListApplicationAssignmentsPublisher(SsoAdminAsyncClient client, ListApplicationAssignmentsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListApplicationAssignmentsPublisher(SsoAdminAsyncClient client, ListApplicationAssignmentsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListApplicationAssignmentsResponseFetcher();
    }

    @Override
    public void subscribe(Subscriber<? super ListApplicationAssignmentsResponse> subscriber) {
        subscriber.onSubscribe(((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ApplicationAssignment> applicationAssignments() {
        Function<ListApplicationAssignmentsResponse, Iterator> getIterator = response -> {
            if (response != null && response.applicationAssignments() != null) {
                return response.applicationAssignments().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher(new ListApplicationAssignmentsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListApplicationAssignmentsResponseFetcher
    implements AsyncPageFetcher<ListApplicationAssignmentsResponse> {
        private ListApplicationAssignmentsResponseFetcher() {
        }

        @Override
        public boolean hasNextPage(ListApplicationAssignmentsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable(previousPage.nextToken());
        }

        @Override
        public CompletableFuture<ListApplicationAssignmentsResponse> nextPage(ListApplicationAssignmentsResponse previousPage) {
            if (previousPage == null) {
                return ListApplicationAssignmentsPublisher.this.client.listApplicationAssignments(ListApplicationAssignmentsPublisher.this.firstRequest);
            }
            return ListApplicationAssignmentsPublisher.this.client.listApplicationAssignments((ListApplicationAssignmentsRequest)ListApplicationAssignmentsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build());
        }
    }
}

