/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssoadmin.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ssoadmin.SsoAdminAsyncClient;
import software.amazon.awssdk.services.ssoadmin.internal.UserAgentUtils;
import software.amazon.awssdk.services.ssoadmin.model.ApplicationProvider;
import software.amazon.awssdk.services.ssoadmin.model.ListApplicationProvidersRequest;
import software.amazon.awssdk.services.ssoadmin.model.ListApplicationProvidersResponse;

public class ListApplicationProvidersPublisher
implements SdkPublisher<ListApplicationProvidersResponse> {
    private final SsoAdminAsyncClient client;
    private final ListApplicationProvidersRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListApplicationProvidersPublisher(SsoAdminAsyncClient client, ListApplicationProvidersRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListApplicationProvidersPublisher(SsoAdminAsyncClient client, ListApplicationProvidersRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListApplicationProvidersResponseFetcher();
    }

    @Override
    public void subscribe(Subscriber<? super ListApplicationProvidersResponse> subscriber) {
        subscriber.onSubscribe(((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ApplicationProvider> applicationProviders() {
        Function<ListApplicationProvidersResponse, Iterator> getIterator = response -> {
            if (response != null && response.applicationProviders() != null) {
                return response.applicationProviders().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher(new ListApplicationProvidersResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListApplicationProvidersResponseFetcher
    implements AsyncPageFetcher<ListApplicationProvidersResponse> {
        private ListApplicationProvidersResponseFetcher() {
        }

        @Override
        public boolean hasNextPage(ListApplicationProvidersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable(previousPage.nextToken());
        }

        @Override
        public CompletableFuture<ListApplicationProvidersResponse> nextPage(ListApplicationProvidersResponse previousPage) {
            if (previousPage == null) {
                return ListApplicationProvidersPublisher.this.client.listApplicationProviders(ListApplicationProvidersPublisher.this.firstRequest);
            }
            return ListApplicationProvidersPublisher.this.client.listApplicationProviders((ListApplicationProvidersRequest)ListApplicationProvidersPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build());
        }
    }
}

